/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersConstants;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;
import travelers.server.animal.entity.other.IPartHaver;
import travelers.server.animal.entity.other.TravelersAnimalAnimationModule;
import travelers.server.animal.entity.other.TravelersBodyRotationControl;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.vanilla.EmptyMoveControl;
import travelers.server.animal.entity.pathingsystem.vanilla.EmptyNavigation;
import travelers.server.animal.entity.task.TravelerTaskController;
import travelers.server.animal.obj.IAnimalHolder;
import travelers.server.animal.obj.TravelersMoveAnalysis;
import travelers.server.entity.AnimalEntityPart;

public abstract class SmartAnimalBase
extends class_1314
implements IAnimalHolder {
    protected final TravelersMoveAnalysis moveAnalysis;
    private final Map<TravelersPathType, Float> pathfindingMalus = Maps.newEnumMap(TravelersPathType.class);
    private final TravelersAnimal<?> animal;
    private final HashMap<String, AnimalEntityPart> subEntities = new HashMap();
    protected TravelersMoveControl moveController;
    protected TravelersPathNavigation navigationController;
    protected boolean freezeAnimator;
    private TravelerTaskController taskController;
    private TravelerTaskController combatController;
    private TravelersAnimalAnimationModule animationModule;
    private float previousYaw = 0.0f;
    private double curSpeed = 0.0;

    public SmartAnimalBase(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        class_2960 id = class_1299.method_5890(entityType);
        this.animal = TravelersAnimalRegistry.getAnimalFromType(id.method_12836(), entityType);
        if (this.animal == null) {
            throw new RuntimeException("No Animal Found for " + String.valueOf(entityType));
        }
        if (this.animal.getAnimalAttributes().getEntityAttributeProperties().isPersistent()) {
            this.method_5971();
        }
        this.field_6207 = new EmptyMoveControl((class_1308)this);
        this.moveAnalysis = new TravelersMoveAnalysis(this, 2);
        this.navigationController = this.createNavigationController(level);
        if (!level.field_9236) {
            this.addTasksToController(this.getTaskController(), this.getCombatTargeting());
        }
    }

    @NotNull
    protected class_1330 method_5963() {
        return new TravelersBodyRotationControl(this);
    }

    public float method_6029() {
        double speed = 0.0;
        double baseSpeed = this.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
        float scale = this.method_55693();
        if (scale != 1.0f) {
            baseSpeed /= (double)scale;
        }
        float currentYaw = this.method_36454();
        float turningAmount = Math.abs(currentYaw - this.previousYaw);
        turningAmount = (turningAmount + 180.0f) % 360.0f - 180.0f;
        if ((turningAmount = Math.abs(turningAmount)) > 5.0f) {
            float turnSlowdown = Math.min(1.0f, turningAmount / 90.0f);
            baseSpeed *= (double)(1.0f - 0.3f * turnSlowdown);
        }
        if (this.isRunning()) {
            speed = class_3532.method_16436((double)0.1, (double)this.curSpeed, (double)(baseSpeed * this.animal.getAnimalAttributes().getEntityAttributeProperties().getRunningSpeedMultiplier()));
        } else if (this.method_5799()) {
            speed = class_3532.method_16436((double)0.1, (double)this.curSpeed, (double)(baseSpeed * this.animal.getAnimalAttributes().getEntityAttributeProperties().getSwimmingSpeedMultiplier()));
        } else if (this.getNavigationController().isInProgress()) {
            speed = class_3532.method_16436((double)0.1, (double)this.curSpeed, (double)baseSpeed);
        }
        this.previousYaw = currentYaw;
        this.curSpeed = speed;
        return (float)speed;
    }

    public boolean isRunning() {
        return !(!this.method_6510() && !this.method_52546() || this.method_5799() && !this.canRunInWater());
    }

    protected abstract boolean canRunInWater();

    protected abstract TravelersPathNavigation createNavigationController(class_1937 var1);

    public float method_6144(@NotNull class_2338 pos, @NotNull class_4538 level) {
        return this.isAnimal() ? (level.method_8320(pos.method_10074()).method_27852(class_2246.field_10219) ? 10.0f : level.method_42309(pos)) : super.method_6144(pos, level);
    }

    public void addSubEntity(String string, AnimalEntityPart entityPart) {
        if (!(this instanceof IPartHaver)) {
            TravelersConstants.LOGGER.error("You added a subentity to an entity that doesn't implement IPartHaver<?>");
            return;
        }
        this.subEntities.put(string, entityPart);
    }

    public void method_5838(int id) {
        super.method_5838(id);
        if (this instanceof IPartHaver) {
            for (AnimalEntityPart value : this.subEntities.values()) {
                value.method_5838(++id);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        this.moveAnalysis.update();
        if (this.method_37908().field_9236) {
            this.clientTick();
        }
    }

    protected void addTasksToController(TravelerTaskController controller, TravelerTaskController combatTargeting) {
    }

    private void clientTick() {
        if (!this.freezeAnimator) {
            this.animal.animate(this, this.moveAnalysis, this.getAnimationModule());
        } else {
            this.freezeAnimator = false;
        }
        TravelersAnimationMap.tick(this);
    }

    public boolean isAnimal() {
        return false;
    }

    public final void method_5941(@NotNull class_7 pathType, float malus) {
    }

    public void setPathfindingMalus(TravelersPathType pathType, float malus) {
        this.pathfindingMalus.put(pathType, Float.valueOf(malus));
    }

    public float getPathfindingMalus(TravelersPathType pathType) {
        Float f = this.pathfindingMalus.get((Object)pathType);
        return f == null ? pathType.getMalus() : f.floatValue();
    }

    protected final void method_5959() {
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new EmptyNavigation((class_1308)this, this.method_37908());
    }

    public void method_6007() {
        super.method_6007();
    }

    protected void method_5958() {
        this.getTaskController().tickController();
        this.getCombatTargeting().tickController();
        if (this.moveController != null) {
            this.moveController.tick();
        }
        if (this.navigationController != null) {
            this.navigationController.tick();
        }
        if (!this.freezeAnimator) {
            this.animal.animateServer(this, this.moveAnalysis, this.getAnimationModule());
        } else {
            this.freezeAnimator = false;
        }
    }

    public void method_55695() {
        this.getNavigationController().stop();
        this.method_5938(0.0f);
        this.method_5976(0.0f);
        this.method_6125(0.0f);
    }

    public boolean avoidsLight() {
        return false;
    }

    public TravelerTaskController getTaskController() {
        if (this.taskController == null) {
            this.taskController = new TravelerTaskController();
        }
        return this.taskController;
    }

    public TravelerTaskController getCombatTargeting() {
        if (this.combatController == null) {
            this.combatController = new TravelerTaskController();
        }
        return this.combatController;
    }

    public double jumpHeight() {
        return this.method_49476();
    }

    public boolean canMove() {
        return true;
    }

    public boolean isAmphibian() {
        return false;
    }

    @Override
    public TravelersAnimal<?> getAnimal() {
        return this.animal;
    }

    public float getTurnMultiplier() {
        return 1.0f;
    }

    public float method_55693() {
        return 1.0f;
    }

    public TravelersAnimalAnimationModule getAnimationModule() {
        if (this.animationModule == null) {
            this.animationModule = new TravelersAnimalAnimationModule(this);
        }
        return this.animationModule;
    }

    public float getRenderScale() {
        return (float)this.getAnimal().getAnimalAttributes().getEntityBaseProperties().getRenderScale();
    }

    public double climbHeight() {
        return 10.0;
    }

    public TravelersMoveAnalysis getMoveAnalysis() {
        return this.moveAnalysis;
    }

    public HashMap<String, AnimalEntityPart> getSubEntities() {
        return this.subEntities;
    }

    public TravelersMoveControl getMoveController() {
        return this.moveController;
    }

    public void setMoveController(TravelersMoveControl moveController) {
        this.moveController = moveController;
    }

    public TravelersPathNavigation getNavigationController() {
        return this.navigationController;
    }

    public void setNavigationController(TravelersPathNavigation navigationController) {
        this.navigationController = navigationController;
    }

    public void setFreezeAnimator(boolean freezeAnimator) {
        this.freezeAnimator = freezeAnimator;
    }
}

