/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersFlyNodeEvaluator;

public class TravelersFlyingNavigation
extends TravelersPathNavigation {
    private final SmartAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public TravelersFlyingNavigation(SmartAnimalBase mob, class_1937 level) {
        super(mob, level);
        this.base = mob;
    }

    @Override
    protected boolean canUpdatePath() {
        return this.canFloat() && this.mob.method_52535() || !this.mob.method_5765();
    }

    @Override
    protected class_243 getTempMobPos() {
        return this.mob.method_19538();
    }

    @Override
    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isInProgress() && !this.isLookingForPath) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                class_243 vec3 = this.getTempMobPos();
                class_243 vec31 = this.path.getNextEntityPos((class_1297)this.mob);
                if (vec31.method_1025(vec3) <= (double)this.maxDistanceToWaypoint) {
                    this.path.advance();
                }
            }
            if (TravelersMain.isDebugging()) {
                this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
            }
            if (this.isInProgress() && !this.isLookingForPath) {
                if (this.path == null) {
                    return;
                }
                class_243 target = this.path.getNextEntityPos((class_1297)this.mob);
                if (this.mob.method_19538().method_24802((class_2374)target, (double)this.maxDistanceToWaypoint)) {
                    if (this.path.isDone()) {
                        this.stop();
                    }
                } else {
                    this.mob.getMoveController().setWantedPosition(target.field_1352, target.field_1351, target.field_1350, 1.0);
                }
            }
        }
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        class_243 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        } else {
            this.checkStuckOnNode();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
        if (this.path != null && this.path.isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex < 0 || nodeIndex >= this.path.getNodeCount()) {
            return;
        }
        if (this.curNodeIndex == nodeIndex) {
            ++this.nodeStuckTime;
            if (this.nodeStuckTime > 50) {
                this.recomputePath();
            }
            return;
        }
        this.nodeStuckTime = 0;
        this.curNodeIndex = nodeIndex;
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, SmartAnimalBase mob, class_243 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        class_243 vec31 = class_243.method_24953((class_2382)path.getNodePos(nextNodeIndex));
        class_243 pos = mob.method_19538();
        return vec31.method_55230(pos, Math.min(0.5, (double)(mob.method_17681() * 2.0f)), (double)(mob.method_17682() * 2.0f));
    }

    @Override
    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersFlyNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

