/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animal.azure;

import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import travelers.client.render.animal.azure.TravelersAzureAnimalPipeline;
import travelers.client.render.animation.entity.TravelersAnimationMap;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersClientAnimator;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersAzureModelRenderer
extends AzEntityModelRenderer<SmartAnimalBase> {
    private final TravelersAzureAnimalPipeline entityRendererPipeline;
    private TravelersClientAnimator animalAnimator = null;
    private boolean checkForAnimator = true;
    private boolean hasAnimator = false;

    public TravelersAzureModelRenderer(TravelersAzureAnimalPipeline entityRendererPipeline, AzLayerRenderer<SmartAnimalBase> layerRenderer) {
        super((AzEntityRendererPipeline)entityRendererPipeline, layerRenderer);
        this.entityRendererPipeline = entityRendererPipeline;
    }

    public void render(AzRendererPipelineContext<SmartAnimalBase> context, boolean isReRender) {
        if (this.checkForAnimator) {
            this.getAnimalAnimator((SmartAnimalBase)context.animatable());
        }
        if (this.hasAnimator && !isReRender) {
            TravelersClientAnimator animator = this.getAnimalAnimator((SmartAnimalBase)context.animatable());
            animator.update((SmartAnimalBase)context.animatable(), context.partialTick());
        }
        super.render(context, isReRender);
    }

    public TravelersClientAnimator getAnimalAnimator(SmartAnimalBase base) {
        if (this.animalAnimator == null && this.checkForAnimator) {
            this.animalAnimator = TravelersAnimationMap.get(base);
            this.hasAnimator = this.animalAnimator != null;
            this.checkForAnimator = false;
        }
        return this.animalAnimator;
    }

    public void renderRecursively(AzRendererPipelineContext<SmartAnimalBase> context, AzBone bone, boolean isReRender) {
        SmartAnimalBase entity = (SmartAnimalBase)context.animatable();
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        TravelersBoneState boneState = null;
        if (this.hasAnimator) {
            boneState = this.animalAnimator.updateAnimationOnBone((SmartAnimalBase)context.animatable(), bone.getName());
        }
        RenderUtils.translateMatrixToBone((class_4587)poseStack, (CoreGeoBone)bone);
        if (boneState != null) {
            poseStack.method_46416(boneState.offsetX / 16.0f, -boneState.offsetY / 16.0f, boneState.offsetZ / 16.0f);
        }
        RenderUtils.translateToPivotPoint((class_4587)poseStack, (CoreGeoBone)bone);
        this.rotateMatrixAroundBone(poseStack, boneState, (CoreGeoBone)bone);
        RenderUtils.scaleMatrixForBone((class_4587)poseStack, (CoreGeoBone)bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRendererPipeline.getRenderTranslations());
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.entityRendererPipeline.getModelRenderTranslations()));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)localMatrix, (Vector3f)this.entityRendererPipeline.getRenderer().method_23169((class_1297)entity, 1.0f).method_46409()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix((Matrix4f)new Matrix4f((Matrix4fc)localMatrix), (Vector3f)entity.method_19538().method_46409()));
        }
        RenderUtils.translateAwayFromPivotPoint((class_4587)poseStack, (CoreGeoBone)bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    private void rotateMatrixAroundBone(class_4587 poseStack, TravelersBoneState boneState, CoreGeoBone bone) {
        if (boneState == null) {
            poseStack.method_22907(class_7833.field_40718.rotation(bone.getRotZ()));
            poseStack.method_22907(class_7833.field_40716.rotation(bone.getRotY()));
            poseStack.method_22907(class_7833.field_40714.rotation(bone.getRotX()));
            return;
        }
        poseStack.method_22907(class_7833.field_40718.rotation(bone.getRotZ() + boneState.angleZ));
        poseStack.method_22907(class_7833.field_40716.rotation(bone.getRotY() + boneState.angleY));
        poseStack.method_22907(class_7833.field_40714.rotation(bone.getRotX() + boneState.angleX));
    }
}

