/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersBinaryHeap;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersPathFinder {
    private final TravelersNode[] neighbors = new TravelersNode[64];
    private final int maxVisitedNodes;
    private final TravelersNodeEvaluator nodeEvaluator;
    private final TravelersBinaryHeap openSet = new TravelersBinaryHeap();
    private final List<TravelersTarget> targetList = new ArrayList<TravelersTarget>();
    private final Set<TravelersTarget> reached = new HashSet<TravelersTarget>();

    public TravelersPathFinder(TravelersNodeEvaluator evaluator) {
        this.nodeEvaluator = evaluator;
        this.maxVisitedNodes = 512;
    }

    public CompletableFuture<TravelersPath> findPathAsync(class_1950 region, SmartAnimalBase mob, Set<class_2338> targets, float maxRange, int accuracy, float depthMul) {
        return CompletableFuture.supplyAsync(() -> {
            TravelersPathFinder travelersPathFinder = this;
            synchronized (travelersPathFinder) {
                this.openSet.clear();
                this.reached.clear();
                this.targetList.clear();
                this.nodeEvaluator.prepare(region, mob);
                TravelersNode start = this.nodeEvaluator.getStart();
                if (start == null) {
                    this.nodeEvaluator.done();
                    return null;
                }
                for (class_2338 pos : targets) {
                    TravelersTarget t = this.nodeEvaluator.getTarget(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    t.setTargetPos(pos);
                    this.targetList.add(t);
                }
                TravelersPath path = this.findPath(start, maxRange, accuracy, depthMul);
                this.nodeEvaluator.done();
                return path;
            }
        });
    }

    public TravelersPath findPath(class_1950 region, SmartAnimalBase mob, Set<class_2338> targets, float maxRange, int accuracy, float depthMul) {
        this.openSet.clear();
        this.reached.clear();
        this.targetList.clear();
        this.nodeEvaluator.prepare(region, mob);
        TravelersNode start = this.nodeEvaluator.getStart();
        if (start == null) {
            this.nodeEvaluator.done();
            return null;
        }
        for (class_2338 pos : targets) {
            TravelersTarget t = this.nodeEvaluator.getTarget(pos.method_10263(), pos.method_10264(), pos.method_10260());
            t.setTargetPos(pos);
            this.targetList.add(t);
        }
        TravelersPath path = this.findPath(start, maxRange, accuracy, depthMul);
        this.nodeEvaluator.done();
        return path;
    }

    @Nullable
    private TravelersPath findPath(TravelersNode start, float maxRange, int accuracy, float depthMul) {
        start.g = 0.0f;
        start.walkedDistance = 0.0f;
        start.f = start.h = this.getBestH(start);
        start.cameFrom = null;
        this.openSet.insert(start);
        int visits = 0;
        while (!this.openSet.isEmpty() && visits++ < this.maxVisitedNodes) {
            TravelersNode current = this.openSet.pop();
            current.closed = true;
            for (TravelersTarget target : this.targetList) {
                if (!(current.distanceManhattan(target) < (float)accuracy)) continue;
                target.setReached(true);
                this.reached.add(target);
            }
            if (!this.reached.isEmpty()) break;
            float distFromStart = current.distanceTo(start);
            if (distFromStart >= maxRange) continue;
            int count = this.nodeEvaluator.getNeighbors(this.neighbors, current);
            for (int i = 0; i < count; ++i) {
                TravelersNode neighbor = this.neighbors[i];
                float stepCost = current.distanceTo(neighbor);
                float totalG = current.g + stepCost + neighbor.costMalus;
                if (neighbor.walkedDistance >= maxRange || neighbor.inOpenSet() && totalG >= neighbor.g - 1.0E-6f) continue;
                neighbor.walkedDistance = current.walkedDistance + stepCost;
                neighbor.cameFrom = current;
                neighbor.g = totalG;
                neighbor.h = this.getBestH(neighbor) * 1.5f;
                neighbor.f = neighbor.g + neighbor.h;
                if (neighbor.inOpenSet()) {
                    this.openSet.changeCost(neighbor, neighbor.f);
                    continue;
                }
                this.openSet.insert(neighbor);
            }
        }
        return this.reached.isEmpty() ? this.getClosestUnreachedPath() : this.getBestReachedPath();
    }

    private float getBestH(TravelersNode node) {
        float best = Float.MAX_VALUE;
        for (TravelersTarget t : this.targetList) {
            float dist = node.distanceTo(t);
            t.updateBest(dist, node);
            if (!(dist < best)) continue;
            best = dist;
        }
        return best;
    }

    private TravelersPath getClosestUnreachedPath() {
        TravelersPath best = null;
        int bestCount = Integer.MAX_VALUE;
        double bestDist = Double.MAX_VALUE;
        for (TravelersTarget target : this.targetList) {
            TravelersPath path = this.reconstructPath(target.getBestNode(), target.getTargetPos(), false);
            int count = path.getNodeCount();
            double dist = path.getDistToTarget();
            if (!(dist < bestDist) && (dist != bestDist || count >= bestCount)) continue;
            best = path;
            bestDist = dist;
            bestCount = count;
        }
        return best;
    }

    private TravelersPath getBestReachedPath() {
        TravelersPath best = null;
        int bestCount = Integer.MAX_VALUE;
        for (TravelersTarget target : this.reached) {
            TravelersPath path = this.reconstructPath(target.getBestNode(), target.getTargetPos(), true);
            int count = path.getNodeCount();
            if (count >= bestCount) continue;
            best = path;
            bestCount = count;
        }
        return best;
    }

    private TravelersPath reconstructPath(TravelersNode end, class_2338 target, boolean reachesTarget) {
        ArrayList<TravelersNode> path = new ArrayList<TravelersNode>();
        TravelersNode n = end;
        while (n != null) {
            path.add(n);
            n = n.cameFrom;
        }
        Collections.reverse(path);
        return new TravelersPath(path, target, reachesTarget);
    }
}

