/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_6035;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersGroundNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;

public class TravelersMoveControl
implements class_6035 {
    protected final float MAX_TURN;
    protected final float TURN_SMOOTH_RATE;
    protected final SmartAnimalBase mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected float strafeForwards;
    protected float strafeRight;
    protected Operation operation = Operation.WAIT;

    public TravelersMoveControl(SmartAnimalBase pMob, TravelersAnimal<?> animal) {
        this.mob = pMob;
        this.MAX_TURN = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
        this.TURN_SMOOTH_RATE = (float)animal.getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
    }

    public void setWantedPosition(double pX, double pY, double pZ, double pSpeed) {
        this.wantedX = pX;
        this.wantedY = pY;
        this.wantedZ = pZ;
        this.speedModifier = pSpeed;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void strafe(float pForward, float pStrafe) {
        this.operation = Operation.STRAFE;
        this.strafeForwards = pForward;
        this.strafeRight = pStrafe;
        this.speedModifier = 0.25;
    }

    public void tick() {
        switch (this.operation.ordinal()) {
            case 2: {
                this.handleStrafing();
                break;
            }
            case 1: {
                this.handleMoveTo();
                break;
            }
            case 3: {
                this.handleJumping();
                break;
            }
            default: {
                this.mob.method_5930(0.0f);
            }
        }
    }

    protected void handleStrafing() {
        float dZ;
        float speed = this.mob.method_6029() * (float)this.speedModifier;
        float forward = this.strafeForwards;
        float right = this.strafeRight;
        float norm = class_3532.method_15355((float)(forward * forward + right * right));
        if (norm < 1.0f) {
            norm = 1.0f;
        }
        norm = speed / norm;
        float sin = class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
        float cos = class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180)));
        float dX = (forward *= norm) * cos - (right *= norm) * sin;
        if (!this.isWalkable(dX, dZ = right * cos + forward * sin)) {
            this.adjustStrafing();
        }
        this.mob.method_6125(speed);
        this.mob.method_5930(this.strafeForwards);
        this.mob.method_5938(this.strafeRight);
        this.operation = Operation.WAIT;
    }

    protected void handleMoveTo() {
        double dZ;
        double dY;
        this.operation = Operation.WAIT;
        double dX = this.wantedX - this.mob.method_23317();
        double distanceSquared = dX * dX + (dY = this.wantedY - this.mob.method_23318()) * dY + (dZ = this.wantedZ - this.mob.method_23321()) * dZ;
        if (distanceSquared < 2.500000277905201E-7) {
            this.mob.method_5930(0.0f);
            return;
        }
        float targetAngle = (float)(class_3532.method_15349((double)dZ, (double)dX) * 180.0 / Math.PI) - 90.0f;
        this.mob.method_36456(this.rotlerp(this.mob.method_36454(), targetAngle, this.getTurnSpeed()));
        this.mob.method_6125((float)(this.speedModifier * (double)this.mob.method_6029()));
        if (this.shouldJump(dY, dX, dZ)) {
            this.mob.method_5988().method_20248(this.wantedX, this.wantedY, this.wantedZ);
            this.mob.method_5993().method_6233();
            this.operation = Operation.JUMPING;
        }
    }

    protected void handleJumping() {
        if (this.mob.method_5988().method_38970()) {
            this.mob.method_6125((float)(this.speedModifier * (double)this.mob.method_6029()));
        }
        if (this.mob.method_24828()) {
            this.operation = Operation.WAIT;
        }
    }

    protected boolean shouldJump(double dY, double dX, double dZ) {
        double distanceTo = this.mob.method_5649(this.mob.method_23317() + dX, this.mob.method_23318(), this.mob.method_23321() + dZ);
        if (distanceTo < (double)(this.mob.method_17681() * 1.1f)) {
            boolean collides;
            boolean bl = collides = !this.mob.method_37908().method_52569((class_1297)this.mob, this.mob.method_5829().method_1012(0.0, dY, 0.0));
            if (collides) {
                return false;
            }
            return dY > (double)this.mob.method_49476() && dY <= this.mob.jumpHeight();
        }
        return false;
    }

    protected void adjustStrafing() {
        this.strafeForwards = 0.8f;
        this.strafeRight = 0.2f;
    }

    protected boolean isWalkable(float pRelativeX, float pRelativeZ) {
        class_2338 targetPos;
        TravelersGroundNavigation pathNavigation = (TravelersGroundNavigation)this.mob.getNavigationController();
        TravelersNodeEvaluator nodeEvaluator = pathNavigation.getNodeEvaluator();
        TravelersPathType pathType = nodeEvaluator.getPathType((class_1308)this.mob, targetPos = class_2338.method_49637((double)(this.mob.method_23317() + (double)pRelativeX), (double)this.mob.method_31478(), (double)(this.mob.method_23321() + (double)pRelativeZ)));
        if (pathType != TravelersPathType.WALKABLE) {
            return false;
        }
        class_238 boundingBox = this.mob.method_5829();
        class_238 targetBox = boundingBox.method_996(targetPos);
        if (!this.mob.method_37908().method_8587((class_1297)this.mob, targetBox)) {
            return false;
        }
        return !this.isBlockedByObstacle(targetPos);
    }

    protected boolean isValidPath(class_2338 targetPos) {
        class_2680 blockState = this.mob.method_37908().method_8320(targetPos);
        return !blockState.method_26164(class_3481.field_16584) && !blockState.method_26164(class_3481.field_25147);
    }

    protected boolean isBlockedByObstacle(class_2338 targetPos) {
        class_2680 blockState = this.mob.method_37908().method_8320(targetPos);
        return blockState.method_51367();
    }

    protected float rotlerp(float from, float to, float rate) {
        float delta = class_3532.method_15393((float)(to - from));
        return from + delta * class_3532.method_15363((float)rate, (float)0.0f, (float)1.0f);
    }

    protected float getTurnSpeed() {
        float TURN = this.MAX_TURN;
        float multiplier = this.mob.getTurnMultiplier();
        if (multiplier > 0.0f && multiplier != 1.0f) {
            TURN *= multiplier;
        }
        return TURN;
    }

    protected static enum Operation {
        WAIT,
        MOVE_TO,
        STRAFE,
        JUMPING;

    }
}

