/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.node.TravelersSwimNodeEvaluator;

public class TravelersAquaticNavigation
extends TravelersPathNavigation {
    private final boolean allowBreaching;
    private final SmartAnimalBase base;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public TravelersAquaticNavigation(SmartAnimalBase mob, class_1937 level, boolean allowBreaching) {
        super(mob, level);
        this.base = mob;
        this.allowBreaching = allowBreaching;
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        class_243 temptPos = this.getTempMobPos();
        if (this.shouldTargetNextNodeInDirection(this.path, this.base, temptPos)) {
            this.path.advance();
        }
        this.doStuckDetection(temptPos);
        if (this.isStuck()) {
            this.recomputePath();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex > 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 50) {
                    this.recomputePath();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    public boolean shouldTargetNextNodeInDirection(TravelersPath path, SmartAnimalBase mob, class_243 vec) {
        if (path == null) {
            return false;
        }
        int nextNodeIndex = path.getNextNodeIndex();
        if (nextNodeIndex >= path.getNodeCount()) {
            return false;
        }
        class_243 nodeCenter = class_243.method_24953((class_2382)path.getNodePos(nextNodeIndex));
        class_243 pos = mob.method_19538();
        return nodeCenter.method_55230(pos, Math.max(0.75, (double)(mob.method_17681() / 2.0f)), (double)Math.max(0.75f, mob.method_17682()));
    }

    @Override
    protected boolean canUpdatePath() {
        return this.allowBreaching || this.mob.method_52535();
    }

    @Override
    protected double getGroundY(class_243 vec) {
        return vec.field_1351;
    }

    @Override
    protected class_243 getTempMobPos() {
        return new class_243(this.mob.method_23317(), this.mob.method_23323(0.5), this.mob.method_23321());
    }

    @Override
    protected boolean canMoveDirectly(@NotNull class_243 posVec31, @NotNull class_243 posVec32) {
        return TravelersAquaticNavigation.isClearForMovementBetween((class_1308)this.mob, posVec31, posVec32, false);
    }

    @Override
    public boolean isStableDestination(class_2338 pos) {
        return !this.level.method_8320(pos).method_26216((class_1922)this.level, pos);
    }

    @Override
    public void setCanFloat(boolean canSwim) {
    }

    @Override
    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        return new TravelersPathFinder(this.nodeEvaluator);
    }
}

