/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersDebug;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.packet.obj.TravelersPathFindingDebug;
import travelers.util.helper.TravelersPacketDistributor;

public abstract class TravelersPathNavigation {
    protected final SmartAnimalBase mob;
    protected final class_1937 level;
    private final TravelersPathFinder pathFinder;
    @Nullable
    protected TravelersPath path;
    protected boolean isLookingForPath;
    protected double speedModifier;
    protected int tick;
    protected int lastStuckCheck;
    protected class_243 lastStuckCheckPos = class_243.field_1353;
    protected class_2382 timeoutCachedNode = class_2382.field_11176;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 1.0f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected TravelersNodeEvaluator nodeEvaluator;
    @Nullable
    private class_2338 targetPos;
    private int reachRange;
    private float maxVisitedNodesMultiplier = 1.0f;
    private boolean isStuck;

    public TravelersPathNavigation(SmartAnimalBase mob, class_1937 level) {
        this.mob = mob;
        this.level = level;
        this.pathFinder = this.createPathFinder();
    }

    protected static boolean isClearForMovementBetween(class_1308 mob, class_243 pos1, class_243 pos2, boolean allowSwimming) {
        class_243 vec3 = new class_243(pos2.field_1352, pos2.field_1351 + (double)mob.method_17682() * 0.5, pos2.field_1350);
        return mob.method_37908().method_17742(new class_3959(pos1, vec3, class_3959.class_3960.field_17558, allowSwimming ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)mob)).method_17783() == class_239.class_240.field_1333;
    }

    @Nullable
    public class_2338 getTargetPos() {
        return this.targetPos;
    }

    protected abstract TravelersPathFinder createPathFinder();

    public void recomputePath() {
        this.recomputePath(false);
    }

    public void recomputePath(boolean force) {
        if (this.level.method_8510() - this.timeLastRecompute > 20L || force) {
            if (this.targetPos != null) {
                this.createPath(this.targetPos, this.reachRange).thenAccept(travelersPath -> this.moveTo((TravelersPath)travelersPath, 1.0));
                this.timeLastRecompute = this.level.method_8510();
                this.hasDelayedRecomputation = false;
            } else if (this.getPath() != null && this.path.getTarget() != null) {
                class_2338 target = this.path.getTarget();
                CompletableFuture<TravelersPath> newPath = this.createPath(target, this.reachRange);
                if (newPath != null) {
                    newPath.thenAccept(travelersPath -> this.moveTo((TravelersPath)travelersPath, 1.0));
                }
                this.timeLastRecompute = this.level.method_8510();
                this.hasDelayedRecomputation = false;
            }
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(double x, double y, double z, int accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)class_2338.method_49637((double)x, (double)y, (double)z)), 8, false, accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Stream<class_2338> targets, int accuracy) {
        return this.createPath(targets.collect(Collectors.toSet()), 8, false, accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Set<class_2338> positions, int distance) {
        return this.createPath(positions, 8, false, distance);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(class_2338 pos, int accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)pos), 8, false, accuracy);
    }

    public TravelersPath createPathSynced(class_2338 pos, int accuracy) {
        return this.createPathSynced((Set<class_2338>)ImmutableSet.of((Object)pos), 8, true, accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(class_2338 pos, int regionOffset, int accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)pos), 8, false, regionOffset);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(class_1297 entity, int accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)entity.method_24515()), 16, true, accuracy);
    }

    protected TravelersPath createPathSynced(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy) {
        if (!targets.isEmpty() && !(this.mob.method_23318() < (double)this.level.method_31607()) && this.canUpdatePath()) {
            this.level.method_16107().method_15396("pathfind");
            float followRange = 64.0f;
            class_2338 blockpos = offsetUpward ? this.mob.method_24515().method_10084() : this.mob.method_24515();
            int i = (int)(followRange + (float)regionOffset);
            class_1950 pathRegion = new class_1950(this.level, blockpos.method_10069(-i, -i, -i), blockpos.method_10069(i, i, i));
            this.isLookingForPath = true;
            TravelersPath futurePath = this.pathFinder.findPath(pathRegion, this.mob, targets, followRange, accuracy, this.maxVisitedNodesMultiplier);
            this.level.method_16107().method_15407();
            return futurePath;
        }
        return null;
    }

    @Nullable
    protected CompletableFuture<TravelersPath> createPath(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy) {
        if (this.isLookingForPath) {
            return null;
        }
        if (!targets.isEmpty() && !(this.mob.method_23318() < (double)this.level.method_31607()) && this.canUpdatePath()) {
            this.level.method_16107().method_15396("pathfind");
            float followRange = 64.0f;
            class_2338 blockpos = offsetUpward ? this.mob.method_24515().method_10084() : this.mob.method_24515();
            int i = (int)(followRange + (float)regionOffset);
            class_1950 pathRegion = new class_1950(this.level, blockpos.method_10069(-i, -i, -i), blockpos.method_10069(i, i, i));
            this.isLookingForPath = true;
            CompletableFuture<TravelersPath> futurePath = this.pathFinder.findPathAsync(pathRegion, this.mob, targets, followRange, accuracy, this.maxVisitedNodesMultiplier);
            this.level.method_16107().method_15407();
            futurePath.thenAccept(path -> {
                if (this.isLookingForPath) {
                    this.isLookingForPath = false;
                }
            });
            return futurePath;
        }
        return null;
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z, double speed) {
        CompletableFuture<TravelersPath> path = this.createPath(x, y, z, 1);
        if (path != null) {
            path.thenAccept(jsPath -> this.moveTo((TravelersPath)jsPath, speed));
        }
        return path;
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z, int accuracy, double speed) {
        CompletableFuture<TravelersPath> path = this.createPath(x, y, z, accuracy);
        if (path != null) {
            path.thenAccept(jsPath -> this.moveTo((TravelersPath)jsPath, speed));
        }
        return path;
    }

    public CompletableFuture<TravelersPath> moveTo(class_1297 entity, double speed) {
        CompletableFuture<TravelersPath> path = this.createPath(entity, 1);
        if (path != null) {
            path.thenAccept(jsPath -> this.moveTo((TravelersPath)jsPath, speed));
        }
        return path;
    }

    public void moveTo(@Nullable TravelersPath pathentity, double speed) {
        if (pathentity == null) {
            this.path = null;
        } else {
            if (!pathentity.sameAs(this.path)) {
                this.path = pathentity;
            }
            if (!this.isDone()) {
                this.trimPath();
                if (this.path.getNodeCount() > 0) {
                    this.speedModifier = speed;
                    class_243 vec3 = this.getTempMobPos();
                    this.lastStuckCheck = this.tick;
                    this.lastStuckCheckPos = vec3;
                }
            }
        }
    }

    protected void trimPath() {
        if (this.path != null) {
            for (int i = 0; i < this.path.getNodeCount(); ++i) {
                TravelersNode node = this.path.getNode(i);
                TravelersNode node1 = i + 1 < this.path.getNodeCount() ? this.path.getNode(i + 1) : null;
                class_2680 blockstate = this.level.method_8320(new class_2338(node.x, node.y, node.z));
                if (!blockstate.method_26164(class_3481.field_26985)) continue;
                this.path.replaceNode(i, node.cloneAndMove(node.x, node.y + 1, node.z));
                if (node1 == null || node.y < node1.y) continue;
                this.path.replaceNode(i + 1, node.cloneAndMove(node1.x, node.y + 1, node1.z));
            }
        }
    }

    @Nullable
    public TravelersPath getPath() {
        return this.path;
    }

    public void tick() {
        ++this.tick;
        if (this.isLookingForPath) {
            return;
        }
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone()) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                class_243 vec3 = this.getTempMobPos();
                class_243 vec31 = this.path.getNextEntityPos((class_1297)this.mob);
                if (vec31.method_1025(vec3) <= (double)this.maxDistanceToWaypoint) {
                    this.path.advance();
                }
            }
            this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
            if (!this.isDone() && this.path != null) {
                class_243 vec32 = this.path.getNextEntityPos((class_1297)this.mob);
                this.mob.getMoveController().setWantedPosition(vec32.field_1352, this.getGroundY(vec32), vec32.field_1350, this.speedModifier);
            }
        }
    }

    void sendPathFinding(class_1937 level, SmartAnimalBase mob, TravelersPath path, float maxDistanceToWaypoint) {
        if (TravelersMain.isDebugging()) {
            if (path == null || level.field_9236) {
                return;
            }
            if (TravelersDebug.ENABLED_DEBUGS.contains(mob.getAnimal().getAnimalAttributes().getModId().toLowerCase(Locale.ROOT))) {
                TravelersPacketDistributor.sendToPlayersTrackingEntity(mob, new TravelersPathFindingDebug(mob.method_5628(), path, maxDistanceToWaypoint));
            }
        }
    }

    protected double getGroundY(class_243 vec) {
        class_2338 blockpos = class_2338.method_49638((class_2374)vec);
        return this.level.method_8320(blockpos.method_10074()).method_26215() ? vec.field_1351 : TravelersWalkNodeEvaluator.getFloorLevel((class_1922)this.level, blockpos);
    }

    protected void followThePath() {
        throw new UnsupportedOperationException("This method requires an override");
    }

    protected void doStuckDetection(class_243 positionVec3) {
        if (this.tick - this.lastStuckCheck > 100) {
            float f = this.mob.method_6029() >= 1.0f ? this.mob.method_6029() : this.mob.method_6029() * this.mob.method_6029();
            float f1 = f * 100.0f * 0.25f;
            this.isStuck = positionVec3.method_1025(this.lastStuckCheckPos) < (double)(f1 * f1);
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = positionVec3;
        }
        if (this.path != null && !this.path.isDone()) {
            class_2338 vec3i = this.path.getNextNodePos();
            long i = this.level.method_8510();
            if (vec3i.equals((Object)this.timeoutCachedNode)) {
                this.timeoutTimer += i - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = vec3i;
                double d0 = positionVec3.method_1022(class_243.method_24955((class_2382)this.timeoutCachedNode));
                double d = this.timeoutLimit = this.mob.method_6029() > 0.0f ? d0 / (double)this.mob.method_6029() * 20.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutPath();
            }
            this.lastTimeoutCheck = i;
        }
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = class_2382.field_11176;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return (this.path == null || this.path.isDone()) && !this.isLookingForPath;
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public void stop() {
        this.nodeEvaluator.done();
        this.path = null;
        this.isLookingForPath = false;
    }

    protected abstract class_243 getTempMobPos();

    protected abstract boolean canUpdatePath();

    protected boolean canMoveDirectly(class_243 posVec31, class_243 posVec32) {
        return false;
    }

    public boolean canCutCorner(TravelersPathType pathType) {
        return pathType != TravelersPathType.DANGER_FIRE && pathType != TravelersPathType.DANGER_OTHER && pathType != TravelersPathType.WALKABLE_DOOR;
    }

    public boolean isStableDestination(class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        return this.level.method_8320(blockpos).method_26216((class_1922)this.level, blockpos);
    }

    public TravelersNodeEvaluator getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public void setCanFloat(boolean canSwim) {
        this.nodeEvaluator.setCanFloat(canSwim);
    }

    public boolean canFloat() {
        return this.nodeEvaluator.isCanFloat();
    }

    public boolean shouldRecomputePath(class_2338 pos) {
        if (this.hasDelayedRecomputation) {
            return false;
        }
        if (this.path != null && !this.path.isDone() && this.path.getNodeCount() > 0) {
            class_238 blockBox = new class_238(pos);
            for (int i = this.path.getNextNodeIndex(); i < this.path.getNodeCount(); ++i) {
                class_238 movedBox;
                TravelersNode node = this.path.getNode(i);
                if (node == null || !(movedBox = this.mob.method_5829().method_989((double)(node.x - class_3532.method_15357((double)this.mob.method_23317())), (double)(node.y - class_3532.method_15357((double)this.mob.method_23318())), (double)(node.z - class_3532.method_15357((double)this.mob.method_23321())))).method_994(blockBox)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isStuck() {
        return this.isStuck;
    }

    public boolean isLookingForPath() {
        return this.isLookingForPath;
    }

    public void setLookingForPath(boolean isLookingForPath) {
        this.isLookingForPath = isLookingForPath;
    }

    public void setSpeedModifier(double speedModifier) {
        this.speedModifier = speedModifier;
    }

    public void setMaxVisitedNodesMultiplier(float maxVisitedNodesMultiplier) {
        this.maxVisitedNodesMultiplier = maxVisitedNodesMultiplier;
    }
}

