/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersAmphibiousNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private final boolean prefersShallowSwimming;
    private float oldWalkableCost;
    private float oldWaterBorderCost;

    public TravelersAmphibiousNodeEvaluator(boolean prefersShallowSwimming) {
        this.prefersShallowSwimming = prefersShallowSwimming;
    }

    @Override
    public void prepare(class_1950 level, SmartAnimalBase mob) {
        super.prepare(level, mob);
        mob.setPathfindingMalus(TravelersPathType.WATER, 0.0f);
        this.oldWalkableCost = mob.getPathfindingMalus(TravelersPathType.WALKABLE);
        mob.setPathfindingMalus(TravelersPathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = mob.getPathfindingMalus(TravelersPathType.WATER_BORDER);
        mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, 4.0f);
    }

    @Override
    public void done() {
        if (this.mob == null) {
            return;
        }
        this.mob.setPathfindingMalus(TravelersPathType.WALKABLE, this.oldWalkableCost);
        this.mob.setPathfindingMalus(TravelersPathType.WATER_BORDER, this.oldWaterBorderCost);
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        return !this.mob.method_5799() ? super.getStart() : this.getStartNode(new class_2338(class_3532.method_15357((double)this.mob.method_5829().field_1323), class_3532.method_15357((double)(this.mob.method_5829().field_1322 + 0.5)), class_3532.method_15357((double)this.mob.method_5829().field_1321)));
    }

    @Override
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y + 0.5, z);
    }

    @Override
    public int getNeighbors(TravelersNode[] outputArray, TravelersNode p_node) {
        int i = super.getNeighbors(outputArray, p_node);
        TravelersPathType pathtype = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType pathtype1 = this.getPathType(p_node.x, p_node.y, p_node.z);
        int j = this.mob.getPathfindingMalus(pathtype) >= 0.0f && pathtype1 != TravelersPathType.STICKY_HONEY ? class_3532.method_15375((float)Math.max(1.0f, this.mob.method_49476())) : 0;
        double d0 = this.getFloorLevel(new class_2338(p_node.x, p_node.y, p_node.z));
        TravelersNode node = this.findAcceptedNode(p_node, p_node.x, p_node.y + 1, p_node.z, Math.max(0, j - 1), d0, class_2350.field_11036, pathtype1);
        TravelersNode node1 = this.findAcceptedNode(p_node, p_node.x, p_node.y - 1, p_node.z, j, d0, class_2350.field_11033, pathtype1);
        if (this.isVerticalNeighborValid(node, p_node)) {
            outputArray[i++] = node;
        }
        if (this.isVerticalNeighborValid(node1, p_node) && pathtype1 != TravelersPathType.TRAPDOOR) {
            outputArray[i++] = node1;
        }
        for (int k = 0; k < i; ++k) {
            TravelersNode node2 = outputArray[k];
            if (node2.type != TravelersPathType.WATER || !this.prefersShallowSwimming || node2.y >= this.mob.method_37908().method_8615() - 10) continue;
            node2.costMalus += 1.0f;
        }
        return i;
    }

    private boolean isVerticalNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return this.isNeighborValid(neighbor, node) && neighbor.type == TravelersPathType.WATER;
    }

    @Override
    protected boolean isAmphibious() {
        return this.isCanFloat();
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        TravelersPathType pathtype = context.getPathTypeFromState(x, y, z);
        if (pathtype == TravelersPathType.WATER) {
            class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
            for (class_2350 direction : class_2350.values()) {
                blockpos$mutableblockpos.method_10103(x, y, z).method_10098(direction);
                TravelersPathType pathtype1 = context.getPathTypeFromState(blockpos$mutableblockpos.method_10263(), blockpos$mutableblockpos.method_10264(), blockpos$mutableblockpos.method_10260());
                if (pathtype1 != TravelersPathType.BLOCKED) continue;
                return TravelersPathType.WATER_BORDER;
            }
            return TravelersPathType.WATER;
        }
        return super.getPathType(context, x, y, z);
    }
}

