/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersFlyNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypeByPosCache = new Long2ObjectOpenHashMap();

    @Override
    public void prepare(class_1950 level, SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.pathTypeByPosCache.clear();
        mob.method_51504();
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.method_51503();
        }
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    public TravelersNode getStart() {
        class_2338 blockpos1;
        int i;
        if (this.isCanFloat() && this.mob.method_5799()) {
            i = this.mob.method_31478();
            class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339(this.mob.method_23317(), (double)i, this.mob.method_23321());
            class_2680 blockstate = this.context.getBlockState((class_2338)blockpos$mutableblockpos);
            while (blockstate.method_27852(class_2246.field_10382)) {
                blockpos$mutableblockpos.method_10102(this.mob.method_23317(), (double)(++i), this.mob.method_23321());
                blockstate = this.context.getBlockState((class_2338)blockpos$mutableblockpos);
            }
        } else {
            i = class_3532.method_15357((double)(this.mob.method_23318() + 0.5));
        }
        if (!this.canStartAt(blockpos1 = class_2338.method_49637((double)this.mob.method_23317(), (double)i, (double)this.mob.method_23321()))) {
            for (class_2338 blockpos : this.iteratePathfindingStartNodeCandidatePositions((class_1308)this.mob)) {
                if (!this.canStartAt(blockpos)) continue;
                return super.getStartNode(blockpos);
            }
        }
        return super.getStartNode(blockpos1);
    }

    @Override
    protected TravelersPathType getPathType(int x, int y, int z) {
        return (TravelersPathType)((Object)this.pathTypeByPosCache.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), p_330153_ -> this.getPathTypeOfMob(this.context, x, y, z, this.mob)));
    }

    @Override
    protected boolean canStartAt(class_2338 pos) {
        TravelersPathType pathtype = this.getPathType(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return this.mob.getPathfindingMalus(pathtype) >= 0.0f;
    }

    @Override
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode[] outputArray, TravelersNode p_node) {
        TravelersNode westSouth;
        TravelersNode eastSouth;
        TravelersNode westNorth;
        TravelersNode eastNorth;
        TravelersNode southDown;
        TravelersNode eastDown;
        TravelersNode westDown;
        TravelersNode northDown;
        TravelersNode southUp;
        TravelersNode eastUp;
        TravelersNode westUp;
        int i = 0;
        TravelersNode north = this.findAcceptedNode(p_node.x, p_node.y, p_node.z + 1);
        TravelersNode west = this.findAcceptedNode(p_node.x - 1, p_node.y, p_node.z);
        TravelersNode east = this.findAcceptedNode(p_node.x + 1, p_node.y, p_node.z);
        TravelersNode south = this.findAcceptedNode(p_node.x, p_node.y, p_node.z - 1);
        TravelersNode up = this.findAcceptedNode(p_node.x, p_node.y + 1, p_node.z);
        TravelersNode down = this.findAcceptedNode(p_node.x, p_node.y - 1, p_node.z);
        if (this.isOpen(north)) {
            outputArray[i++] = north;
        }
        if (this.isOpen(west)) {
            outputArray[i++] = west;
        }
        if (this.isOpen(east)) {
            outputArray[i++] = east;
        }
        if (this.isOpen(south)) {
            outputArray[i++] = south;
        }
        if (this.isOpen(up)) {
            outputArray[i++] = up;
        }
        if (this.isOpen(down)) {
            outputArray[i++] = down;
        }
        BiPredicate<TravelersNode, TravelersNode> orthogonalsOpen = (a, b) -> this.isOpen((TravelersNode)a) && this.isOpen((TravelersNode)b);
        TravelersNode northUp = this.findAcceptedNode(p_node.x, p_node.y + 1, p_node.z + 1);
        if (this.isOpen(northUp) && orthogonalsOpen.test(north, up) && this.canReach(p_node, northUp)) {
            outputArray[i++] = northUp;
        }
        if (this.isOpen(westUp = this.findAcceptedNode(p_node.x - 1, p_node.y + 1, p_node.z)) && orthogonalsOpen.test(west, up) && this.canReach(p_node, westUp)) {
            outputArray[i++] = westUp;
        }
        if (this.isOpen(eastUp = this.findAcceptedNode(p_node.x + 1, p_node.y + 1, p_node.z)) && orthogonalsOpen.test(east, up) && this.canReach(p_node, eastUp)) {
            outputArray[i++] = eastUp;
        }
        if (this.isOpen(southUp = this.findAcceptedNode(p_node.x, p_node.y + 1, p_node.z - 1)) && orthogonalsOpen.test(south, up) && this.canReach(p_node, southUp)) {
            outputArray[i++] = southUp;
        }
        if (this.isOpen(northDown = this.findAcceptedNode(p_node.x, p_node.y - 1, p_node.z + 1)) && orthogonalsOpen.test(north, down) && this.canReach(p_node, northDown)) {
            outputArray[i++] = northDown;
        }
        if (this.isOpen(westDown = this.findAcceptedNode(p_node.x - 1, p_node.y - 1, p_node.z)) && orthogonalsOpen.test(west, down) && this.canReach(p_node, westDown)) {
            outputArray[i++] = westDown;
        }
        if (this.isOpen(eastDown = this.findAcceptedNode(p_node.x + 1, p_node.y - 1, p_node.z)) && orthogonalsOpen.test(east, down) && this.canReach(p_node, eastDown)) {
            outputArray[i++] = eastDown;
        }
        if (this.isOpen(southDown = this.findAcceptedNode(p_node.x, p_node.y - 1, p_node.z - 1)) && orthogonalsOpen.test(south, down) && this.canReach(p_node, southDown)) {
            outputArray[i++] = southDown;
        }
        if (this.isOpen(eastNorth = this.findAcceptedNode(p_node.x + 1, p_node.y, p_node.z + 1)) && orthogonalsOpen.test(east, north) && this.canReach(p_node, eastNorth)) {
            outputArray[i++] = eastNorth;
        }
        if (this.isOpen(westNorth = this.findAcceptedNode(p_node.x - 1, p_node.y, p_node.z + 1)) && orthogonalsOpen.test(west, north) && this.canReach(p_node, westNorth)) {
            outputArray[i++] = westNorth;
        }
        if (this.isOpen(eastSouth = this.findAcceptedNode(p_node.x + 1, p_node.y, p_node.z - 1)) && orthogonalsOpen.test(east, south) && this.canReach(p_node, eastSouth)) {
            outputArray[i++] = eastSouth;
        }
        if (this.isOpen(westSouth = this.findAcceptedNode(p_node.x - 1, p_node.y, p_node.z - 1)) && orthogonalsOpen.test(west, south) && this.canReach(p_node, westSouth)) {
            outputArray[i++] = westSouth;
        }
        return i;
    }

    private boolean canReach(TravelersNode fromNode, TravelersNode toNode) {
        class_243 from = new class_243((double)fromNode.x + 0.5, (double)fromNode.y + 0.5, (double)fromNode.z + 0.5);
        class_243 to = new class_243((double)toNode.x + 0.5, (double)toNode.y + 0.5, (double)toNode.z + 0.5);
        return this.raycastClear(from, to);
    }

    private boolean raycastClear(class_243 from, class_243 to) {
        class_3959 context = new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mob);
        class_3965 result = this.context.level().method_17742(context);
        return result.method_17783() == class_239.class_240.field_1333;
    }

    private boolean hasMalus(@Nullable TravelersNode node) {
        return node != null && node.costMalus >= 0.0f;
    }

    private boolean isOpen(@Nullable TravelersNode node) {
        return node != null && !node.closed;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(int x, int y, int z) {
        TravelersNode node = null;
        TravelersPathType pathtype = this.getPathType(x, y, z);
        float f = this.mob.getPathfindingMalus(pathtype);
        if (f >= 0.0f) {
            node = this.getNode(x, y, z);
            node.type = pathtype;
            node.costMalus = Math.max(node.costMalus, f);
            if (pathtype == TravelersPathType.WALKABLE) {
                node.costMalus += 1.0f;
            }
        }
        if (node != null && !this.isSpaceValidForStanding(node.x, node.y, node.z)) {
            return null;
        }
        return node;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        TravelersPathType pathtype = context.getPathTypeFromState(x, y, z);
        if (pathtype == TravelersPathType.OPEN && y >= context.level().method_31607() + 1) {
            class_2338 blockpos = new class_2338(x, y - 1, z);
            TravelersPathType pathtype1 = context.getPathTypeFromState(blockpos.method_10263(), blockpos.method_10264(), blockpos.method_10260());
            if (pathtype1 == TravelersPathType.DAMAGE_FIRE || pathtype1 == TravelersPathType.LAVA) {
                pathtype = TravelersPathType.DAMAGE_FIRE;
            } else if (pathtype1 == TravelersPathType.DAMAGE_OTHER) {
                pathtype = TravelersPathType.DAMAGE_OTHER;
            } else if (pathtype1 == TravelersPathType.COCOA) {
                pathtype = TravelersPathType.COCOA;
            } else if (pathtype1 == TravelersPathType.FENCE) {
                if (!blockpos.equals((Object)context.mobPosition())) {
                    pathtype = TravelersPathType.FENCE;
                }
            } else {
                TravelersPathType travelersPathType = pathtype = pathtype1 != TravelersPathType.WALKABLE && pathtype1 != TravelersPathType.OPEN && pathtype1 != TravelersPathType.WATER ? TravelersPathType.WALKABLE : TravelersPathType.OPEN;
            }
        }
        if (pathtype == TravelersPathType.WALKABLE || pathtype == TravelersPathType.OPEN) {
            pathtype = TravelersFlyNodeEvaluator.checkNeighbourBlocks(context, x, y, z, pathtype);
        }
        return pathtype;
    }

    private Iterable<class_2338> iteratePathfindingStartNodeCandidatePositions(class_1308 mob) {
        boolean flag;
        class_238 aabb = mob.method_5829();
        boolean bl = flag = aabb.method_995() < 1.0;
        if (!flag) {
            return List.of(class_2338.method_49637((double)aabb.field_1323, (double)mob.method_31478(), (double)aabb.field_1321), class_2338.method_49637((double)aabb.field_1323, (double)mob.method_31478(), (double)aabb.field_1324), class_2338.method_49637((double)aabb.field_1320, (double)mob.method_31478(), (double)aabb.field_1321), class_2338.method_49637((double)aabb.field_1320, (double)mob.method_31478(), (double)aabb.field_1324));
        }
        double d0 = Math.max(0.0, (double)1.1f - aabb.method_17941());
        double d1 = Math.max(0.0, (double)1.1f - aabb.method_17939());
        double d2 = Math.max(0.0, (double)1.1f - aabb.method_17940());
        class_238 aabb1 = aabb.method_1009(d1, d2, d0);
        return class_2338.method_27156((class_5819)mob.method_59922(), (int)10, (int)class_3532.method_15357((double)aabb1.field_1323), (int)class_3532.method_15357((double)aabb1.field_1322), (int)class_3532.method_15357((double)aabb1.field_1321), (int)class_3532.method_15357((double)aabb1.field_1320), (int)class_3532.method_15357((double)aabb1.field_1325), (int)class_3532.method_15357((double)aabb1.field_1324));
    }
}

