/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1944;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersWalkNodeEvaluator
extends TravelersNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final TravelersNode[] reusableNeighbors = new TravelersNode[class_2350.class_2353.field_11062.method_57092()];
    private boolean canCrawl = false;
    private boolean triesToAvoidLight = false;

    private static boolean doesBlockHavePartialCollision(TravelersPathType pathType) {
        return pathType == TravelersPathType.FENCE || pathType == TravelersPathType.DOOR_WOOD_CLOSED || pathType == TravelersPathType.DOOR_IRON_CLOSED;
    }

    public static double getFloorLevel(class_1922 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_265 voxelshape = level.method_8320(blockpos).method_26220(level, blockpos);
        return (double)blockpos.method_10264() + (voxelshape.method_1110() ? 0.0 : voxelshape.method_1105(class_2350.class_2351.field_11052));
    }

    public static TravelersPathType getPathTypeStatic(SmartAnimalBase base, class_2338 pos) {
        return TravelersWalkNodeEvaluator.getPathTypeStatic(new TravelersPathfindingContext((class_1941)base.method_37908(), (class_1308)base), pos.method_25503());
    }

    public static TravelersPathType getPathTypeStatic(TravelersPathfindingContext context, class_2338.class_2339 pos) {
        int k;
        int j;
        int i = pos.method_10263();
        TravelersPathType pathtype = context.getPathTypeFromState(i, j = pos.method_10264(), k = pos.method_10260());
        if (pathtype == TravelersPathType.OPEN && j >= context.level().method_31607() + 1) {
            return switch (context.getPathTypeFromState(i, j - 1, k)) {
                case TravelersPathType.OPEN, TravelersPathType.WATER, TravelersPathType.WALKABLE, TravelersPathType.LIGHT -> TravelersPathType.OPEN;
                case TravelersPathType.LAVA -> TravelersPathType.LAVA;
                case TravelersPathType.DAMAGE_FIRE -> TravelersPathType.DAMAGE_FIRE;
                case TravelersPathType.DAMAGE_OTHER -> TravelersPathType.DAMAGE_OTHER;
                case TravelersPathType.STICKY_HONEY -> TravelersPathType.STICKY_HONEY;
                case TravelersPathType.POWDER_SNOW -> TravelersPathType.DANGER_POWDER_SNOW;
                case TravelersPathType.DAMAGE_CAUTIOUS -> TravelersPathType.DAMAGE_CAUTIOUS;
                case TravelersPathType.TRAPDOOR -> TravelersPathType.DANGER_TRAPDOOR;
                default -> TravelersWalkNodeEvaluator.checkNeighbourBlocks(context, i, j, k, TravelersPathType.WALKABLE);
            };
        }
        return pathtype;
    }

    public static TravelersPathType checkNeighbourBlocks(TravelersPathfindingContext context, int x, int y, int z, TravelersPathType pathType) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    TravelersPathType pathtype = context.getPathTypeFromState(x + i, y + j, z + k);
                    if (pathtype == TravelersPathType.DAMAGE_OTHER) {
                        return TravelersPathType.DANGER_OTHER;
                    }
                    if (pathtype == TravelersPathType.DAMAGE_FIRE || pathtype == TravelersPathType.LAVA) {
                        return TravelersPathType.DANGER_FIRE;
                    }
                    if (pathtype == TravelersPathType.WATER) {
                        return TravelersPathType.WATER_BORDER;
                    }
                    if (pathtype != TravelersPathType.DAMAGE_CAUTIOUS) continue;
                    return TravelersPathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pathType;
    }

    @Override
    public void markDirty(class_2338 pos) {
        this.pathTypesByPosCacheByMob.remove(pos.method_10063());
    }

    @Override
    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.triesToAvoidLight = mob.avoidsLight();
        mob.method_51504();
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.method_51503();
        }
        this.pathTypesByPosCacheByMob.clear();
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        int i;
        block9: {
            class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
            i = this.mob.method_31478();
            class_2680 blockstate = this.context.getBlockState((class_2338)blockpos$mutableblockpos.method_10102(this.mob.method_23317(), (double)i, this.mob.method_23321()));
            if (!this.mob.method_26319(blockstate.method_26227())) {
                if (this.mob.method_24828()) {
                    i = class_3532.method_15357((double)this.mob.method_23318());
                } else {
                    if (this.isCanFloat() && this.mob.method_5799()) {
                        while (true) {
                            if (!blockstate.method_27852(class_2246.field_10382) && blockstate.method_26227() != class_3612.field_15910.method_15729(false)) {
                                --i;
                                break block9;
                            }
                            blockstate = this.context.getBlockState((class_2338)blockpos$mutableblockpos.method_10102(this.mob.method_23317(), (double)(++i), this.mob.method_23321()));
                        }
                    }
                    blockpos$mutableblockpos.method_10102(this.mob.method_23317(), this.mob.method_23318() + 1.0, this.mob.method_23321());
                    while (blockpos$mutableblockpos.method_10264() > this.context.level().method_31607()) {
                        i = blockpos$mutableblockpos.method_10264();
                        blockpos$mutableblockpos.method_33098(blockpos$mutableblockpos.method_10264() - 1);
                        class_2680 blockstate1 = this.context.getBlockState((class_2338)blockpos$mutableblockpos);
                        if (blockstate1.method_26215() || blockstate1.method_26171(class_10.field_50)) continue;
                        break;
                    }
                }
            } else {
                while (this.mob.method_26319(blockstate.method_26227())) {
                    blockstate = this.context.getBlockState((class_2338)blockpos$mutableblockpos.method_10102(this.mob.method_23317(), (double)(++i), this.mob.method_23321()));
                }
                --i;
            }
        }
        class_238 aabb = this.mob.method_5829();
        double centerX = (aabb.field_1323 + aabb.field_1320) / 2.0;
        double centerZ = (aabb.field_1321 + aabb.field_1324) / 2.0;
        class_2338 centerPos = class_2338.method_49637((double)centerX, (double)i, (double)centerZ);
        double floor = this.getFloorLevel(centerPos);
        return this.getStartNode((class_2338)centerPos.method_25503().method_33098((int)floor));
    }

    protected TravelersNode getStartNode(class_2338 pos) {
        TravelersNode node = this.getNode(pos);
        node.type = this.getPathType(node.x, node.y, node.z);
        node.costMalus = this.mob.getPathfindingMalus(node.type);
        return node;
    }

    protected boolean canStartAt(class_2338 pos) {
        TravelersPathType pathtype = this.getPathType(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return pathtype != TravelersPathType.OPEN && this.mob.getPathfindingMalus(pathtype) >= 0.0f;
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        int i = 0;
        int j = 0;
        TravelersPathType pathtype = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType pathtype1 = this.getPathType(p_node.x, p_node.y, p_node.z);
        if (this.mob.getPathfindingMalus(pathtype) >= 0.0f && pathtype1 != TravelersPathType.STICKY_HONEY) {
            j = class_3532.method_15375((float)Math.max(1.0f, this.mob.method_49476() + 0.1f));
        }
        double d0 = this.getFloorLevel(new class_2338(p_node.x, p_node.y, p_node.z));
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            TravelersNode node;
            this.reusableNeighbors[direction.method_10161()] = node = this.findAcceptedNode(p_node, p_node.x + direction.method_10148(), p_node.y, p_node.z + direction.method_10165(), j, d0, direction, pathtype1);
            if (!this.isNeighborValid(node, p_node)) continue;
            outputArray[i++] = node;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && !neighbor.closed && (neighbor.costMalus >= 0.0f || node.costMalus < 0.0f);
    }

    protected boolean isDiagonalValid(TravelersNode root, @Nullable TravelersNode xNode, @Nullable TravelersNode zNode) {
        if (zNode == null || xNode == null || zNode.y > root.y || xNode.y > root.y) {
            return false;
        }
        if ((float)Math.abs(zNode.y - root.y) > this.mob.method_49476() || (float)Math.abs(xNode.y - root.y) > this.mob.method_49476()) {
            return false;
        }
        if (xNode.type != TravelersPathType.WALKABLE_DOOR && zNode.type != TravelersPathType.WALKABLE_DOOR) {
            if (zNode.y >= root.y && !(zNode.costMalus >= 0.0f) || xNode.y >= root.y && !(xNode.costMalus >= 0.0f)) {
                return false;
            }
            return !this.cantMoveBetween(root, xNode) && !this.cantMoveBetween(root, zNode);
        }
        return false;
    }

    private boolean cantMoveBetween(TravelersNode from, TravelersNode to) {
        int steps = Math.max(Math.abs(to.x - from.x), Math.max(Math.abs(to.y - from.y), Math.abs(to.z - from.z)));
        if (steps == 0) {
            return false;
        }
        float dx = (float)(to.x - from.x) / (float)steps;
        float dy = (float)(to.y - from.y) / (float)steps;
        float dz = (float)(to.z - from.z) / (float)steps;
        for (int i = 1; i <= steps; ++i) {
            int checkZ;
            int checkY;
            int checkX = from.x + (dx > 0.0f ? (int)Math.floor(dx * (float)i) : (int)Math.ceil(dx * (float)i));
            if (this.canStandAt(checkX, checkY = from.y + (dy > 0.0f ? (int)Math.floor(dy * (float)i) : (int)Math.ceil(dy * (float)i)), checkZ = from.z + (dz > 0.0f ? (int)Math.floor(dz * (float)i) : (int)Math.ceil(dz * (float)i)))) continue;
            return true;
        }
        return false;
    }

    private boolean canStandAt(int x, int y, int z) {
        for (int dx = 0; dx < this.entityWidth; ++dx) {
            for (int dy = 0; dy < this.entityHeight; ++dy) {
                for (int dz = 0; dz < this.entityDepth; ++dz) {
                    if (!this.isBlockSolid(x + dx, y + dy, z + dz)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isBlockSolid(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        return this.context.level().method_8320(pos).method_26216((class_1922)this.context.level(), pos);
    }

    protected boolean isDiagonalValid(@Nullable TravelersNode node) {
        if (node == null || node.closed) {
            return false;
        }
        return node.type != TravelersPathType.WALKABLE_DOOR;
    }

    private boolean canReachWithoutCollision(TravelersNode node) {
        class_238 aabb = this.mob.method_5829();
        class_238 targetBox = new class_238((double)node.x, (double)node.y, (double)node.z, (double)node.x + aabb.method_17939(), (double)node.y + aabb.method_17940(), (double)node.z + aabb.method_17941());
        return !this.hasCollisions(targetBox);
    }

    protected double getFloorLevel(class_2338 pos) {
        class_1941 blockgetter = this.context.level();
        return (this.isCanFloat() || this.isAmphibious() || this.mob.method_24828()) && blockgetter.method_8316(pos).method_15767(class_3486.field_15517) ? (double)pos.method_10264() : TravelersWalkNodeEvaluator.getFloorLevel((class_1922)blockgetter, pos);
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(TravelersNode p_node, int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathType) {
        int blockLight;
        class_2338 pos;
        class_1937 level;
        int skyLight;
        int totalLight;
        int darkness;
        class_1937 i2;
        TravelersNode node = null;
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        blockpos$mutableblockpos.method_10103(x, y, z);
        TravelersPathType pathtype = this.getPathType(x, y, z);
        nodeFloorLevel = Math.floor(nodeFloorLevel);
        double diff = (double)y - nodeFloorLevel;
        if (Math.abs(diff) > Math.floor(this.getMobJumpHeight())) {
            return null;
        }
        float f = this.mob.getPathfindingMalus(pathtype);
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, f);
        }
        if (node != null) {
            int nodeResult = node.y - y;
            if ((double)Math.abs(nodeResult) > Math.floor(this.getMob().method_49476())) {
                return null;
            }
            if (p_node != null && this.cantMoveBetween(p_node, node)) {
                return null;
            }
        }
        if (node != null && node.costMalus >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (diff < -1.0 && node != null) {
            class_2338.class_2339 newPos = new class_2338.class_2339();
            newPos.method_10103(x, y, z);
            int i2 = (int)(-diff);
            while ((double)i2 > diff) {
                class_2680 state = this.context.getBlockState((class_2338)newPos.method_10098(class_2350.field_11036));
                if (state.method_51367()) {
                    return null;
                }
                --i2;
            }
        }
        if (pathtype != TravelersPathType.WALKABLE) {
            if ((node == null || node.costMalus < 0.0f) && (pathtype != TravelersPathType.FENCE || this.isCanWalkOverFences() || this.getMobJumpHeight() > (double)1.2f) && pathtype != TravelersPathType.UNPASSABLE_RAIL && pathtype != TravelersPathType.TRAPDOOR && pathtype != TravelersPathType.POWDER_SNOW) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType, blockpos$mutableblockpos);
            } else if (!(this.isAmphibious() || pathtype != TravelersPathType.WATER || this.isCanFloat() && !this.mob.method_24828())) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == TravelersPathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (TravelersWalkNodeEvaluator.doesBlockHavePartialCollision(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
        }
        if (this.triesToAvoidLight && node != null && pathtype == TravelersPathType.WALKABLE && (i2 = this.mob.method_37908()) instanceof class_1937 && (float)(darkness = 15 - (totalLight = Math.min(15, (skyLight = (level = i2).method_8314(class_1944.field_9284, pos = node.asBlockPos())) + (blockLight = level.method_8314(class_1944.field_9282, pos))))) < 2.0f) {
            node.type = TravelersPathType.LIGHT;
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!this.canMobStandAt(node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        class_238 box = this.mob.method_5829();
        double height = box.method_17940();
        int minY = y;
        int maxY = class_3532.method_15384((double)((double)y + height));
        for (int yi = minY; yi < maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (!(yi == minY ? type != TravelersPathType.WALKABLE && type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER : type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER)) continue;
            return false;
        }
        return true;
    }

    private double getMobJumpHeight() {
        SmartAnimalBase smartAnimalBase = this.mob;
        if (smartAnimalBase instanceof SmartAnimalBase) {
            SmartAnimalBase base = smartAnimalBase;
            return base.jumpHeight();
        }
        return 1.0;
    }

    private TravelersNode getNodeAndUpdateCostToMax(int x, int y, int z, TravelersPathType pathType, float malus) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private TravelersNode getBlockedNode(int x, int y, int z) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = TravelersPathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private TravelersNode getClosedNode(int x, int y, int z, TravelersPathType pathType) {
        TravelersNode node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private TravelersNode tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathType, class_2338.class_2339 pos) {
        TravelersNode node = this.findAcceptedNode(null, x, y + 1, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
        if (node == null) {
            return null;
        }
        if (node.type != TravelersPathType.OPEN && node.type != TravelersPathType.WALKABLE) {
            return node;
        }
        double d0 = (double)(x - direction.method_10148()) + 0.5;
        double d1 = (double)(z - direction.method_10165()) + 0.5;
        class_238 aabb = new class_238(d0 - 0.5, this.getFloorLevel((class_2338)pos.method_10103(x, y + 1, z)), d1 - 0.5, d0 + 0.5, this.getFloorLevel((class_2338)pos.method_10103((int)d0, y + (int)this.getMobJumpHeight(), (int)d1)), d1 + 0.5);
        if (this.hasCollisions(aabb)) {
            return null;
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int height = class_3532.method_15386((float)((float)this.entityHeight / 2.0f));
        for (int i = -1; i < height; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        class_238 box = this.mob.method_5829();
        double width = box.method_17939();
        double height = box.method_17940();
        double depth = box.method_17941();
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = class_3532.method_15357((double)(centerX - width / 2.0));
        int maxX = class_3532.method_15384((double)(centerX + width / 2.0));
        int minY = y;
        int maxY = class_3532.method_15384((double)((double)y + height));
        int minZ = class_3532.method_15357((double)(centerZ - depth / 2.0));
        int maxZ = class_3532.method_15384((double)(centerZ + depth / 2.0));
        for (int xi = minX; xi < maxX; ++xi) {
            for (int yi = minY; yi < maxY; ++yi) {
                for (int zi = minZ; zi < maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (!(yi == minY ? type != TravelersPathType.WALKABLE && type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER : type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private TravelersNode tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable TravelersNode node) {
        --y;
        while (y > this.mob.method_37908().method_31607()) {
            TravelersPathType pathtype = this.getPathType(x, y, z);
            if (pathtype != TravelersPathType.WATER) {
                return node;
            }
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, this.mob.getPathfindingMalus(pathtype));
            --y;
        }
        return node;
    }

    private TravelersNode tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.mob.method_37908().method_31607(); --i) {
            if (y - i > this.mob.method_5850()) {
                return this.getBlockedNode(x, i, z);
            }
            TravelersPathType pathtype = this.getPathType(x, i, z);
            float f = this.mob.getPathfindingMalus(pathtype);
            if (pathtype == TravelersPathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathtype, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    private boolean hasCollisions(class_238 boundingBox) {
        return !this.context.level().method_8587((class_1297)this.mob, boundingBox);
    }

    protected TravelersPathType getPathType(int x, int y, int z) {
        return (TravelersPathType)((Object)this.pathTypesByPosCacheByMob.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), p_330161_ -> this.getPathTypeOfMob(this.context, x, y, z, this.mob)));
    }

    @Override
    public TravelersPathType getPathTypeOfMob(TravelersPathfindingContext context, int x, int y, int z, SmartAnimalBase mob) {
        Set<TravelersPathType> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains((Object)TravelersPathType.FENCE)) {
            return TravelersPathType.FENCE;
        }
        if (set.contains((Object)TravelersPathType.UNPASSABLE_RAIL)) {
            return TravelersPathType.UNPASSABLE_RAIL;
        }
        TravelersPathType pathtype = TravelersPathType.BLOCKED;
        for (TravelersPathType pathtype1 : set) {
            if (mob.getPathfindingMalus(pathtype1) < 0.0f) {
                return pathtype1;
            }
            if (!(mob.getPathfindingMalus(pathtype1) >= mob.getPathfindingMalus(pathtype))) continue;
            pathtype = pathtype1;
        }
        return pathtype;
    }

    public Set<TravelersPathType> getPathTypeWithinMobBB(TravelersPathfindingContext context, int x, int y, int z) {
        EnumSet<TravelersPathType> enumset = EnumSet.noneOf(TravelersPathType.class);
        TravelersPathType pathtype = this.getPathType(context, x, y, z);
        boolean flag = this.isCanPassDoors();
        if (pathtype == TravelersPathType.DOOR_WOOD_CLOSED && this.isCanOpenDoors() && flag) {
            pathtype = TravelersPathType.WALKABLE_DOOR;
        }
        if (pathtype == TravelersPathType.DOOR_OPEN && !flag) {
            pathtype = TravelersPathType.BLOCKED;
        }
        enumset.add(pathtype);
        return enumset;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return TravelersWalkNodeEvaluator.getPathTypeStatic(context, new class_2338.class_2339(x, y, z));
    }

    public void setCanCrawl(boolean canCrawl) {
        this.canCrawl = canCrawl;
    }

    public boolean isTriesToAvoidLight() {
        return this.triesToAvoidLight;
    }
}

