/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import java.util.Arrays;
import java.util.NoSuchElementException;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;

public final class TravelersBinaryHeap {
    private TravelersNode[] heap = new TravelersNode[128];
    private int size = 0;

    public void insert(TravelersNode node) {
        if (node.heapIdx != -1) {
            throw new IllegalStateException("Node already in heap");
        }
        if (this.size == this.heap.length) {
            this.grow();
        }
        this.siftUp(this.size, node);
        ++this.size;
    }

    public TravelersNode pop() {
        if (this.size == 0) {
            throw new NoSuchElementException("Heap is empty");
        }
        TravelersNode root = this.heap[0];
        TravelersNode last = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size > 0) {
            this.siftDown(0, last);
        }
        root.heapIdx = -1;
        return root;
    }

    public void changeCost(TravelersNode node, float newF) {
        float old = node.f;
        node.f = newF;
        if (newF < old) {
            this.siftUp(node.heapIdx, node);
        } else {
            this.siftDown(node.heapIdx, node);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.heap, 0, this.size, null);
        this.size = 0;
    }

    private void siftUp(int i, TravelersNode node) {
        float f = node.f;
        while (i > 0) {
            int parent = i - 1 >>> 1;
            TravelersNode p = this.heap[parent];
            if (f >= p.f) break;
            this.heap[i] = p;
            p.heapIdx = i;
            i = parent;
        }
        this.heap[i] = node;
        node.heapIdx = i;
    }

    private void siftDown(int i, TravelersNode node) {
        int half = this.size >>> 1;
        float f = node.f;
        while (i < half) {
            int left = (i << 1) + 1;
            int right = left + 1;
            int child = left;
            TravelersNode c = this.heap[left];
            if (right < this.size && this.heap[right].f < c.f) {
                child = right;
                c = this.heap[right];
            }
            if (f <= c.f) break;
            this.heap[i] = c;
            c.heapIdx = i;
            i = child;
        }
        this.heap[i] = node;
        node.heapIdx = i;
    }

    private void grow() {
        this.heap = Arrays.copyOf(this.heap, this.heap.length << 1);
    }
}

