/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.obj;

import java.util.ArrayDeque;
import java.util.Deque;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersMoveAnalysis {
    private final SmartAnimalBase animal;
    private double lastX;
    private double lastY;
    private double lastZ;
    private final Deque<Double> dxHistory = new ArrayDeque<Double>();
    private final Deque<Double> dyHistory = new ArrayDeque<Double>();
    private final Deque<Double> dzHistory = new ArrayDeque<Double>();
    private final int smoothing;
    private static final double HORIZONTAL_EPS = 1.0E-4;
    private static final double VERTICAL_EPS = 1.0E-4;
    private double walkSpeed = 0.05;

    public TravelersMoveAnalysis(SmartAnimalBase smartAnimalBase, int smoothingTicks) {
        this.animal = smartAnimalBase;
        this.lastX = this.animal.method_23317();
        this.lastY = this.animal.method_23318();
        this.lastZ = this.animal.method_23321();
        this.smoothing = Math.max(1, smoothingTicks);
        this.walkSpeed = smartAnimalBase.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getMovementSpeed();
    }

    public void update() {
        double x = this.animal.method_23317();
        double y = this.animal.method_23318();
        double z = this.animal.method_23321();
        double dx = x - this.lastX;
        double dy = y - this.lastY;
        double dz = z - this.lastZ;
        this.push(this.dxHistory, dx);
        this.push(this.dyHistory, dy);
        this.push(this.dzHistory, dz);
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
    }

    private void push(Deque<Double> deque, double val) {
        deque.addLast(val);
        if (deque.size() > this.smoothing) {
            deque.removeFirst();
        }
    }

    private double avg(Deque<Double> deque) {
        if (deque.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (double d : deque) {
            sum += d;
        }
        return sum / (double)deque.size();
    }

    public double getHorizontalSpeed() {
        double dx = this.avg(this.dxHistory);
        double dz = this.avg(this.dzHistory);
        return Math.sqrt(dx * dx + dz * dz);
    }

    public double getVerticalSpeed() {
        return this.avg(this.dyHistory);
    }

    public double getSpeed() {
        double dx = this.avg(this.dxHistory);
        double dy = this.avg(this.dyHistory);
        double dz = this.avg(this.dzHistory);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public MovementState getMovementState() {
        double hSpeed = this.getHorizontalSpeed();
        double vSpeed = this.getVerticalSpeed();
        if (Math.abs(vSpeed) > 1.0E-4) {
            if (vSpeed > 0.0) {
                return MovementState.JUMPING;
            }
            return MovementState.FALLING;
        }
        if (hSpeed < 1.0E-4) {
            return MovementState.IDLE;
        }
        if (hSpeed < this.walkSpeed) {
            return MovementState.WALKING;
        }
        return MovementState.RUNNING;
    }

    public static enum MovementState {
        IDLE,
        WALKING,
        RUNNING,
        JUMPING,
        FALLING;

    }
}

