/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.obj.attributes;

import java.util.HashSet;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersAnimationControllers;
import travelers.server.animal.obj.locator.GeoSingleTextureLocator;
import travelers.server.animal.obj.locator.ResourceLocator;
import travelers.server.animal.obj.misc.AnimalSizeClass;
import travelers.server.animal.obj.misc.AnimalType;

public class EntityBaseProperties<T extends SmartAnimalBase> {
    private double renderScale = 1.0;
    private double renderScaleMale = -1.0;
    private double fov = 120.0;
    private double maxTurnRate = 25.0;
    private double turnSmoothRate = 1.0;
    private double maxHeadYRot = 35.0;
    private double maxHeadXRot = 20.0;
    private double boneResetTime = 20.0;
    private ResourceLocator<T> locator = new GeoSingleTextureLocator();
    private double[] dimensionsMale = null;
    private AnimalType animalType = AnimalType.REPTILE;
    private AnimalSizeClass sizeClass = AnimalSizeClass.SMALL;
    private boolean babyAnimations = false;
    private boolean requiresSpecialRenderer = false;
    private double sizeDimorphism = 90.0;
    private final HashSet<TravelersAnimationControllers.AnimationController> controllers = new HashSet();

    public EntityBaseProperties<T> addAnimationController(TravelersAnimationControllers.AnimationController controller) {
        this.controllers.add(controller);
        return this;
    }

    public EntityBaseProperties<T> setDimensionsMale(double width, double height) {
        this.dimensionsMale = new double[2];
        this.dimensionsMale[0] = width;
        this.dimensionsMale[1] = height;
        return this;
    }

    public EntityBaseProperties<T> setMaxHeadRotation(double maxHeadXRot, double maxHeadYRot) {
        this.maxHeadXRot = maxHeadXRot;
        this.maxHeadYRot = maxHeadYRot;
        return this;
    }

    public EntityBaseProperties<T> setBabyAnimations() {
        this.babyAnimations = true;
        return this;
    }

    public EntityBaseProperties<T> setSpecialRenderer() {
        this.requiresSpecialRenderer = true;
        return this;
    }

    public double getRenderScale() {
        return this.renderScale;
    }

    public double getRenderScaleMale() {
        return this.renderScaleMale;
    }

    public double getFov() {
        return this.fov;
    }

    public double getMaxTurnRate() {
        return this.maxTurnRate;
    }

    public double getTurnSmoothRate() {
        return this.turnSmoothRate;
    }

    public double getMaxHeadYRot() {
        return this.maxHeadYRot;
    }

    public double getMaxHeadXRot() {
        return this.maxHeadXRot;
    }

    public double getBoneResetTime() {
        return this.boneResetTime;
    }

    public ResourceLocator<T> getLocator() {
        return this.locator;
    }

    public double[] getDimensionsMale() {
        return this.dimensionsMale;
    }

    public AnimalType getAnimalType() {
        return this.animalType;
    }

    public AnimalSizeClass getSizeClass() {
        return this.sizeClass;
    }

    public boolean isBabyAnimations() {
        return this.babyAnimations;
    }

    public boolean isRequiresSpecialRenderer() {
        return this.requiresSpecialRenderer;
    }

    public double getSizeDimorphism() {
        return this.sizeDimorphism;
    }

    public HashSet<TravelersAnimationControllers.AnimationController> getControllers() {
        return this.controllers;
    }

    public EntityBaseProperties<T> setRenderScale(double renderScale) {
        this.renderScale = renderScale;
        return this;
    }

    public EntityBaseProperties<T> setRenderScaleMale(double renderScaleMale) {
        this.renderScaleMale = renderScaleMale;
        return this;
    }

    public EntityBaseProperties<T> setFov(double fov) {
        this.fov = fov;
        return this;
    }

    public EntityBaseProperties<T> setMaxTurnRate(double maxTurnRate) {
        this.maxTurnRate = maxTurnRate;
        return this;
    }

    public EntityBaseProperties<T> setTurnSmoothRate(double turnSmoothRate) {
        this.turnSmoothRate = turnSmoothRate;
        return this;
    }

    public EntityBaseProperties<T> setMaxHeadYRot(double maxHeadYRot) {
        this.maxHeadYRot = maxHeadYRot;
        return this;
    }

    public EntityBaseProperties<T> setMaxHeadXRot(double maxHeadXRot) {
        this.maxHeadXRot = maxHeadXRot;
        return this;
    }

    public EntityBaseProperties<T> setBoneResetTime(double boneResetTime) {
        this.boneResetTime = boneResetTime;
        return this;
    }

    public EntityBaseProperties<T> setLocator(ResourceLocator<T> locator) {
        this.locator = locator;
        return this;
    }

    public EntityBaseProperties<T> setAnimalType(AnimalType animalType) {
        this.animalType = animalType;
        return this;
    }

    public EntityBaseProperties<T> setSizeClass(AnimalSizeClass sizeClass) {
        this.sizeClass = sizeClass;
        return this;
    }

    public EntityBaseProperties<T> setSizeDimorphism(double sizeDimorphism) {
        this.sizeDimorphism = sizeDimorphism;
        return this;
    }
}

