/*
 * Decompiled with CFR 0.152.
 */
package travelers.util.helper;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import travelers.TravelersConstants;
import travelers.util.helper.obj.IGenericProperties;
import travelers.util.helper.obj.TravelerRegistryObject;

public class PlatformHelper {
    public static final LinkedHashSet<TravelerRegistryObject<?>> registryMap = new LinkedHashSet();
    public static final IGenericProperties properties = PlatformHelper.load(IGenericProperties.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        TravelersConstants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static <T> Supplier<T> register(class_2378<T> registry, class_2960 id, Supplier<T> supplier) {
        supplier = Suppliers.memoize(supplier);
        if (properties.getPlatformName().equalsIgnoreCase("fabric")) {
            properties.register(registry, id, supplier);
        } else {
            registryMap.add(new TravelerRegistryObject<T>(registry, id, supplier));
        }
        return supplier;
    }
}

