/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.debug;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_863;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;

public class TravelersPathfindingRenderer
implements class_863.class_864 {
    private final Map<Integer, PathData> paths = new ConcurrentHashMap<Integer, PathData>();
    private static final long LIFETIME = 5000L;

    private static void renderPath(class_4587 pose, class_4597 buf, PathData pathData, boolean showDebug, boolean showLabels, double camX, double camY, double camZ) {
        TravelersPath path = pathData.path;
        TravelersPathfindingRenderer.renderPathLine(pose, buf.getBuffer(class_1921.method_49043((double)6.0)), path, camX, camY, camZ);
        class_2338 target = path.getTarget();
        if (TravelersPathfindingRenderer.distanceToCamera(target, camX, camY, camZ) <= 80.0f) {
            TravelersPathfindingRenderer.renderPillar(pose, buf, target, camX, camY, camZ, 0.0f, 1.0f, 0.0f, 0.6f);
        }
        for (int i = 0; i < path.getNodeCount(); ++i) {
            boolean typeChange;
            TravelersNode node = path.getNode(i);
            if (TravelersPathfindingRenderer.distanceToCamera(node.asBlockPos(), camX, camY, camZ) > 80.0f) continue;
            double nx = (double)node.x + 0.5 - camX;
            double ny = (double)node.y + 0.1 - camY;
            double nz = (double)node.z + 0.5 - camZ;
            if (i == 0) {
                TravelersPathfindingRenderer.renderSphere(pose, buf, nx, ny, nz, 0.3f, 0.0f, 1.0f, 0.0f, 0.8f);
            } else if (i == path.getNextNodeIndex()) {
                TravelersPathfindingRenderer.renderDiamond(pose, buf, nx, ny, nz, 0.35f, 1.0f, 0.85f, 0.0f, 0.9f);
            } else {
                TravelersPathfindingRenderer.renderDisc(pose, buf, nx, ny, nz, 0.25f, 0.2f, 0.6f, 1.0f, 0.7f);
            }
            if (!showLabels) continue;
            boolean first = i == 0;
            boolean last = i == path.getNodeCount() - 1;
            boolean bl = typeChange = !first && !path.getNode((int)(i - 1)).type.equals((Object)node.type);
            if (!first && !last && !typeChange) continue;
            class_863.method_23107((class_4587)pose, (class_4597)buf, (String)(String.valueOf((Object)node.type) + " | " + String.format(Locale.ROOT, "%.2f", Float.valueOf(node.costMalus))), (double)((double)node.x + 0.5), (double)((double)node.y + 0.9), (double)((double)node.z + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
        }
        if (showDebug && path.debugData() != null) {
            for (TravelersNode n : path.debugData().closedSet()) {
                TravelersPathfindingRenderer.renderSphere(pose, buf, (double)n.x + 0.5 - camX, (double)n.y + 0.1 - camY, (double)n.z + 0.5 - camZ, 0.15f, 1.0f, 0.3f, 0.3f, 0.5f);
            }
            for (TravelersNode n : path.debugData().openSet()) {
                TravelersPathfindingRenderer.renderSphere(pose, buf, (double)n.x + 0.5 - camX, (double)n.y + 0.1 - camY, (double)n.z + 0.5 - camZ, 0.15f, 0.3f, 1.0f, 1.0f, 0.5f);
            }
        }
    }

    private static void renderPathLine(class_4587 pose, class_4588 consumer, TravelersPath path, double camX, double camY, double camZ) {
        for (int i = 0; i < path.getNodeCount(); ++i) {
            TravelersNode node = path.getNode(i);
            if (TravelersPathfindingRenderer.distanceToCamera(node.asBlockPos(), camX, camY, camZ) > 80.0f) continue;
            float hue = (float)i / (float)path.getNodeCount();
            int rgb = class_3532.method_15369((float)hue, (float)1.0f, (float)1.0f);
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            consumer.method_56824(pose.method_23760(), (float)((double)node.x - camX + 0.5), (float)((double)node.y - camY + 0.5), (float)((double)node.z - camZ + 0.5)).method_1336(r, g, b, 255);
        }
    }

    private static float distanceToCamera(class_2338 pos, double x, double y, double z) {
        double dx = (double)pos.method_10263() + 0.5 - x;
        double dy = (double)pos.method_10264() + 0.5 - y;
        double dz = (double)pos.method_10260() + 0.5 - z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static void renderDisc(class_4587 stack, class_4597 buf, double x, double y, double z, float radius, float r, float g, float b, float a) {
        class_863.method_23102((class_4587)stack, (class_4597)buf, (class_238)new class_238(x - (double)radius, y, z - (double)radius, x + (double)radius, y + 0.02, z + (double)radius), (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderSphere(class_4587 stack, class_4597 buf, double x, double y, double z, float radius, float r, float g, float b, float a) {
        class_863.method_23102((class_4587)stack, (class_4597)buf, (class_238)new class_238(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius), (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderDiamond(class_4587 stack, class_4597 buf, double x, double y, double z, float size, float r, float g, float b, float a) {
        class_863.method_23102((class_4587)stack, (class_4597)buf, (class_238)new class_238(x - (double)size, y - 0.1, z - (double)size, x + (double)size, y + (double)size * 1.5, z + (double)size), (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderPillar(class_4587 stack, class_4597 buf, class_2338 pos, double camX, double camY, double camZ, float r, float g, float b, float a) {
        class_863.method_23102((class_4587)stack, (class_4597)buf, (class_238)new class_238((double)pos.method_10263() + 0.25 - camX, (double)pos.method_10264() - camY, (double)pos.method_10260() + 0.25 - camZ, (double)pos.method_10263() + 0.75 - camX, (double)pos.method_10264() + 2.0 - camY, (double)pos.method_10260() + 0.75 - camZ), (float)r, (float)g, (float)b, (float)a);
    }

    public void addPath(int entityId, TravelersPath path, float maxDist) {
        this.paths.put(entityId, new PathData(path, maxDist, class_156.method_658()));
    }

    public void method_23109(class_4587 pose, class_4597 buf, double camX, double camY, double camZ) {
        if (this.paths.isEmpty()) {
            return;
        }
        long now = class_156.method_658();
        for (PathData data : this.paths.values()) {
            TravelersPathfindingRenderer.renderPath(pose, buf, data, true, true, camX, camY, camZ);
        }
        this.paths.entrySet().removeIf(e -> ((PathData)e.getValue()).path.isDone() || now - ((PathData)e.getValue()).created > 5000L);
    }

    private record PathData(TravelersPath path, float maxDist, long created) {
    }
}

