/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3532;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class TravelersClientAnimator {
    protected final Map<String, TravelersAnimationData> boneOffsetCache = new HashMap<String, TravelersAnimationData>();
    private final HashMap<String, SmartAnimalBase> bases = new HashMap();

    public final void update(SmartAnimalBase animatable, float partialTick) {
        TravelersAnimationData animData = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        this.updateModel(animatable, partialTick, animData);
    }

    protected TravelersAnimationData createData() {
        return new TravelersAnimationData();
    }

    protected List<TravelersBoneState> getBones(TravelersAnimationData animData, String ... bones) {
        ArrayList<TravelersBoneState> states = new ArrayList<TravelersBoneState>();
        for (String bone : bones) {
            states.add(this.bone(animData, bone));
        }
        return states;
    }

    protected TravelersBoneState bone(TravelersAnimationData animData, String name) {
        return animData.boneMap.computeIfAbsent(name, string -> new TravelersBoneState());
    }

    public abstract void updateModel(SmartAnimalBase var1, float var2, TravelersAnimationData var3);

    public int maxYawAngle() {
        return 45;
    }

    public int maxPitchAngle() {
        return 45;
    }

    public void faceTarget(SmartAnimalBase animatable, float partialTick, float rotationDivisor, List<TravelersBoneState> boneNames) {
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        float yawAmount = 0.0f;
        float pitchAmount = 0.0f;
        if (data.canFace) {
            float bodyYaw = class_3532.method_16439((float)partialTick, (float)animatable.field_6220, (float)animatable.field_6283);
            float headYaw = class_3532.method_16439((float)partialTick, (float)animatable.field_6259, (float)animatable.method_5791());
            float pitch = class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455());
            float yawDelta = class_3532.method_15393((float)(headYaw - bodyYaw));
            float actualRotationDivisor = rotationDivisor * (float)boneNames.size();
            yawAmount = -(yawDelta * ((float)Math.PI / 180)) / actualRotationDivisor;
            pitchAmount = -(pitch * ((float)Math.PI / 180)) / actualRotationDivisor;
            float maxYaw = (float)this.maxYawAngle() * ((float)Math.PI / 180);
            float maxPitch = (float)this.maxPitchAngle() * ((float)Math.PI / 180);
            yawAmount = class_3532.method_15363((float)yawAmount, (float)(-maxYaw), (float)maxYaw);
            pitchAmount = class_3532.method_15363((float)pitchAmount, (float)(-maxPitch), (float)maxPitch);
        }
        for (TravelersBoneState state : boneNames) {
            if (data.canFace) {
                state.angleYo = state.angleY;
                state.angleY = class_3532.method_16439((float)0.001f, (float)state.angleY, (float)yawAmount);
                state.angleXo = state.angleX;
                state.angleX = class_3532.method_16439((float)0.001f, (float)state.angleX, (float)pitchAmount);
                continue;
            }
            state.angleYo = state.angleY;
            state.angleY = class_3532.method_16439((float)0.001f, (float)state.angleY, (float)0.0f);
            state.angleXo = state.angleX;
            state.angleX = class_3532.method_16439((float)0.001f, (float)state.angleX, (float)0.0f);
        }
    }

    public void chainWave(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float waveAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        for (int i = 0; i < boneNames.size(); ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            float rotation = this.calculateChainRotation(speed, degree, (float)animatable.field_6012 + deltaTime, waveAmount, offset, i);
            state.angleXo = state.angleX;
            state.angleX = rotation;
        }
    }

    public void chainSwing(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        for (int i = 0; i < boneNames.size(); ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            float rotation = this.calculateChainRotation(speed, degree, (float)animatable.field_6012 + deltaTime, swingAmount, offset, i);
            state.angleYo = state.angleY;
            state.angleY = rotation;
        }
    }

    public void chainFlap(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float flapAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.method_5845(), id -> this.createData());
        for (int i = 0; i < boneNames.size(); ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            float rotation = this.calculateChainRotation(speed, degree, (float)animatable.field_6012 + deltaTime, flapAmount, offset, i);
            state.angleZo = state.angleZ;
            state.angleZ = rotation;
        }
    }

    private float calculateChainRotation(float animationSpeed, float maxDegree, float animationProgress, float amplitude, float phaseOffset, int segmentIndex) {
        float phase = animationProgress * animationSpeed + phaseOffset * (float)segmentIndex;
        return class_3532.method_15362((float)phase) * amplitude * maxDegree;
    }

    private float calculateChainOffset(double rootOffset, List<String> boneNames) {
        return (float)(rootOffset * Math.PI / (double)(2 * boneNames.size()));
    }

    public void setTrigger(SmartAnimalBase entity) {
        this.bases.put(entity.method_5667().toString(), entity);
    }

    public boolean shouldTrigger() {
        return !this.bases.isEmpty();
    }

    public void remove(SmartAnimalBase entity) {
        this.bases.remove(entity.method_5667().toString());
        this.boneOffsetCache.remove(entity.method_5845());
    }

    public TravelersBoneState updateAnimationOnBone(SmartAnimalBase base, String bone) {
        TravelersAnimationData data = this.boneOffsetCache.get(base.method_5845());
        if (data != null) {
            return data.boneMap.get(bone);
        }
        return null;
    }

    public void clientTick(SmartAnimalBase base) {
        this.getData(base).tick(base);
    }

    protected TravelersAnimationData getData(SmartAnimalBase base) {
        return this.boneOffsetCache.computeIfAbsent(base.method_5845(), string -> this.createData());
    }
}

