/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersLegSolver {
    public final Leg[] legs;

    public TravelersLegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(SmartAnimalBase entity, float scale) {
        this.update(entity, entity.method_36454(), scale);
    }

    public final void update(SmartAnimalBase entity, float yaw, float scale) {
        double radians = Math.toRadians(yaw);
        double sideX = Math.cos(radians) * (double)scale;
        double sideZ = Math.sin(radians) * (double)scale;
        double forwardX = Math.cos(radians + 1.5707963267948966) * (double)scale;
        double forwardZ = Math.sin(radians + 1.5707963267948966) * (double)scale;
        double posX = entity.method_19538().field_1352;
        double posY = entity.method_19538().field_1351;
        double posZ = entity.method_19538().field_1350;
        for (Leg leg : this.legs) {
            leg.update(entity, posX, posY, posZ, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side, float range) {
            this.forward = forward;
            this.side = side;
            this.range = range;
        }

        public final float getHeight(float delta) {
            return class_3532.method_16439((float)delta, (float)this.prevHeight, (float)this.height);
        }

        public void update(SmartAnimalBase entity, double baseX, double baseY, double baseZ, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double targetX = baseX + sideX * (double)this.side + forwardX * (double)this.forward;
            double targetZ = baseZ + sideZ * (double)this.side + forwardZ * (double)this.forward;
            double targetY = baseY;
            float settledHeight = this.settle(entity, targetX, targetY, targetZ, this.height, scale);
            this.height = Math.clamp(settledHeight, -this.range * scale, this.range * scale);
        }

        private float settle(SmartAnimalBase entity, double x, double y, double z, float currentHeight, float scale) {
            class_1937 level = entity.method_37908();
            class_2338.class_2339 pos = new class_2338.class_2339();
            pos.method_10102(x, y, z);
            double localY = y - Math.floor(y);
            float surfaceOffset = this.getSurfaceOffset(entity, level, (class_2338)pos);
            if ((double)surfaceOffset >= 0.999) {
                pos.method_33098(pos.method_10264() - 1);
                surfaceOffset = this.getSurfaceOffset(entity, level, (class_2338)pos) + (float)localY;
            } else {
                surfaceOffset -= 1.0f - (float)localY;
            }
            if (entity.method_24828()) {
                return surfaceOffset;
            }
            return 0.0f;
        }

        private float getSurfaceOffset(SmartAnimalBase entity, class_1937 level, class_2338 pos) {
            class_2338.class_2339 mutableBlockPos = pos.method_25503();
            int depth = (int)Math.floor(entity.method_17682() / 3.0f);
            if (depth < 1) {
                depth = 1;
            }
            float accumulatedDepth = 0.0f;
            for (int i = 0; i < depth; ++i) {
                class_2338 newPos = mutableBlockPos.method_10087(i);
                class_2680 state = level.method_8320(newPos);
                class_265 shape = state.method_26220((class_1922)level, newPos);
                if (shape.method_1110()) {
                    accumulatedDepth += 1.0f;
                    continue;
                }
                accumulatedDepth += (float)(1.0 - shape.method_1105(class_2350.class_2351.field_11052));
                break;
            }
            return accumulatedDepth;
        }
    }
}

