/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.other;

import java.util.HashMap;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.obj.animation.TravelersAnimationWrapper;

public class TravelersAnimalAnimationModule {
    public final HashMap<String, AnimationState> animationMap = new HashMap();
    public final SmartAnimalBase base;
    public final TravelersAnimal<?> travelersAnimal;

    public TravelersAnimalAnimationModule(SmartAnimalBase base) {
        this.base = base;
        this.travelersAnimal = base.getAnimal();
    }

    public boolean playTransition(boolean play, TravelersAnimationWrapper startAnimation, TravelersAnimationWrapper loopedAnimation, TravelersAnimationWrapper outAnimation) {
        return this.playTransition(play, false, startAnimation, loopedAnimation, outAnimation);
    }

    public boolean playTransition(boolean play, boolean stopInPlace, TravelersAnimationWrapper startAnimation, TravelersAnimationWrapper loopedAnimation, TravelersAnimationWrapper outAnimation) {
        String key = startAnimation.getAnimation().getName() + "." + loopedAnimation.getAnimation().getName() + "." + outAnimation.getAnimation().getName();
        AnimationState state = this.animationMap.getOrDefault(key, new AnimationState(0, Phase.IDLE));
        int startDur = startAnimation.getTickDuration();
        int outDur = outAnimation.getTickDuration();
        if (play) {
            this.base.method_55695();
            if (state.phase == Phase.IDLE) {
                state.phase = Phase.START;
                state.ticks = 0;
            }
            if (state.phase == Phase.START) {
                if (state.ticks < startDur) {
                    startAnimation.getAnimation().sendForEntity(this.base);
                    ++state.ticks;
                } else {
                    state.phase = Phase.LOOP;
                    state.ticks = 0;
                    loopedAnimation.getAnimation().sendForEntity(this.base);
                }
                this.animationMap.put(key, state);
                return true;
            }
            if (state.phase == Phase.LOOP) {
                loopedAnimation.getAnimation().sendForEntity(this.base);
                this.animationMap.put(key, state);
                return true;
            }
            if (state.phase == Phase.OUT) {
                state.phase = Phase.LOOP;
                state.ticks = 0;
                loopedAnimation.getAnimation().sendForEntity(this.base);
                this.animationMap.put(key, state);
                return true;
            }
        } else {
            if (state.phase == Phase.IDLE) {
                return false;
            }
            if (state.phase == Phase.LOOP) {
                state.phase = Phase.OUT;
                state.ticks = 0;
            }
            if (state.phase == Phase.START) {
                if (state.ticks < startDur) {
                    startAnimation.getAnimation().sendForEntity(this.base);
                    ++state.ticks;
                    if (state.ticks < startDur) {
                        this.animationMap.put(key, state);
                        return true;
                    }
                }
                state.phase = Phase.OUT;
                state.ticks = 0;
            }
            if (state.phase == Phase.OUT) {
                outAnimation.getAnimation().sendForEntity(this.base);
                ++state.ticks;
                if (state.ticks >= outDur) {
                    this.animationMap.remove(key);
                    return false;
                }
                this.animationMap.put(key, state);
                return true;
            }
        }
        this.animationMap.put(key, state);
        return true;
    }

    public static class AnimationState {
        int ticks;
        Phase phase;

        AnimationState(int ticks, Phase phase) {
            this.ticks = ticks;
            this.phase = phase;
        }
    }

    private static enum Phase {
        IDLE,
        START,
        LOOP,
        OUT;

    }
}

