/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_5996;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersConstants;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersPath {
    private final List<TravelersNode> nodes;
    private final class_2338 target;
    private final float distToTarget;
    private final boolean reached;
    @Nullable
    private DebugData debugData;
    private int nextNodeIndex;

    public TravelersPath(List<TravelersNode> nodes, class_2338 target, boolean reached) {
        this.nodes = nodes;
        this.target = target;
        this.distToTarget = nodes.isEmpty() ? Float.MAX_VALUE : this.nodes.getLast().distanceManhattan(this.target);
        this.reached = reached;
        this.setDebug(new TravelersNode[0], new TravelersNode[0], Set.of(new TravelersTarget(target.method_10263(), target.method_10264(), target.method_10260())));
    }

    public static TravelersPath createFromStream(class_2540 buf) {
        boolean flag = buf.readBoolean();
        int i = buf.readInt();
        class_2338 blockpos = buf.method_10811();
        List list = buf.method_34066(TravelersNode::createFromStream);
        DebugData path$debugdata = DebugData.read(buf);
        TravelersPath path = new TravelersPath(list, blockpos, flag);
        path.debugData = path$debugdata;
        path.nextNodeIndex = i;
        return path;
    }

    public static void writeNodeArray(class_2540 buffer, TravelersNode[] array) {
        buffer.method_53002(array.length);
        for (TravelersNode node : array) {
            node.writeToStream(buffer);
        }
    }

    public static TravelersNode[] readNodeArray(class_2540 buffer) {
        int length = buffer.readInt();
        TravelersNode[] array = new TravelersNode[length];
        for (int i = 0; i < length; ++i) {
            array[i] = TravelersNode.createFromStream(buffer);
        }
        return array;
    }

    public void advance() {
        ++this.nextNodeIndex;
    }

    public boolean notStarted() {
        return this.nextNodeIndex <= 0;
    }

    public boolean isDone() {
        return this.nextNodeIndex >= this.nodes.size();
    }

    @Nullable
    public TravelersNode getEndNode() {
        return !this.nodes.isEmpty() ? this.nodes.getLast() : null;
    }

    public TravelersNode getNode(int index) {
        return this.nodes.get(index);
    }

    public void replaceNode(int index, TravelersNode point) {
        this.nodes.set(index, point);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public class_243 getEntityPosAtNode(class_1297 entity, int index) {
        if (index >= this.nodes.size()) {
            TravelersConstants.LOGGER.error("getEntityPosAtNode - Index out of bounds! Size:{} Index:{}", (Object)(this.nodes.size() - 1), (Object)index);
            return new class_243(0.0, 0.0, 0.0);
        }
        TravelersNode node = this.nodes.get(index);
        double d0 = (double)node.x + 0.5;
        double d1 = node.y;
        double d2 = (double)node.z + 0.5;
        return new class_243(d0, d1, d2);
    }

    public class_2338 getNodePos(int index) {
        if (index >= this.nodes.size()) {
            TravelersConstants.LOGGER.error("getNodePos - Index out of bounds! Size:{} Index:{}", (Object)(this.nodes.size() - 1), (Object)index);
            return class_2338.field_10980;
        }
        return this.nodes.get(index).asBlockPos();
    }

    public class_243 getNextEntityPos(class_1297 entity) {
        return this.getEntityPosAtNode(entity, this.nextNodeIndex);
    }

    public class_2338 getNextNodePos() {
        return this.nodes.get(this.nextNodeIndex).asBlockPos();
    }

    public TravelersNode getNextNode() {
        return this.nodes.get(this.nextNodeIndex);
    }

    @Nullable
    public TravelersNode getPreviousNode() {
        return this.nextNodeIndex > 0 ? this.nodes.get(this.nextNodeIndex - 1) : null;
    }

    public boolean sameAs(@Nullable TravelersPath pathentity) {
        if (pathentity == null) {
            return false;
        }
        if (pathentity.nodes.size() != this.nodes.size()) {
            return false;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            TravelersNode node = this.nodes.get(i);
            TravelersNode node1 = pathentity.nodes.get(i);
            if (node.x == node1.x && node.y == node1.y && node.z == node1.z) continue;
            return false;
        }
        return true;
    }

    public boolean canReach() {
        return this.reached;
    }

    @class_5996
    void setDebug(TravelersNode[] openSet, TravelersNode[] closedSet, Set<TravelersTarget> targetNodes) {
        this.debugData = new DebugData(openSet, closedSet, targetNodes);
    }

    @Nullable
    public DebugData debugData() {
        return this.debugData;
    }

    public void writeToStream(class_2540 buffer) {
        if (this.debugData != null && !this.debugData.targetNodes.isEmpty()) {
            buffer.method_52964(this.reached);
            buffer.method_53002(this.nextNodeIndex);
            buffer.method_10807(this.target);
            buffer.method_34062(this.nodes, (buf, node) -> node.writeToStream((class_2540)buf));
            this.debugData.write(buffer);
        }
    }

    public String toString() {
        return "Path(length=" + this.nodes.size() + ")";
    }

    public TravelersPath copy() {
        TravelersPath path = new TravelersPath(this.nodes, this.target, this.reached);
        path.debugData = this.debugData;
        path.nextNodeIndex = this.nextNodeIndex;
        return path;
    }

    public List<TravelersNode> getNodes() {
        return this.nodes;
    }

    public class_2338 getTarget() {
        return this.target;
    }

    public float getDistToTarget() {
        return this.distToTarget;
    }

    public boolean isReached() {
        return this.reached;
    }

    @Nullable
    public DebugData getDebugData() {
        return this.debugData;
    }

    public int getNextNodeIndex() {
        return this.nextNodeIndex;
    }

    public void setDebugData(@Nullable DebugData debugData) {
        this.debugData = debugData;
    }

    public void setNextNodeIndex(int nextNodeIndex) {
        this.nextNodeIndex = nextNodeIndex;
    }

    public record DebugData(TravelersNode[] openSet, TravelersNode[] closedSet, Set<TravelersTarget> targetNodes) {
        public static DebugData read(class_2540 buffer) {
            HashSet hashset = (HashSet)buffer.method_34068(HashSet::new, TravelersTarget::createFromStream);
            TravelersNode[] anode = TravelersPath.readNodeArray(buffer);
            TravelersNode[] anode1 = TravelersPath.readNodeArray(buffer);
            return new DebugData(anode, anode1, hashset);
        }

        public void write(class_2540 buffer) {
            buffer.method_34062(this.targetNodes, (p_295084_, p_294361_) -> p_294361_.writeToStream((class_2540)p_295084_));
            TravelersPath.writeNodeArray(buffer, this.openSet);
            TravelersPath.writeNodeArray(buffer, this.closedSet);
        }
    }
}

