/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersBinaryHeap;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersPathFinder {
    private final TravelersNode[] neighbors = new TravelersNode[64];
    private final int maxVisitedNodes;
    private final TravelersNodeEvaluator nodeEvaluator;

    public TravelersPathFinder(TravelersNodeEvaluator evaluator) {
        this.nodeEvaluator = evaluator;
        this.maxVisitedNodes = 300;
    }

    public CompletableFuture<TravelersPath> findPathAsync(class_1950 region, SmartAnimalBase mob, Set<class_2338> targets, float maxRange, int accuracy, float depthMul) {
        return CompletableFuture.supplyAsync(() -> {
            TravelersPathFinder travelersPathFinder = this;
            synchronized (travelersPathFinder) {
                TravelersNodeEvaluator evaluator = this.nodeEvaluator.copy();
                TravelersBinaryHeap openSet = new TravelersBinaryHeap();
                HashSet<TravelersTarget> reached = new HashSet<TravelersTarget>();
                ArrayList<TravelersTarget> targetList = new ArrayList<TravelersTarget>();
                evaluator.prepare(region, mob);
                TravelersNode start = evaluator.getStart();
                if (start == null) {
                    evaluator.done();
                    return null;
                }
                for (class_2338 pos : targets) {
                    TravelersTarget t = evaluator.getTarget(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    t.setTargetPos(pos);
                    targetList.add(t);
                }
                TravelersPath path = this.findPath(evaluator, openSet, reached, targetList, start, maxRange, accuracy);
                evaluator.done();
                evaluator = null;
                return path;
            }
        });
    }

    public TravelersPath findPath(TravelersNodeEvaluator nodeEvaluator, TravelersBinaryHeap openSet, HashSet<TravelersTarget> reached, ArrayList<TravelersTarget> targetList, class_1950 region, SmartAnimalBase mob, Set<class_2338> targets, float maxRange, int accuracy, float depthMul) {
        nodeEvaluator.prepare(region, mob);
        TravelersNode start = nodeEvaluator.getStart();
        if (start == null) {
            nodeEvaluator.done();
            return null;
        }
        for (class_2338 pos : targets) {
            TravelersTarget t = nodeEvaluator.getTarget(pos.method_10263(), pos.method_10264(), pos.method_10260());
            t.setTargetPos(pos);
            targetList.add(t);
        }
        TravelersPath path = this.findPath(nodeEvaluator, openSet, reached, targetList, start, maxRange, accuracy);
        nodeEvaluator.done();
        return path;
    }

    @Nullable
    private TravelersPath findPath(TravelersNodeEvaluator nodeEvaluator, TravelersBinaryHeap openSet, HashSet<TravelersTarget> reached, ArrayList<TravelersTarget> targetList, TravelersNode start, float maxRange, int accuracy) {
        start.g = 0.0f;
        start.walkedDistance = 0.0f;
        start.f = start.h = this.getBestH(targetList, start);
        start.cameFrom = null;
        openSet.insert(start);
        int visits = 0;
        while (!openSet.isEmpty() && visits++ < this.maxVisitedNodes) {
            TravelersNode current = openSet.pop();
            current.closed = true;
            for (TravelersTarget target : targetList) {
                if (!(current.distanceManhattan(target) < (float)accuracy)) continue;
                target.setReached(true);
                reached.add(target);
            }
            if (!reached.isEmpty()) break;
            float distFromStart = current.distanceTo(start);
            if (distFromStart >= maxRange) continue;
            int count = nodeEvaluator.getNeighbors(this.neighbors, current);
            for (int i = 0; i < count; ++i) {
                TravelersNode neighbor = this.neighbors[i];
                float stepCost = current.distanceTo(neighbor);
                float totalG = current.g + stepCost + neighbor.costMalus;
                if (neighbor.walkedDistance >= maxRange || neighbor.inOpenSet() && totalG >= neighbor.g - 1.0E-6f) continue;
                neighbor.walkedDistance = current.walkedDistance + stepCost;
                neighbor.cameFrom = current;
                neighbor.g = totalG;
                neighbor.h = this.getBestH(targetList, neighbor) * 1.5f;
                neighbor.f = neighbor.g + neighbor.h;
                if (neighbor.inOpenSet()) {
                    openSet.changeCost(neighbor, neighbor.f);
                    continue;
                }
                openSet.insert(neighbor);
            }
        }
        return reached.isEmpty() ? this.getClosestUnreachedPath(targetList) : this.getBestReachedPath(reached);
    }

    private float getBestH(ArrayList<TravelersTarget> targetList, TravelersNode node) {
        float best = Float.MAX_VALUE;
        for (TravelersTarget t : targetList) {
            float dist = node.distanceTo(t);
            t.updateBest(dist, node);
            if (!(dist < best)) continue;
            best = dist;
        }
        return best;
    }

    private TravelersPath getClosestUnreachedPath(ArrayList<TravelersTarget> targetList) {
        TravelersPath best = null;
        int bestCount = Integer.MAX_VALUE;
        double bestDist = Double.MAX_VALUE;
        for (TravelersTarget target : targetList) {
            TravelersPath path = this.reconstructPath(target.getBestNode(), target.getTargetPos(), false);
            int count = path.getNodeCount();
            double dist = path.getDistToTarget();
            if (!(dist < bestDist) && (dist != bestDist || count >= bestCount)) continue;
            best = path;
            bestDist = dist;
            bestCount = count;
        }
        return best;
    }

    private TravelersPath getBestReachedPath(HashSet<TravelersTarget> reached) {
        TravelersPath best = null;
        int bestCount = Integer.MAX_VALUE;
        for (TravelersTarget target : reached) {
            TravelersPath path = this.reconstructPath(target.getBestNode(), target.getTargetPos(), true);
            int count = path.getNodeCount();
            if (count >= bestCount) continue;
            best = path;
            bestCount = count;
        }
        return best;
    }

    private TravelersPath reconstructPath(TravelersNode end, class_2338 target, boolean reachesTarget) {
        ArrayList<TravelersNode> path = new ArrayList<TravelersNode>();
        TravelersNode n = end;
        while (n != null) {
            path.add(n);
            n = n.cameFrom;
        }
        Collections.reverse(path);
        return new TravelersPath(path, target, reachesTarget);
    }
}

