/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.class_3532;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.control.TravelersMoveControl;

public class TravelersFlyingMoveControl
extends TravelersMoveControl {
    private final float maxTurn;
    private final boolean hoversInPlace;

    public TravelersFlyingMoveControl(SmartAnimalBase mob, TravelersAnimal<?> animal, boolean hoversInPlace) {
        super(mob, animal);
        this.hoversInPlace = hoversInPlace;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
    }

    @Override
    public void tick() {
        if (!this.mob.canMove()) {
            return;
        }
        if (this.operation == TravelersMoveControl.Operation.MOVE_TO && this.mob.getNavigationController().isInProgress()) {
            double deltaZ;
            double deltaY;
            double deltaX = this.wantedX - this.mob.method_23317();
            double totalDeltaSqr = deltaX * deltaX + (deltaY = this.wantedY - this.mob.method_23318()) * deltaY + (deltaZ = this.wantedZ - this.mob.method_23321()) * deltaZ;
            if (totalDeltaSqr < 2.5E-7) {
                this.mob.method_5930(0.0f);
            } else {
                double horizDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                float moveSpeed = this.mob.method_6029();
                if (Math.abs(deltaY) > horizDist * 1.5) {
                    this.mob.method_6125(0.0f);
                    this.mob.method_5930(0.0f);
                    this.mob.method_5938(0.0f);
                    this.mob.method_5976(deltaY > 0.0 ? moveSpeed : -moveSpeed);
                    return;
                }
                if (Math.abs(deltaY) < horizDist * 1.5) {
                    float targetYaw = (float)(class_3532.method_15349((double)deltaZ, (double)deltaX) * 180.0 / Math.PI) - 90.0f;
                    float smoothedYaw = this.rotlerp(this.mob.method_36454(), targetYaw, this.maxTurn);
                    this.mob.method_36456(smoothedYaw);
                    this.mob.field_6283 = smoothedYaw;
                    this.mob.field_6241 = smoothedYaw;
                }
                if (Math.abs(deltaY) > (double)1.0E-5f || Math.abs(horizDist) > (double)1.0E-5f) {
                    float targetPitch = -((float)(class_3532.method_15349((double)deltaY, (double)horizDist) * 180.0 / Math.PI));
                    targetPitch = class_3532.method_15363((float)class_3532.method_15393((float)targetPitch), (float)(-this.maxTurn), (float)this.maxTurn);
                    float smoothedPitch = this.rotlerp(this.mob.method_36455(), targetPitch, this.maxTurn);
                    this.mob.method_36457(smoothedPitch);
                }
                this.mob.method_6125(moveSpeed);
                this.mob.method_5976(deltaY > 0.0 ? moveSpeed * 0.6f : -moveSpeed * 0.6f);
            }
        } else {
            this.mob.method_6125(0.0f);
            if (this.hoversInPlace) {
                this.mob.method_5976(0.0f);
                this.mob.method_5930(0.0f);
                this.mob.method_5938(0.0f);
            } else {
                this.mob.method_5976(class_3532.method_16439((float)0.1f, (float)this.mob.field_6227, (float)0.0f));
                this.mob.method_5930(class_3532.method_16439((float)0.1f, (float)this.mob.field_6250, (float)0.0f));
                this.mob.method_5938(class_3532.method_16439((float)0.1f, (float)this.mob.field_6212, (float)0.0f));
            }
        }
    }
}

