/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.control;

import net.minecraft.class_1297;
import net.minecraft.class_3532;
import net.minecraft.class_6035;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersMoveControl
implements class_6035 {
    protected final float maxTurn;
    protected final float turnSmoothRate;
    protected final SmartAnimalBase mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected Operation operation = Operation.WAIT;

    public TravelersMoveControl(SmartAnimalBase pMob, TravelersAnimal<?> animal) {
        this.mob = pMob;
        this.maxTurn = (float)animal.getAnimalAttributes().getEntityBaseProperties().getMaxTurnRate();
        this.turnSmoothRate = (float)animal.getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
    }

    public void setWantedPosition(double pX, double pY, double pZ, double pSpeed) {
        this.wantedX = pX;
        this.wantedY = pY;
        this.wantedZ = pZ;
        this.speedModifier = pSpeed;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void tick() {
        switch (this.operation.ordinal()) {
            case 1: {
                this.handleMoveTo();
                break;
            }
            case 3: {
                this.handleJumping();
                break;
            }
            default: {
                this.mob.method_5930(0.0f);
            }
        }
    }

    protected void handleMoveTo() {
        double dZ;
        double dY;
        this.operation = Operation.WAIT;
        double dX = this.wantedX - this.mob.method_23317();
        double distanceSquared = dX * dX + (dY = this.wantedY - this.mob.method_23318()) * dY + (dZ = this.wantedZ - this.mob.method_23321()) * dZ;
        if (distanceSquared < 2.500000277905201E-7) {
            this.mob.method_5930(0.0f);
            return;
        }
        float targetAngle = (float)(class_3532.method_15349((double)dZ, (double)dX) * 180.0 / Math.PI) - 90.0f;
        this.mob.method_36456(this.rotlerp(this.mob.method_36454(), targetAngle, this.getTurnSpeed()));
        this.mob.method_6125((float)(this.speedModifier * (double)this.mob.method_6029()));
        if (this.shouldJump(dY, dX, dZ)) {
            this.mob.method_5988().method_20248(this.wantedX, this.wantedY, this.wantedZ);
            this.mob.method_5993().method_6233();
            this.operation = Operation.JUMPING;
        }
    }

    protected void handleJumping() {
        if (this.mob.method_5988().method_38970()) {
            this.mob.method_6125((float)(this.speedModifier * (double)this.mob.method_6029()));
        }
        if (this.mob.method_24828()) {
            this.operation = Operation.WAIT;
        }
    }

    protected boolean shouldJump(double dY, double dX, double dZ) {
        double distanceTo = this.mob.method_5649(this.mob.method_23317() + dX, this.mob.method_23318(), this.mob.method_23321() + dZ);
        if (distanceTo < (double)(this.mob.method_17681() * 1.1f)) {
            boolean collides;
            boolean bl = collides = !this.mob.method_37908().method_52569((class_1297)this.mob, this.mob.method_5829().method_1012(0.0, dY, 0.0));
            if (collides) {
                return false;
            }
            return dY > (double)this.mob.method_49476() && dY <= this.mob.jumpHeight();
        }
        return false;
    }

    protected float rotlerp(float from, float to, float rate) {
        float delta = class_3532.method_15393((float)(to - from));
        return from + delta * class_3532.method_15363((float)rate, (float)0.0f, (float)1.0f);
    }

    protected float getTurnSpeed() {
        float TURN = this.maxTurn;
        float multiplier = this.mob.getTurnMultiplier();
        if (multiplier > 0.0f && multiplier != 1.0f) {
            TURN *= multiplier;
        }
        return TURN;
    }

    protected static enum Operation {
        WAIT,
        MOVE_TO,
        STRAFE,
        JUMPING;

    }
}

