/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.class_1308;
import net.minecraft.class_1941;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3922;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public abstract class TravelersNodeEvaluator {
    protected final Int2ObjectMap<TravelersNode> nodes = new Int2ObjectOpenHashMap();
    protected TravelersPathfindingContext context;
    protected SmartAnimalBase mob;
    protected int entityWidth;
    protected int entityHeight;
    protected int entityDepth;
    protected boolean canPassDoors;
    protected boolean canOpenDoors;
    protected boolean canFloat;
    protected boolean canWalkOverFences;

    public static boolean isBurningBlock(class_2680 state) {
        return state.method_26164(class_3481.field_21952) || state.method_27852(class_2246.field_10164) || state.method_27852(class_2246.field_10092) || class_3922.method_23896((class_2680)state) || state.method_27852(class_2246.field_27098);
    }

    public abstract TravelersNodeEvaluator copy();

    protected void applyDefaultProperties(TravelersNodeEvaluator eval) {
        eval.mob = this.mob;
        eval.canPassDoors = this.canPassDoors;
        eval.canOpenDoors = this.canOpenDoors;
        eval.canFloat = this.canFloat;
        eval.canWalkOverFences = this.canWalkOverFences;
    }

    public void prepare(class_1950 level, SmartAnimalBase mob) {
        this.context = new TravelersPathfindingContext((class_1941)level, (class_1308)mob);
        this.mob = mob;
        this.nodes.clear();
        float width = mob.method_17681();
        this.entityWidth = this.entityDepth = class_3532.method_15386((float)width);
        this.entityHeight = class_3532.method_15386((float)mob.method_17682());
    }

    public void done() {
        this.context = null;
        this.mob = null;
    }

    protected TravelersNode getNode(class_2338 pos) {
        return this.getNode(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    protected TravelersNode getNode(int x, int y, int z) {
        return (TravelersNode)this.nodes.computeIfAbsent(TravelersNode.createHash(x, y, z), $ -> new TravelersNode(x, y, z));
    }

    protected TravelersTarget getTargetNodeAt(double x, double y, double z) {
        return new TravelersTarget(this.getNode(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z)));
    }

    public TravelersPathType getPathType(class_1308 mob, class_2338 pos) {
        return this.getPathType(new TravelersPathfindingContext((class_1941)mob.method_37908(), mob), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public abstract TravelersNode getStart();

    public abstract TravelersTarget getTarget(double var1, double var3, double var5);

    public abstract int getNeighbors(TravelersNode[] var1, TravelersNode var2);

    public abstract TravelersPathType getPathTypeOfMob(TravelersPathfindingContext var1, int var2, int var3, int var4, SmartAnimalBase var5);

    public abstract TravelersPathType getPathType(TravelersPathfindingContext var1, int var2, int var3, int var4);

    public void markDirty(class_2338 pos) {
    }

    public Int2ObjectMap<TravelersNode> getNodes() {
        return this.nodes;
    }

    public TravelersPathfindingContext getContext() {
        return this.context;
    }

    public SmartAnimalBase getMob() {
        return this.mob;
    }

    public int getEntityWidth() {
        return this.entityWidth;
    }

    public int getEntityHeight() {
        return this.entityHeight;
    }

    public int getEntityDepth() {
        return this.entityDepth;
    }

    public boolean isCanPassDoors() {
        return this.canPassDoors;
    }

    public boolean isCanOpenDoors() {
        return this.canOpenDoors;
    }

    public boolean isCanFloat() {
        return this.canFloat;
    }

    public boolean isCanWalkOverFences() {
        return this.canWalkOverFences;
    }

    public void setContext(TravelersPathfindingContext context) {
        this.context = context;
    }

    public void setMob(SmartAnimalBase mob) {
        this.mob = mob;
    }

    public void setEntityWidth(int entityWidth) {
        this.entityWidth = entityWidth;
    }

    public void setEntityHeight(int entityHeight) {
        this.entityHeight = entityHeight;
    }

    public void setEntityDepth(int entityDepth) {
        this.entityDepth = entityDepth;
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.canPassDoors = canPassDoors;
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.canOpenDoors = canOpenDoors;
    }

    public void setCanFloat(boolean canFloat) {
        this.canFloat = canFloat;
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.canWalkOverFences = canWalkOverFences;
    }
}

