/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.class_10;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersSwimNodeEvaluator
extends TravelersNodeEvaluator {
    private final boolean allowBreaching;
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public TravelersSwimNodeEvaluator(boolean allowBreaching) {
        this.allowBreaching = allowBreaching;
    }

    private static boolean hasMalus(@Nullable TravelersNode node) {
        return node != null && node.costMalus >= 0.0f;
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersSwimNodeEvaluator nodeEvaluator = new TravelersSwimNodeEvaluator(this.allowBreaching);
        this.applyDefaultProperties(nodeEvaluator);
        return nodeEvaluator;
    }

    @Override
    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.pathTypesByPosCache.clear();
    }

    @Override
    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_238 box = this.mob.method_5829();
        double centerX = (box.field_1323 + box.field_1320) * 0.5;
        double centerY = (box.field_1322 + box.field_1325) * 0.5;
        double centerZ = (box.field_1321 + box.field_1324) * 0.5;
        int y = class_3532.method_15357((double)centerY);
        pos.method_10102(centerX, (double)y, centerZ);
        class_2680 state = this.context.getBlockState((class_2338)pos);
        if (!state.method_26227().method_39360((class_3611)class_3612.field_15910)) {
            boolean found = false;
            for (int dy = 1; dy <= 6; ++dy) {
                class_2680 down = this.context.getBlockState((class_2338)pos.method_10102(centerX, (double)(y - dy), centerZ));
                if (down.method_26227().method_39360((class_3611)class_3612.field_15910)) {
                    y -= dy;
                    found = true;
                    break;
                }
                class_2680 up = this.context.getBlockState((class_2338)pos.method_10102(centerX, (double)(y + dy), centerZ));
                if (!up.method_26227().method_39360((class_3611)class_3612.field_15910)) continue;
                y += dy;
                found = true;
                break;
            }
            if (!found) {
                y = class_3532.method_15357((double)this.mob.method_23318());
            }
        }
        return this.getNode((class_2338)pos.method_33098(y));
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, @NotNull TravelersNode p_node) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            TravelersNode node = this.findAcceptedNode(p_node.x + direction.method_10148(), p_node.y + direction.method_10164(), p_node.z + direction.method_10165());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            outputArray[i++] = node;
        }
        for (class_2350 direction1 : class_2350.class_2353.field_11062) {
            TravelersNode node1;
            class_2350 direction2 = direction1.method_10170();
            if (!TravelersSwimNodeEvaluator.hasMalus((TravelersNode)map.get(direction1)) || !TravelersSwimNodeEvaluator.hasMalus((TravelersNode)map.get(direction2)) || !this.isNodeValid(node1 = this.findAcceptedNode(p_node.x + direction1.method_10148() + direction2.method_10148(), p_node.y, p_node.z + direction1.method_10165() + direction2.method_10165()))) continue;
            outputArray[i++] = node1;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable TravelersNode node) {
        return node != null && !node.closed;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(int x, int y, int z) {
        float f;
        TravelersNode node = null;
        TravelersPathType pathtype = this.getCachedBlockType(x, y, z);
        if ((this.allowBreaching && pathtype == TravelersPathType.BREACH || pathtype == TravelersPathType.WATER) && (f = this.mob.getPathfindingMalus(pathtype)) >= 0.0f) {
            node = this.getNode(x, y, z);
            node.type = pathtype;
            node.costMalus = Math.max(node.costMalus, f);
            class_2338 pos = new class_2338(x, y, z);
            class_1941 level = this.context.level();
            if (!level.method_8320(pos).method_26220((class_1922)level, pos).method_1110()) {
                return null;
            }
            if (level.method_8316(pos).method_15769()) {
                node.costMalus += 8.0f;
            }
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!this.canMobStandAt(node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int height = class_3532.method_15386((float)((float)this.entityHeight / 2.0f));
        int halfHeight = Math.max(1, height / 2);
        for (int i = -halfHeight; i < halfHeight; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        class_238 box = this.mob.method_5829();
        double width = box.method_17939();
        double height = box.method_17940();
        double depth = box.method_17941();
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = class_3532.method_15357((double)(centerX - width / 2.0));
        int maxX = class_3532.method_15384((double)(centerX + width / 2.0));
        int maxY = class_3532.method_15384((double)((double)y + height));
        int minZ = class_3532.method_15357((double)(centerZ - depth / 2.0));
        int maxZ = class_3532.method_15384((double)(centerZ + depth / 2.0));
        for (int xi = minX; xi < maxX; ++xi) {
            for (int yi = y; yi < maxY; ++yi) {
                for (int zi = minZ; zi < maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        class_238 box = this.mob.method_5829();
        double height = box.method_17940();
        double halfHeight = height / 2.0;
        int minY = class_3532.method_15357((double)((double)y + halfHeight));
        int maxY = class_3532.method_15384((double)((double)y + halfHeight));
        for (int yi = minY; yi < maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (!(yi == minY ? type != TravelersPathType.WALKABLE && type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER : type != TravelersPathType.OPEN && type != TravelersPathType.WATER && type != TravelersPathType.WATER_BORDER)) continue;
            return false;
        }
        return true;
    }

    protected TravelersPathType getCachedBlockType(int x, int y, int z) {
        return (TravelersPathType)((Object)this.pathTypesByPosCache.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), p_330157_ -> this.getPathType(this.context, x, y, z)));
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return this.getPathTypeOfMob(context, x, y, z, this.mob);
    }

    @Override
    @NotNull
    public TravelersPathType getPathTypeOfMob(@NotNull TravelersPathfindingContext context, int x, int y, int z, @NotNull SmartAnimalBase mob) {
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        class_2680 blockstate = context.getBlockState((class_2338)blockpos$mutableblockpos.method_10103(x, y, z));
        class_3610 fluidstate = blockstate.method_26227();
        if (fluidstate.method_15769() && blockstate.method_26171(class_10.field_48) && blockstate.method_26215()) {
            return TravelersPathType.BREACH;
        }
        class_2680 blockstate1 = context.getBlockState((class_2338)blockpos$mutableblockpos);
        return blockstate1.method_26171(class_10.field_48) ? TravelersPathType.WATER : TravelersPathType.BREACH;
    }
}

