/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1944;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2541;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersWalkNodeEvaluator
extends TravelersNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private boolean canCrawl = false;
    private boolean triesToAvoidLight = false;
    private boolean canClimb;
    private boolean canClimbAnyBlock = false;

    private static boolean doesBlockHavePartialCollision(TravelersPathType pathType) {
        return pathType == TravelersPathType.FENCE || pathType == TravelersPathType.DOOR_WOOD_CLOSED || pathType == TravelersPathType.DOOR_IRON_CLOSED;
    }

    public static double getFloorLevel(class_1922 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_265 voxelshape = level.method_8320(blockpos).method_26220(level, blockpos);
        return (double)blockpos.method_10264() + (voxelshape.method_1110() ? 0.0 : voxelshape.method_1105(class_2350.class_2351.field_11052));
    }

    public static TravelersPathType getPathTypeStatic(SmartAnimalBase base, class_2338 pos) {
        return TravelersWalkNodeEvaluator.getPathTypeStatic(new TravelersPathfindingContext((class_1941)base.method_37908(), (class_1308)base), pos.method_25503());
    }

    public static TravelersPathType getPathTypeStatic(TravelersPathfindingContext context, class_2338.class_2339 pos) {
        int k;
        int j;
        int i = pos.method_10263();
        TravelersPathType pathtype = context.getPathTypeFromState(i, j = pos.method_10264(), k = pos.method_10260());
        if (pathtype == TravelersPathType.OPEN && j >= context.level().method_31607() + 1) {
            return switch (context.getPathTypeFromState(i, j - 1, k)) {
                case TravelersPathType.OPEN, TravelersPathType.WATER, TravelersPathType.WALKABLE, TravelersPathType.LIGHT -> TravelersPathType.OPEN;
                case TravelersPathType.LAVA -> TravelersPathType.LAVA;
                case TravelersPathType.DAMAGE_FIRE -> TravelersPathType.DAMAGE_FIRE;
                case TravelersPathType.DAMAGE_OTHER -> TravelersPathType.DAMAGE_OTHER;
                case TravelersPathType.STICKY_HONEY -> TravelersPathType.STICKY_HONEY;
                case TravelersPathType.POWDER_SNOW -> TravelersPathType.DANGER_POWDER_SNOW;
                case TravelersPathType.DAMAGE_CAUTIOUS -> TravelersPathType.DAMAGE_CAUTIOUS;
                case TravelersPathType.TRAPDOOR -> TravelersPathType.DANGER_TRAPDOOR;
                default -> TravelersWalkNodeEvaluator.checkNeighbourBlocks(context, i, j, k, TravelersPathType.WALKABLE);
            };
        }
        return pathtype;
    }

    public static TravelersPathType checkNeighbourBlocks(TravelersPathfindingContext context, int x, int y, int z, TravelersPathType pathType) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    TravelersPathType pathtype = context.getPathTypeFromState(x + i, y + j, z + k);
                    context.mutablePos.method_10103(x + i, y + j, z + k);
                    if (pathtype == TravelersPathType.DAMAGE_OTHER) {
                        return TravelersPathType.DANGER_OTHER;
                    }
                    if (pathtype == TravelersPathType.DAMAGE_FIRE || pathtype == TravelersPathType.LAVA) {
                        return TravelersPathType.DANGER_FIRE;
                    }
                    if (pathtype == TravelersPathType.WATER) {
                        return TravelersPathType.WATER_BORDER;
                    }
                    if (pathtype != TravelersPathType.DAMAGE_CAUTIOUS) continue;
                    return TravelersPathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pathType;
    }

    @Override
    public void markDirty(class_2338 pos) {
        this.pathTypesByPosCacheByMob.remove(pos.method_10063());
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersWalkNodeEvaluator nodeEvaluator = new TravelersWalkNodeEvaluator();
        this.applyDefaultProperties(nodeEvaluator);
        nodeEvaluator.canCrawl = this.canCrawl;
        nodeEvaluator.triesToAvoidLight = this.triesToAvoidLight;
        return nodeEvaluator;
    }

    @Override
    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.triesToAvoidLight = mob.avoidsLight();
        mob.method_51504();
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.method_51503();
        }
        this.pathTypesByPosCacheByMob.clear();
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        class_243 p = this.mob.method_19538();
        class_2338 start = class_2338.method_49637((double)p.field_1352, (double)p.field_1351, (double)p.field_1350);
        class_2338 resolved = this.findStandableStartDownOnly(start);
        return this.getStartNode(resolved);
    }

    private class_2338 findStandableStartDownOnly(class_2338 start) {
        int minY = this.mob.method_37908().method_31607();
        int startY = start.method_10264();
        int widthBlocks = class_3532.method_15386((float)this.mob.method_17681());
        int radiusMax = Math.min(8, Math.max(1, widthBlocks));
        int maxDepth = Math.max(1, class_3532.method_15375((float)(this.mob.method_17682() / 2.0f)));
        int deepestY = Math.max(startY - maxDepth, minY);
        for (int y = startY; y >= deepestY; --y) {
            class_2338 base = new class_2338(start.method_10263(), y, start.method_10260());
            if (this.isSpaceValidForStanding(base.method_10263(), base.method_10264(), base.method_10260())) {
                return base;
            }
            for (int r = 1; r <= radiusMax; ++r) {
                int x0 = base.method_10263();
                int z0 = base.method_10260();
                for (int dx = -r; dx <= r; ++dx) {
                    class_2338 p1 = new class_2338(x0 + dx, y, z0 - r);
                    if (this.isSpaceValidForStanding(p1.method_10263(), p1.method_10264(), p1.method_10260())) {
                        return p1;
                    }
                    class_2338 p2 = new class_2338(x0 + dx, y, z0 + r);
                    if (!this.isSpaceValidForStanding(p2.method_10263(), p2.method_10264(), p2.method_10260())) continue;
                    return p2;
                }
                for (int dz = -r + 1; dz <= r - 1; ++dz) {
                    class_2338 p3 = new class_2338(x0 - r, y, z0 + dz);
                    if (this.isSpaceValidForStanding(p3.method_10263(), p3.method_10264(), p3.method_10260())) {
                        return p3;
                    }
                    class_2338 p4 = new class_2338(x0 + r, y, z0 + dz);
                    if (!this.isSpaceValidForStanding(p4.method_10263(), p4.method_10264(), p4.method_10260())) continue;
                    return p4;
                }
            }
        }
        return start;
    }

    protected TravelersNode getStartNode(class_2338 pos) {
        TravelersNode node = this.getNode(pos);
        node.type = this.getPathType(node.x, node.y, node.z);
        node.costMalus = this.mob.getPathfindingMalus(node.type);
        return node;
    }

    protected boolean canStartAt(class_2338 pos) {
        TravelersPathType pathtype = this.getPathType(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return pathtype != TravelersPathType.OPEN && this.mob.getPathfindingMalus(pathtype) >= 0.0f;
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        int i = 0;
        int j = 0;
        TravelersPathType pathtype = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType pathtype1 = this.getPathType(p_node.x, p_node.y, p_node.z);
        if (this.mob.getPathfindingMalus(pathtype) >= 0.0f && pathtype1 != TravelersPathType.STICKY_HONEY) {
            j = class_3532.method_15375((float)Math.max(1.0f, this.mob.method_49476() + 0.1f));
        }
        double d0 = this.getFloorLevel(new class_2338(p_node.x, p_node.y, p_node.z));
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            TravelersNode node = this.findAcceptedNode(p_node, p_node.x + direction.method_10148(), p_node.y, p_node.z + direction.method_10165(), j, d0, direction, pathtype1);
            if (!this.isNeighborValid(node, p_node)) continue;
            outputArray[i++] = node;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && !neighbor.closed && (neighbor.costMalus >= 0.0f || node.costMalus < 0.0f);
    }

    private boolean cantMoveBetween(TravelersNode from, TravelersNode to) {
        int steps = Math.max(Math.abs(to.x - from.x), Math.max(Math.abs(to.y - from.y), Math.abs(to.z - from.z)));
        if (steps == 0) {
            return false;
        }
        float dx = (float)(to.x - from.x) / (float)steps;
        float dy = (float)(to.y - from.y) / (float)steps;
        float dz = (float)(to.z - from.z) / (float)steps;
        for (int i = 1; i <= steps; ++i) {
            int checkZ;
            int checkY;
            int checkX = from.x + (dx > 0.0f ? (int)Math.floor(dx * (float)i) : (int)Math.ceil(dx * (float)i));
            if (this.canStandAt(checkX, checkY = from.y + (dy > 0.0f ? (int)Math.floor(dy * (float)i) : (int)Math.ceil(dy * (float)i)), checkZ = from.z + (dz > 0.0f ? (int)Math.floor(dz * (float)i) : (int)Math.ceil(dz * (float)i)))) continue;
            return true;
        }
        return false;
    }

    private boolean canStandAt(int x, int y, int z) {
        for (int dx = 0; dx < this.entityWidth; ++dx) {
            for (int dy = 0; dy < this.entityHeight; ++dy) {
                for (int dz = 0; dz < this.entityDepth; ++dz) {
                    if (!this.isBlockSolid(x + dx, y + dy, z + dz)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isBlockSolid(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        return this.context.level().method_8320(pos).method_26216((class_1922)this.context.level(), pos);
    }

    private boolean canReachWithoutCollision(TravelersNode node) {
        class_238 aabb = this.mob.method_5829();
        class_238 targetBox = new class_238((double)node.x, (double)node.y, (double)node.z, (double)node.x + aabb.method_17939(), (double)node.y + aabb.method_17940(), (double)node.z + aabb.method_17941());
        return !this.hasCollisions(targetBox);
    }

    protected double getFloorLevel(class_2338 pos) {
        class_1941 blockgetter = this.context.level();
        return (this.isCanFloat() || this.isAmphibious() || this.mob.method_24828()) && blockgetter.method_8316(pos).method_15767(class_3486.field_15517) ? (double)pos.method_10264() : TravelersWalkNodeEvaluator.getFloorLevel((class_1922)blockgetter, pos);
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(TravelersNode p_node, int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathType) {
        int blockLight;
        class_2338 pos;
        class_1937 level;
        int skyLight;
        int totalLight;
        int darkness;
        class_1937 i2;
        TravelersNode node = null;
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        blockpos$mutableblockpos.method_10103(x, y, z);
        TravelersPathType pathtype = this.getPathType(x, y, z);
        nodeFloorLevel = Math.floor(nodeFloorLevel);
        double diff = (double)y - nodeFloorLevel;
        if (Math.abs(diff) > Math.floor(this.getMobJumpHeight())) {
            return null;
        }
        float f = this.mob.getPathfindingMalus(pathtype);
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, f);
        }
        if (node != null) {
            int nodeResult = node.y - y;
            if ((double)Math.abs(nodeResult) > Math.floor(this.getMob().method_49476())) {
                return null;
            }
            if (p_node != null && this.cantMoveBetween(p_node, node)) {
                return null;
            }
        }
        if (node != null && node.costMalus >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (diff < -1.0 && node != null) {
            class_2338.class_2339 newPos = new class_2338.class_2339();
            newPos.method_10103(x, y, z);
            int i2 = (int)(-diff);
            while ((double)i2 > diff) {
                class_2680 state = this.context.getBlockState(newPos.method_10084());
                if (state.method_26216((class_1922)this.context.level(), newPos.method_10084())) {
                    return null;
                }
                --i2;
            }
        }
        if (pathtype != TravelersPathType.WALKABLE) {
            if ((node == null || node.costMalus < 0.0f) && (pathtype != TravelersPathType.FENCE || this.isCanWalkOverFences() || this.getMobJumpHeight() > (double)1.2f) && pathtype != TravelersPathType.UNPASSABLE_RAIL && pathtype != TravelersPathType.TRAPDOOR && pathtype != TravelersPathType.POWDER_SNOW) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType, blockpos$mutableblockpos);
            } else if (!(this.isAmphibious() || pathtype != TravelersPathType.WATER || this.isCanFloat() && !this.mob.method_24828())) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == TravelersPathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (TravelersWalkNodeEvaluator.doesBlockHavePartialCollision(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
        }
        if (this.triesToAvoidLight && node != null && pathtype == TravelersPathType.WALKABLE && (i2 = this.mob.method_37908()) instanceof class_1937 && (float)(darkness = 15 - (totalLight = Math.min(15, (skyLight = (level = i2).method_8314(class_1944.field_9284, pos = node.asBlockPos())) + (blockLight = level.method_8314(class_1944.field_9282, pos))))) < 2.0f) {
            node.type = TravelersPathType.LIGHT;
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!this.canMobStandAt(node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        double height = this.mob.method_17682();
        int maxY = y + class_3532.method_15384((double)height) - 1;
        for (int yi = y; yi <= maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(x, yi, z)) : !this.canClimb || !this.isClimbableAt(x, yi, z))) continue;
            return false;
        }
        return true;
    }

    private boolean isClimbableAt(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        class_2680 s = this.context.level().method_8320(pos);
        if (this.canClimbAnyBlock) {
            return s.method_26220((class_1922)this.context.level(), pos).method_1110();
        }
        if (!this.canClimb) {
            return false;
        }
        if (s.method_26204() instanceof class_2399 || s.method_26204() instanceof class_2541) {
            return true;
        }
        if (s.method_27852(class_2246.field_16492)) {
            return true;
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2680 sid = this.context.level().method_8320(pos.method_10093(dir));
            if (!(sid.method_26204() instanceof class_2399) && !(sid.method_26204() instanceof class_2541) && !sid.method_27852(class_2246.field_16492)) continue;
            return true;
        }
        return false;
    }

    private double getMobJumpHeight() {
        SmartAnimalBase smartAnimalBase = this.mob;
        if (smartAnimalBase instanceof SmartAnimalBase) {
            SmartAnimalBase base = smartAnimalBase;
            return this.canClimb ? base.climbHeight() : base.jumpHeight();
        }
        return 1.0;
    }

    private TravelersNode getNodeAndUpdateCostToMax(int x, int y, int z, TravelersPathType pathType, float malus) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private TravelersNode getBlockedNode(int x, int y, int z) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = TravelersPathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private TravelersNode getClosedNode(int x, int y, int z, TravelersPathType pathType) {
        TravelersNode node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private TravelersNode tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, TravelersPathType pathType, class_2338.class_2339 pos) {
        TravelersNode node = this.findAcceptedNode(null, x, y + 1, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
        if (node == null) {
            return null;
        }
        if (node.type != TravelersPathType.OPEN && node.type != TravelersPathType.WALKABLE) {
            return node;
        }
        double d0 = (double)(x - direction.method_10148()) + 0.5;
        double d1 = (double)(z - direction.method_10165()) + 0.5;
        class_238 aabb = new class_238(d0 - 0.5, this.getFloorLevel((class_2338)pos.method_10103(x, y + 1, z)), d1 - 0.5, d0 + 0.5, this.getFloorLevel((class_2338)pos.method_10103((int)d0, y + (int)this.getMobJumpHeight(), (int)d1)), d1 + 0.5);
        if (this.hasCollisions(aabb)) {
            return null;
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int height = class_3532.method_15386((float)((float)this.entityHeight / 2.0f));
        for (int i = -1; i < height; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        double width = this.mob.method_17681();
        double height = this.mob.method_17682();
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = class_3532.method_15357((double)(centerX - width / 2.0));
        int maxX = class_3532.method_15357((double)(centerX + width / 2.0));
        int maxY = class_3532.method_15357((double)((double)y + height));
        int minZ = class_3532.method_15357((double)(centerZ - width / 2.0));
        int maxZ = class_3532.method_15357((double)(centerZ + width / 2.0));
        for (int xi = minX; xi <= maxX; ++xi) {
            for (int yi = y; yi <= maxY; ++yi) {
                for (int zi = minZ; zi <= maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(xi, yi, zi)) : !this.canClimb || !this.isClimbableAt(xi, yi, zi))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private TravelersNode tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable TravelersNode node) {
        --y;
        while (y > this.mob.method_37908().method_31607()) {
            TravelersPathType pathtype = this.getPathType(x, y, z);
            if (pathtype != TravelersPathType.WATER) {
                return node;
            }
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, this.mob.getPathfindingMalus(pathtype));
            --y;
        }
        return node;
    }

    private TravelersNode tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.mob.method_37908().method_31607(); --i) {
            if (y - i > this.mob.method_5850()) {
                return this.getBlockedNode(x, i, z);
            }
            TravelersPathType pathtype = this.getPathType(x, i, z);
            float f = this.mob.getPathfindingMalus(pathtype);
            if (pathtype == TravelersPathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathtype, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    private boolean hasCollisions(class_238 boundingBox) {
        return !this.context.level().method_8587((class_1297)this.mob, boundingBox);
    }

    protected TravelersPathType getPathType(int x, int y, int z) {
        return (TravelersPathType)((Object)this.pathTypesByPosCacheByMob.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), p -> this.getPathTypeOfMob(this.context, x, y, z, this.mob)));
    }

    @Override
    public TravelersPathType getPathTypeOfMob(TravelersPathfindingContext context, int x, int y, int z, SmartAnimalBase mob) {
        Set<TravelersPathType> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains((Object)TravelersPathType.FENCE)) {
            return TravelersPathType.FENCE;
        }
        if (set.contains((Object)TravelersPathType.UNPASSABLE_RAIL)) {
            return TravelersPathType.UNPASSABLE_RAIL;
        }
        TravelersPathType pathtype = TravelersPathType.BLOCKED;
        for (TravelersPathType pathtype1 : set) {
            if (mob.getPathfindingMalus(pathtype1) < 0.0f) {
                return pathtype1;
            }
            if (!(mob.getPathfindingMalus(pathtype1) >= mob.getPathfindingMalus(pathtype))) continue;
            pathtype = pathtype1;
        }
        return pathtype;
    }

    public Set<TravelersPathType> getPathTypeWithinMobBB(TravelersPathfindingContext context, int x, int y, int z) {
        EnumSet<TravelersPathType> enumset = EnumSet.noneOf(TravelersPathType.class);
        TravelersPathType pathtype = this.getPathType(context, x, y, z);
        boolean flag = this.isCanPassDoors();
        if (pathtype == TravelersPathType.DOOR_WOOD_CLOSED && this.isCanOpenDoors() && flag) {
            pathtype = TravelersPathType.WALKABLE_DOOR;
        }
        if (pathtype == TravelersPathType.DOOR_OPEN && !flag) {
            pathtype = TravelersPathType.BLOCKED;
        }
        enumset.add(pathtype);
        return enumset;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return TravelersWalkNodeEvaluator.getPathTypeStatic(context, new class_2338.class_2339(x, y, z));
    }

    public void setCanCrawl(boolean canCrawl) {
        this.canCrawl = canCrawl;
    }

    public boolean isTriesToAvoidLight() {
        return this.triesToAvoidLight;
    }

    public void setCanClimb(boolean canClimb) {
        this.canClimb = canClimb;
    }

    public void setCanClimbAnyBlock(boolean canClimbAnyBlock) {
        this.canClimbAnyBlock = canClimbAnyBlock;
    }
}

