/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.vanilla;

import java.util.function.ToDoubleFunction;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.vanilla.TLGoalUtils;
import travelers.server.animal.entity.pathingsystem.vanilla.TLRandomPos;

public class TLLandRandomPos {
    @Nullable
    public static class_243 getPos(SmartAnimalBase mob, int radius, int verticalRange) {
        return TLLandRandomPos.getPos(mob, radius, verticalRange, arg_0 -> ((SmartAnimalBase)mob).method_6149(arg_0));
    }

    @Nullable
    public static class_243 getPos(SmartAnimalBase mob, int radius, int yRange, ToDoubleFunction<class_2338> scorer) {
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLRandomPos.generateBestRandomPos(() -> {
            class_2338 offset = TLRandomPos.generateRandomDirection(radius, yRange);
            class_2338 candidate = TLLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? TLLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, scorer);
    }

    @Nullable
    public static class_243 getPosTowards(SmartAnimalBase mob, int radius, int yRange, class_243 target) {
        class_243 direction = target.method_1020(mob.method_19538());
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    public static class_243 getPosAway(SmartAnimalBase mob, int radius, int yRange, class_243 dangerSource) {
        class_243 direction = mob.method_19538().method_1020(dangerSource);
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    private static class_243 getPosInDirection(SmartAnimalBase mob, int radius, int yRange, class_243 direction, boolean restricted) {
        return TLRandomPos.generateBestRandomPos(() -> {
            class_2338 offset = TLRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, direction.field_1352, direction.field_1350, 1.5707963267948966);
            if (offset == null) {
                return null;
            }
            class_2338 candidate = TLLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? TLLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).method_6149(arg_0));
    }

    @Nullable
    private static class_2338 movePosUpOutOfSolid(SmartAnimalBase mob, class_2338 pos) {
        return !TLGoalUtils.isWater(mob, pos = TLRandomPos.moveUpOutOfSolid(pos, mob.method_37908().method_31600(), p -> TLGoalUtils.isSolid(mob, p))) && !TLGoalUtils.hasMalus(mob, pos) ? pos : null;
    }

    @Nullable
    private static class_2338 generateValidRandomTarget(SmartAnimalBase mob, int radius, boolean restricted, class_2338 offset) {
        class_2338 candidate = TLRandomPos.generateRandomPosTowardDirection(mob, radius, offset);
        return candidate != null && !TLGoalUtils.isOutsideLimits(candidate, mob) && !TLGoalUtils.isRestricted(restricted, mob, candidate) && !TLGoalUtils.isNotStable(mob.getNavigationController(), candidate) ? candidate : null;
    }
}

