/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import com.google.common.base.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import travelers.FabricTravelers;
import travelers.FabricTravelersClient;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.world.TravelersBiomeModificator;
import travelers.util.helper.obj.IGenericProperties;
import travelers.world.FabricTravelersBiomeModificator;

public class FabricGenericProperties
implements IGenericProperties {
    private static final FabricTravelersBiomeModificator biomeModificator = new FabricTravelersBiomeModificator();

    @Override
    public String getPlatformName() {
        return "fabric";
    }

    @Override
    public MinecraftServer getServer() {
        return FabricTravelers.getServer();
    }

    @Override
    public void sendToPlayersTrackingEntity(class_1297 mob, class_8710 payload) {
        if (mob.method_37908() instanceof class_3218) {
            for (class_3222 serverPlayer : PlayerLookup.tracking((class_1297)mob)) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)payload);
            }
        }
    }

    @Override
    public void sendToPlayersTrackingBlockEntity(class_2586 blockEntity, class_8710 payload) {
        if (blockEntity.method_10997() instanceof class_3218) {
            for (class_3222 serverPlayer : PlayerLookup.tracking((class_2586)blockEntity)) {
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)payload);
            }
        }
    }

    @Override
    public void sendToServer(class_8710 payload) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            FabricTravelersClient.sendToServer(payload);
        }
    }

    @Override
    public void sendToPlayer(class_3222 player, class_8710 payload) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    @Override
    public <T> void register(class_2378<T> registry, class_2960 id, Supplier<T> supplier) {
        class_2378.method_10230(registry, (class_2960)id, (Object)supplier.get());
    }

    @Override
    public <T extends SmartAnimalBase> void registerAnimal(TravelersAnimal<T> animal) {
        FabricDefaultAttributeRegistry.register((class_1299)((class_1299)animal.getEntityType().get()), (class_5132.class_5133)animal.createAnimalAttributes());
        if (animal.getItems() != null) {
            animal.getItems().initSpawnEgg(animal.getAnimalAttributes(), animal);
        }
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public TravelersBiomeModificator getBiomeModificator() {
        return biomeModificator;
    }
}

