/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersFlyNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private final class_2338.class_2339 tempPos = new class_2338.class_2339();

    @Override
    public void prepare(@NotNull class_1950 level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.pathTypeByPosCache.clear();
        mob.method_51504();
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersFlyNodeEvaluator nodeEvaluator = new TravelersFlyNodeEvaluator();
        this.applyDefaultProperties(nodeEvaluator);
        return nodeEvaluator;
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.method_51503();
        }
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        class_2338 pos;
        int y;
        if (this.isCanFloat() && this.mob.method_5799()) {
            y = this.mob.method_31478();
            this.tempPos.method_10102(this.mob.method_23317(), (double)y, this.mob.method_23321());
            while (this.context.getBlockState((class_2338)this.tempPos).method_27852(class_2246.field_10382)) {
                this.tempPos.method_10102(this.mob.method_23317(), (double)(++y), this.mob.method_23321());
            }
        } else {
            y = class_3532.method_15357((double)(this.mob.method_23318() + 0.5));
        }
        if (!this.canStartAt(pos = class_2338.method_49637((double)this.mob.method_23317(), (double)y, (double)this.mob.method_23321()))) {
            for (class_2338 alt : this.iteratePathfindingStartNodeCandidatePositions((class_1308)this.mob)) {
                if (!this.canStartAt(alt)) continue;
                return super.getStartNode(alt);
            }
        }
        return super.getStartNode(pos);
    }

    @Override
    protected TravelersPathType getPathType(int x, int y, int z) {
        long key = class_2338.method_10064((int)x, (int)y, (int)z);
        TravelersPathType cached = (TravelersPathType)((Object)this.pathTypeByPosCache.get(key));
        if (cached != null) {
            return cached;
        }
        TravelersPathType computed = this.getPathTypeOfMob(this.context, x, y, z, this.mob);
        this.pathTypeByPosCache.put(key, (Object)computed);
        return computed;
    }

    @Override
    protected boolean canStartAt(class_2338 pos) {
        TravelersPathType type = this.getPathType(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return this.mob.getPathfindingMalus(type) >= 0.0f;
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] out, TravelersNode node) {
        int i = 0;
        TravelersNode n = this.findAcceptedNode(node.x, node.y, node.z + 1);
        TravelersNode s = this.findAcceptedNode(node.x, node.y, node.z - 1);
        TravelersNode e = this.findAcceptedNode(node.x + 1, node.y, node.z);
        TravelersNode w = this.findAcceptedNode(node.x - 1, node.y, node.z);
        TravelersNode u = this.findAcceptedNode(node.x, node.y + 1, node.z);
        TravelersNode d = this.findAcceptedNode(node.x, node.y - 1, node.z);
        if (this.isOpen(n)) {
            out[i++] = n;
        }
        if (this.isOpen(s)) {
            out[i++] = s;
        }
        if (this.isOpen(e)) {
            out[i++] = e;
        }
        if (this.isOpen(w)) {
            out[i++] = w;
        }
        if (this.isOpen(u)) {
            out[i++] = u;
        }
        if (this.isOpen(d)) {
            out[i++] = d;
        }
        BiPredicate<TravelersNode, TravelersNode> canPair = (a, b) -> this.isOpen((TravelersNode)a) && this.isOpen((TravelersNode)b);
        i = this.tryAddDiagonal(out, i, node, n, u, node.x, node.y + 1, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, u, node.x, node.y + 1, node.z - 1, canPair);
        i = this.tryAddDiagonal(out, i, node, e, u, node.x + 1, node.y + 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, w, u, node.x - 1, node.y + 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, n, d, node.x, node.y - 1, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, d, node.x, node.y - 1, node.z - 1, canPair);
        i = this.tryAddDiagonal(out, i, node, e, d, node.x + 1, node.y - 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, w, d, node.x - 1, node.y - 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, n, e, node.x + 1, node.y, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, n, w, node.x - 1, node.y, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, e, node.x + 1, node.y, node.z - 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, w, node.x - 1, node.y, node.z - 1, canPair);
        return i;
    }

    private int tryAddDiagonal(TravelersNode[] out, int i, TravelersNode base, TravelersNode a, TravelersNode b, int x, int y, int z, BiPredicate<TravelersNode, TravelersNode> canPair) {
        TravelersNode diag = this.findAcceptedNode(x, y, z);
        if (this.isOpen(diag) && canPair.test(a, b) && this.canReach(base, diag)) {
            out[i++] = diag;
        }
        return i;
    }

    private boolean canReach(TravelersNode from, TravelersNode to) {
        class_243 f = new class_243((double)from.x + 0.5, (double)from.y + 0.5, (double)from.z + 0.5);
        class_243 t = new class_243((double)to.x + 0.5, (double)to.y + 0.5, (double)to.z + 0.5);
        class_3959 clip = new class_3959(f, t, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mob);
        return this.context.level().method_17742(clip).method_17783() == class_239.class_240.field_1333;
    }

    private boolean isOpen(@Nullable TravelersNode node) {
        return node != null && !node.closed;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(int x, int y, int z) {
        TravelersPathType type = this.getPathType(x, y, z);
        float malus = this.mob.getPathfindingMalus(type);
        if (malus < 0.0f) {
            return null;
        }
        TravelersNode node = this.getNode(x, y, z);
        node.type = type;
        node.costMalus = Math.max(node.costMalus, malus);
        if (type == TravelersPathType.WALKABLE) {
            node.costMalus += 1.0f;
        }
        return this.isSpaceValidForStanding(x, y, z) ? node : null;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        TravelersPathType t = context.getPathTypeFromState(x, y, z);
        if (t == TravelersPathType.OPEN && y >= context.level().method_31607() + 1) {
            TravelersPathType below = context.getPathTypeFromState(x, y - 1, z);
            switch (below) {
                case DAMAGE_FIRE: 
                case LAVA: {
                    t = TravelersPathType.DAMAGE_FIRE;
                    break;
                }
                case DAMAGE_OTHER: {
                    t = TravelersPathType.DAMAGE_OTHER;
                    break;
                }
                case FENCE: {
                    t = TravelersPathType.FENCE;
                    break;
                }
                default: {
                    if (below == TravelersPathType.WALKABLE || below == TravelersPathType.OPEN || below == TravelersPathType.WATER) break;
                    t = TravelersPathType.WALKABLE;
                }
            }
        }
        if (t == TravelersPathType.WALKABLE || t == TravelersPathType.OPEN) {
            t = TravelersFlyNodeEvaluator.checkNeighbourBlocks(context, x, y, z, t);
        }
        return t;
    }

    private Iterable<class_2338> iteratePathfindingStartNodeCandidatePositions(class_1308 mob) {
        class_238 box = mob.method_5829();
        if (box.method_995() >= 1.0) {
            return List.of(class_2338.method_49637((double)box.field_1323, (double)mob.method_31478(), (double)box.field_1321), class_2338.method_49637((double)box.field_1323, (double)mob.method_31478(), (double)box.field_1324), class_2338.method_49637((double)box.field_1320, (double)mob.method_31478(), (double)box.field_1321), class_2338.method_49637((double)box.field_1320, (double)mob.method_31478(), (double)box.field_1324));
        }
        double inflateX = Math.max(0.0, (double)1.1f - box.method_17939());
        double inflateY = Math.max(0.0, (double)1.1f - box.method_17940());
        double inflateZ = Math.max(0.0, (double)1.1f - box.method_17941());
        class_238 expanded = box.method_1009(inflateX, inflateY, inflateZ);
        return class_2338.method_27156((class_5819)mob.method_59922(), (int)10, (int)class_3532.method_15357((double)expanded.field_1323), (int)class_3532.method_15357((double)expanded.field_1322), (int)class_3532.method_15357((double)expanded.field_1321), (int)class_3532.method_15357((double)expanded.field_1320), (int)class_3532.method_15357((double)expanded.field_1325), (int)class_3532.method_15357((double)expanded.field_1324));
    }
}

