/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem;

import com.google.common.base.Supplier;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;

public class ThreadLocalPool<T> {
    private final ThreadLocal<Deque<T>> pool = ThreadLocal.withInitial(ArrayDeque::new);
    private final Supplier<T> factory;
    private final Consumer<T> resetter;

    public ThreadLocalPool(Supplier<T> factory, Consumer<T> resetter) {
        this.factory = factory;
        this.resetter = resetter;
    }

    public ThreadLocalPool(Supplier<T> factory) {
        this(factory, null);
    }

    public T get() {
        Object obj;
        Deque<T> deque = this.pool.get();
        Object object = obj = deque.isEmpty() ? this.factory.get() : deque.pop();
        if (this.resetter != null) {
            this.resetter.accept(obj);
        }
        return obj;
    }

    public void release(T obj) {
        this.pool.get().push(obj);
    }

    public void clear() {
        this.pool.get().clear();
    }
}

