/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersDebug;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.packet.obj.TravelersPathFindingDebug;
import travelers.util.helper.TravelersPacketDistributor;

public abstract class TravelersPathNavigation {
    protected final SmartAnimalBase mob;
    protected final class_1937 level;
    private final TravelersPathFinder pathFinder;
    @Nullable
    protected TravelersPath path;
    protected boolean isLookingForPath;
    protected int tick;
    protected int lastStuckCheck;
    protected class_243 lastStuckCheckPos = class_243.field_1353;
    protected class_2382 timeoutCachedNode = class_2382.field_11176;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 1.0f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected TravelersNodeEvaluator nodeEvaluator;
    private final double reachRange;
    private float maxVisitedNodesMultiplier = 1.0f;
    private boolean isStuck;
    private static final ExecutorService PATH_EXECUTOR = new ThreadPoolExecutor(2, Math.max(2, Runtime.getRuntime().availableProcessors() / 2), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new ThreadPoolExecutor.DiscardOldestPolicy());

    public TravelersPathNavigation(SmartAnimalBase mob, class_1937 level) {
        this.mob = mob;
        this.level = level;
        this.reachRange = mob.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getFollowRange();
        this.pathFinder = this.createPathFinder();
    }

    protected abstract TravelersPathFinder createPathFinder();

    public void recomputePath() {
        this.recomputePath(false);
    }

    public void recomputePath(boolean force) {
        long now = this.level.method_8510();
        if (now - this.timeLastRecompute <= 20L && !force) {
            this.hasDelayedRecomputation = true;
            return;
        }
        TravelersPath current = this.path;
        if (current == null || current.getTarget() == null) {
            return;
        }
        class_243 mobPos = this.getTempMobPos();
        class_243 targetPos = class_243.method_24953((class_2382)current.getTarget());
        if (!force && mobPos.method_1025(targetPos) < 9.0) {
            return;
        }
        CompletableFuture<TravelersPath> newPath = this.createPath(current.getTarget(), this.reachRange);
        if (newPath != null) {
            newPath.thenAcceptAsync(this::moveTo, this::runOnMainThread);
            this.timeLastRecompute = now;
            this.hasDelayedRecomputation = false;
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    private void runOnMainThread(Runnable r) {
        if (this.level.field_9236) {
            r.run();
        } else if (this.level.method_8503() != null) {
            this.level.method_8503().execute(r);
        }
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(double x, double y, double z, int accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)class_2338.method_49637((double)x, (double)y, (double)z)), 8, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Stream<class_2338> targets, int accuracy) {
        return this.createPath(targets.collect(Collectors.toSet()), 8, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Set<class_2338> positions, int distance) {
        return this.createPath(positions, 8, false, (double)distance);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(class_2338 pos, double accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)pos), 8, false, accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(class_2338 pos, int regionOffset, int accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)pos), regionOffset, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(class_1297 entity, int accuracy) {
        return this.createPath((Set<class_2338>)ImmutableSet.of((Object)entity.method_24515()), 16, true, (double)accuracy);
    }

    @Nullable
    protected CompletableFuture<TravelersPath> createPath(Set<class_2338> targets, int regionOffset, boolean offsetUpward, double accuracy) {
        if (this.isLookingForPath || targets.isEmpty() || this.mob.method_23318() < (double)this.level.method_31607() || !this.canUpdatePath()) {
            return null;
        }
        this.isLookingForPath = true;
        float followRange = (float)this.reachRange;
        class_2338 blockpos = offsetUpward ? this.mob.method_24515().method_10084() : this.mob.method_24515();
        int i = (int)(followRange + (float)regionOffset);
        class_1950 pathRegion = new class_1950(this.level, blockpos.method_10069(-i, -i, -i), blockpos.method_10069(i, i, i));
        return CompletableFuture.supplyAsync(() -> this.pathFinder.findPath(pathRegion, this.mob, targets, followRange, (int)accuracy, this.maxVisitedNodesMultiplier), PATH_EXECUTOR).thenApplyAsync(path1 -> {
            this.isLookingForPath = false;
            return path1;
        }, this::runOnMainThread);
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z) {
        CompletableFuture<TravelersPath> path = this.createPath(x, y, z, 1);
        if (path != null) {
            path.thenAcceptAsync(this::moveTo, this::runOnMainThread);
        }
        return path;
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z, int accuracy) {
        CompletableFuture<TravelersPath> path = this.createPath(x, y, z, accuracy);
        if (path != null) {
            path.thenAcceptAsync(this::moveTo, this::runOnMainThread);
        }
        return path;
    }

    public CompletableFuture<TravelersPath> moveTo(class_1297 entity) {
        CompletableFuture<TravelersPath> path = this.createPath(entity, 1);
        if (path != null) {
            path.thenAcceptAsync(this::moveTo, this::runOnMainThread);
        }
        return path;
    }

    public void moveTo(@Nullable TravelersPath pathentity) {
        if (pathentity == null) {
            this.path = null;
        } else {
            if (!pathentity.sameAs(this.path)) {
                this.path = pathentity;
            }
            if (this.isInProgress()) {
                this.trimPath();
                if (this.path != null && this.path.getNodeCount() > 0) {
                    class_243 vec3 = this.getTempMobPos();
                    this.lastStuckCheck = this.tick;
                    this.lastStuckCheckPos = vec3;
                }
            }
        }
    }

    protected void trimPath() {
        if (this.path == null) {
            return;
        }
        for (int i = 0; i < this.path.getNodeCount(); ++i) {
            TravelersNode node = this.path.getNode(i);
            TravelersNode node1 = i + 1 < this.path.getNodeCount() ? this.path.getNode(i + 1) : null;
            class_2680 blockstate = this.level.method_8320(new class_2338(node.x, node.y, node.z));
            if (!blockstate.method_26164(class_3481.field_26985)) continue;
            this.path.replaceNode(i, node.cloneAndMove(node.x, node.y + 1, node.z));
            if (node1 == null || node.y < node1.y) continue;
            this.path.replaceNode(i + 1, node.cloneAndMove(node1.x, node.y + 1, node1.z));
        }
    }

    @Nullable
    public TravelersPath getPath() {
        return this.path;
    }

    public void tick() {
        ++this.tick;
        if (this.isLookingForPath) {
            return;
        }
        if (this.hasDelayedRecomputation && this.tick % 20 == 0) {
            this.recomputePath();
        }
        if (!this.isInProgress()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            class_243 mobPos = this.getTempMobPos();
            class_243 next = this.path.getNextEntityPos((class_1297)this.mob);
            if (next.method_1025(mobPos) <= (double)this.maxDistanceToWaypoint) {
                this.path.advance();
            }
        }
        if (this.isInProgress() && this.path != null) {
            class_243 nextPos = this.path.getNextEntityPos((class_1297)this.mob);
            this.mob.getMoveController().setWantedPosition(nextPos.field_1352, this.getGroundY(nextPos), nextPos.field_1350, 1.0);
        }
        if (this.tick % 40 == 0) {
            this.doStuckDetection(this.getTempMobPos());
        }
        if (TravelersMain.isDebugging() && this.tick % 10 == 0) {
            this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
        }
    }

    void sendPathFinding(class_1937 level, SmartAnimalBase mob, TravelersPath path, float maxDistanceToWaypoint) {
        if (!TravelersMain.isDebugging() || path == null || level.field_9236) {
            return;
        }
        if (TravelersDebug.ENABLED_DEBUGS.contains(mob.getAnimal().getAnimalAttributes().getModId().toLowerCase(Locale.ROOT))) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity(mob, new TravelersPathFindingDebug(mob.method_5628(), path, maxDistanceToWaypoint));
        }
    }

    protected double getGroundY(class_243 vec) {
        class_2338 blockpos = class_2338.method_49638((class_2374)vec);
        return this.level.method_8320(blockpos.method_10074()).method_26215() ? vec.field_1351 : TravelersWalkNodeEvaluator.getFloorLevel((class_1922)this.level, blockpos);
    }

    protected void followThePath() {
        throw new UnsupportedOperationException("This method requires an override");
    }

    protected void doStuckDetection(class_243 pos) {
        if (this.tick - this.lastStuckCheck > 100) {
            float s = this.mob.method_6029();
            float f = s >= 1.0f ? s : s * s;
            float f1 = f * 25.0f;
            this.isStuck = pos.method_1025(this.lastStuckCheckPos) < (double)(f1 * f1);
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = pos;
        }
        if (this.path == null || this.path.isDone()) {
            return;
        }
        class_2338 nodePos = this.path.getNextNodePos();
        long time = this.level.method_8510();
        if (nodePos.equals((Object)this.timeoutCachedNode)) {
            this.timeoutTimer += time - this.lastTimeoutCheck;
        } else {
            this.timeoutCachedNode = nodePos;
            double d0 = pos.method_1022(class_243.method_24955((class_2382)nodePos));
            double d = this.timeoutLimit = this.mob.method_6029() > 0.0f ? d0 / (double)this.mob.method_6029() * 20.0 : 0.0;
        }
        if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
            this.timeoutPath();
        }
        this.lastTimeoutCheck = time;
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = class_2382.field_11176;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return (this.path == null || this.path.isDone()) && !this.isLookingForPath;
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public void stop() {
        this.nodeEvaluator.done();
        this.path = null;
        this.isLookingForPath = false;
    }

    protected abstract class_243 getTempMobPos();

    protected abstract boolean canUpdatePath();

    public boolean isStableDestination(class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        return this.level.method_8320(blockpos).method_26216((class_1922)this.level, blockpos);
    }

    public void setCanFloat(boolean canSwim) {
        this.nodeEvaluator.setCanFloat(canSwim);
    }

    public boolean canFloat() {
        return this.nodeEvaluator.isCanFloat();
    }

    public CompletableFuture<Boolean> shouldRecomputePathAsync(class_2338 pos) {
        return CompletableFuture.supplyAsync(() -> this.shouldRecomputePath(pos), PATH_EXECUTOR);
    }

    public boolean shouldRecomputePath(class_2338 pos) {
        if (this.hasDelayedRecomputation) {
            return false;
        }
        if (this.path != null && !this.path.isDone() && this.path.getNodeCount() > 0) {
            class_238 blockBox = new class_238(pos);
            for (int i = this.path.getNextNodeIndex(); i < this.path.getNodeCount(); ++i) {
                class_238 movedBox;
                TravelersNode node = this.path.getNode(i);
                if (node == null || !(movedBox = this.mob.method_5829().method_989((double)(node.x - class_3532.method_15357((double)this.mob.method_23317())), (double)(node.y - class_3532.method_15357((double)this.mob.method_23318())), (double)(node.z - class_3532.method_15357((double)this.mob.method_23321())))).method_994(blockBox)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLookingForPath() {
        return this.isLookingForPath;
    }

    public void setLookingForPath(boolean isLookingForPath) {
        this.isLookingForPath = isLookingForPath;
    }

    public TravelersNodeEvaluator getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public void setMaxVisitedNodesMultiplier(float maxVisitedNodesMultiplier) {
        this.maxVisitedNodesMultiplier = maxVisitedNodesMultiplier;
    }

    public boolean isStuck() {
        return this.isStuck;
    }
}

