/*
 * Decompiled with CFR 0.152.
 */
package travelers;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;
import travelers.TravelersConstants;
import travelers.server.animal.TravelersAnimal;
import travelers.server.animal.TravelersAnimalRegistry;
import travelers.server.packet.TravelersPackets;
import travelers.util.helper.PlatformHelper;
import travelers.util.helper.obj.TravelerRegistryObject;

@EventBusSubscriber(modid="travelerslib", bus=EventBusSubscriber.Bus.MOD)
public class NeoTravelersEvents {
    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void registerAttributes(EntityAttributeCreationEvent e) {
        for (Set<TravelersAnimal<?>> value : TravelersAnimalRegistry.getANIMALS().values()) {
            for (TravelersAnimal<?> animal : value) {
                e.put((EntityType)animal.getEntityType().get(), animal.createAnimalAttributes().build());
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    private static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(PlatformHelper.registryMap::clear);
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void registerPayloadHandlersEvent(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        for (TravelersPackets.TravelerPacket travelerPacket : TravelersPackets.PACKET_HOLDER) {
            registrar.commonBidirectional(travelerPacket.type(), travelerPacket.reader(), (IPayloadHandler)new DirectionalPayloadHandler((packetPayload, iPayloadContext) -> travelerPacket.packetsHandler().clientPacket(packetPayload), (packetPayload, iPayloadContext) -> travelerPacket.packetsHandler().serverPacket(packetPayload)));
        }
    }

    @SubscribeEvent
    private static void onRegister(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        ArrayList snapshot = new ArrayList(PlatformHelper.registryMap);
        for (TravelerRegistryObject<?> obj : snapshot) {
            ResourceKey objKey = obj.registry().key();
            if (!objKey.equals(key)) continue;
            try {
                if (key.equals(Registries.ITEM)) {
                    PlatformHelper.registryMap.stream().filter(o -> o.registry().key().equals(Registries.BLOCK)).forEach(o -> o.supplier().get());
                }
                event.register(objKey, obj.location(), obj.supplier());
            }
            catch (Throwable t) {
                TravelersConstants.LOGGER.error("Error registering {}", (Object)obj.location(), (Object)t);
            }
        }
    }
}

