/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class TravelersClientAnimator {
    protected final Map<String, TravelersAnimationData> boneOffsetCache = new Object2ObjectOpenHashMap();
    private final Map<String, TravelersBoneState> frameBoneCache = new Object2ObjectOpenHashMap();
    private final List<TravelersBoneState> tempBoneList = new ArrayList<TravelersBoneState>();

    public final void update(SmartAnimalBase animatable, float partialTick) {
        TravelersAnimationData animData = this.boneOffsetCache.computeIfAbsent(animatable.getStringUUID(), id -> this.createData());
        this.updateModel(animatable, partialTick, animData);
    }

    public void beginFrame() {
        this.frameBoneCache.clear();
    }

    public TravelersBoneState getCachedBoneState(String boneName) {
        return this.frameBoneCache.get(boneName);
    }

    public void cacheBoneState(String boneName, TravelersBoneState state) {
        if (state != null) {
            this.frameBoneCache.put(boneName, state);
        }
    }

    protected TravelersAnimationData createData() {
        return new TravelersAnimationData();
    }

    protected List<TravelersBoneState> getBones(TravelersAnimationData animData, String ... bones) {
        this.tempBoneList.clear();
        for (String bone : bones) {
            this.tempBoneList.add(this.bone(animData, bone));
        }
        return this.tempBoneList;
    }

    protected TravelersBoneState bone(TravelersAnimationData animData, String name) {
        return animData.boneMap.computeIfAbsent(name, string -> new TravelersBoneState());
    }

    public abstract void updateModel(SmartAnimalBase var1, float var2, TravelersAnimationData var3);

    public int maxYawAngle() {
        return 45;
    }

    public int maxPitchAngle() {
        return 45;
    }

    public void faceTarget(SmartAnimalBase animatable, float partialTick, float rotationDivisor, List<TravelersBoneState> boneNames) {
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.getStringUUID(), id -> this.createData());
        float yawAmount = 0.0f;
        float pitchAmount = 0.0f;
        if (data.canFace) {
            float bodyYaw = Mth.lerp((float)partialTick, (float)animatable.yBodyRotO, (float)animatable.yBodyRot);
            float headYaw = Mth.lerp((float)partialTick, (float)animatable.yHeadRotO, (float)animatable.getYHeadRot());
            float pitch = Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot());
            float yawDelta = Mth.wrapDegrees((float)(headYaw - bodyYaw));
            float actualRotationDivisor = rotationDivisor * (float)boneNames.size();
            yawAmount = -(yawDelta * ((float)Math.PI / 180)) / actualRotationDivisor;
            pitchAmount = -(pitch * ((float)Math.PI / 180)) / actualRotationDivisor;
            float maxYaw = (float)this.maxYawAngle() * ((float)Math.PI / 180);
            float maxPitch = (float)this.maxPitchAngle() * ((float)Math.PI / 180);
            yawAmount = Mth.clamp((float)yawAmount, (float)(-maxYaw), (float)maxYaw);
            pitchAmount = Mth.clamp((float)pitchAmount, (float)(-maxPitch), (float)maxPitch);
        }
        float t = 2.4f / (float)Math.max(1, Minecraft.getInstance().getFps());
        t = Math.min(1.0f, t);
        for (TravelersBoneState state : boneNames) {
            if (data.canFace) {
                state.angleYo = state.angleY;
                state.angleY = Mth.lerp((float)t, (float)state.angleY, (float)yawAmount);
                state.angleXo = state.angleX;
                state.angleX = Mth.lerp((float)t, (float)state.angleX, (float)pitchAmount);
                continue;
            }
            state.angleYo = state.angleY;
            state.angleY = Mth.lerp((float)t, (float)state.angleY, (float)0.0f);
            state.angleXo = state.angleX;
            state.angleX = Mth.lerp((float)t, (float)state.angleX, (float)0.0f);
        }
    }

    public void chainWave(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float waveAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.getStringUUID(), id -> this.createData());
        int size = boneNames.size();
        for (int i = 0; i < size; ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            float rotation = this.calculateChainRotation(speed, degree, (float)animatable.tickCount + deltaTime, waveAmount, offset, i);
            state.angleXo = state.angleX;
            state.angleX = rotation;
        }
    }

    public void chainSwing(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.getStringUUID(), id -> this.createData());
        int size = boneNames.size();
        for (int i = 0; i < size; ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            float rotation = this.calculateChainRotation(speed, degree, (float)animatable.tickCount + deltaTime, swingAmount, offset, i);
            state.angleYo = state.angleY;
            state.angleY = rotation;
        }
    }

    public void chainFlap(SmartAnimalBase animatable, List<String> boneNames, float speed, float degree, float rootOffset, float deltaTime, float flapAmount) {
        float offset = this.calculateChainOffset(rootOffset, boneNames);
        TravelersAnimationData data = this.boneOffsetCache.computeIfAbsent(animatable.getStringUUID(), id -> this.createData());
        int size = boneNames.size();
        for (int i = 0; i < size; ++i) {
            String bone = boneNames.get(i);
            TravelersBoneState state = data.boneMap.computeIfAbsent(bone, name -> new TravelersBoneState());
            state.angleZ = this.calculateChainRotation(speed, degree, (float)animatable.tickCount + deltaTime, flapAmount, offset, i);
        }
    }

    private float calculateChainRotation(float animationSpeed, float maxDegree, float animationProgress, float amplitude, float phaseOffset, int segmentIndex) {
        float phase = animationProgress * animationSpeed + phaseOffset * (float)segmentIndex;
        return Mth.cos((float)phase) * amplitude * maxDegree;
    }

    private float calculateChainOffset(double rootOffset, List<String> boneNames) {
        return (float)(rootOffset * Math.PI / (double)(2 * boneNames.size()));
    }

    public void remove(SmartAnimalBase entity) {
        this.boneOffsetCache.remove(entity.getStringUUID());
    }

    public TravelersBoneState updateAnimationOnBone(SmartAnimalBase base, String bone) {
        TravelersAnimationData data = this.boneOffsetCache.get(base.getStringUUID());
        return data != null ? data.boneMap.get(bone) : null;
    }

    public void clientTick(SmartAnimalBase base) {
        this.getData(base).tick(base);
    }

    protected TravelersAnimationData getData(SmartAnimalBase base) {
        return this.boneOffsetCache.computeIfAbsent(base.getStringUUID(), string -> this.createData());
    }
}

