/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import travelers.client.render.animation.entity.TravelersAnimationData;
import travelers.client.render.animation.entity.obj.TravelersBipedLegSolver;
import travelers.client.render.animation.entity.obj.TravelersBoneState;
import travelers.client.render.animation.entity.obj.TravelersQuadrupedLegSolver;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersIKHelper {
    private static void resetArticulation(TravelersBoneState ... bones) {
        float t = 2.4f / (float)Math.max(1, Minecraft.getInstance().getFps());
        t = Math.min(1.0f, t);
        for (TravelersBoneState bone : bones) {
            bone.offsetY = Mth.lerp((float)t, (float)bone.offsetY, (float)0.0f);
            bone.angleX = Mth.lerp((float)t, (float)bone.angleX, (float)0.0f);
            bone.angleY = Mth.lerp((float)t, (float)bone.angleY, (float)0.0f);
            bone.angleZ = Mth.lerp((float)t, (float)bone.angleZ, (float)0.0f);
        }
    }

    public static void articulateBiped(TravelersAnimationData animData, SmartAnimalBase entity, TravelersBipedLegSolver legs, TravelersBoneState body, TravelersBoneState leftThigh, TravelersBoneState leftCalf, TravelersBoneState rightThigh, TravelersBoneState rightCalf, float thighLength, float calfLength, float delta) {
        if (!animData.physicsEnabled) {
            return;
        }
        float sc = TravelersIKHelper.getScale(entity);
        float heightLeft = legs.left.getHeight(delta);
        float heightRight = legs.right.getHeight(delta);
        float avg = (heightLeft + heightRight) / 2.0f;
        float t = 2.4f / (float)Math.max(1, Minecraft.getInstance().getFps());
        t = Math.min(1.0f, t);
        float offset = 5.0f / sc * avg;
        float roll = (heightRight - heightLeft) * 0.05f;
        float tilt = (heightLeft + heightRight) * 0.05f;
        body.angleX = Mth.lerp((float)t, (float)body.angleX, (float)(-tilt));
        body.angleZ = Mth.lerp((float)t, (float)body.angleZ, (float)(-roll));
        body.offsetY = Mth.lerp((float)t, (float)body.offsetY, (float)offset);
        TravelersIKHelper.solveIKLeg(sc, heightLeft, leftThigh, leftCalf, 5.0f, 3.0f);
        TravelersIKHelper.solveIKLeg(sc, heightRight, rightThigh, rightCalf, 5.0f, 3.0f);
    }

    public static void articulateQuadruped(TravelersAnimationData animData, SmartAnimalBase entity, TravelersQuadrupedLegSolver legs, TravelersBoneState body, TravelersBoneState neck, TravelersBoneState backLeftThigh, TravelersBoneState backLeftCalf, TravelersBoneState backRightThigh, TravelersBoneState backRightCalf, TravelersBoneState frontLeftThigh, TravelersBoneState frontLeftCalf, TravelersBoneState frontRightThigh, TravelersBoneState frontRightCalf, float thighLength, float calfLength, float delta) {
        if (!animData.physicsEnabled) {
            return;
        }
        float t = 2.4f / (float)Math.max(1, Minecraft.getInstance().getFps());
        t = Math.min(1.0f, t);
        float sc = TravelersIKHelper.getScale(entity);
        float bl = legs.backLeft.getHeight(delta);
        float br = legs.backRight.getHeight(delta);
        float fl = legs.frontLeft.getHeight(delta);
        float fr = legs.frontRight.getHeight(delta);
        float backAvg = (bl + br) / 2.0f;
        float frontAvg = (fl + fr) / 2.0f;
        float totalAvg = (backAvg + frontAvg) / 2.0f;
        float bodyLength = Math.abs(TravelersIKHelper.avg(legs.backLeft.forward, legs.backRight.forward) - TravelersIKHelper.avg(legs.frontLeft.forward, legs.frontRight.forward));
        float tilt = (float)(Math.atan2(bodyLength * sc, backAvg - frontAvg) - 1.5707963267948966);
        float leftAvg = (bl + fl) / 2.0f;
        float rightAvg = (br + fr) / 2.0f;
        float roll = (rightAvg - leftAvg) * 0.1f;
        body.offsetY = Mth.lerp((float)t, (float)body.offsetY, (float)(3.0f / sc * totalAvg));
        body.angleX = Mth.lerp((float)t, (float)body.angleX, (float)(-tilt * 0.25f));
        body.angleZ = Mth.lerp((float)t, (float)body.angleZ, (float)(-roll));
        neck.angleX = Mth.lerp((float)t, (float)neck.angleX, (float)(tilt * 0.15f));
        neck.angleZ = Mth.lerp((float)t, (float)neck.angleZ, (float)(-roll * 0.25f));
        TravelersIKHelper.solveIKLeg(sc, bl, backLeftThigh, backLeftCalf, thighLength, calfLength);
        TravelersIKHelper.solveIKLeg(sc, br, backRightThigh, backRightCalf, thighLength, calfLength);
        TravelersIKHelper.solveIKLeg(sc, fl, frontLeftThigh, frontLeftCalf, thighLength, calfLength);
        TravelersIKHelper.solveIKLeg(sc, fr, frontRightThigh, frontRightCalf, thighLength, calfLength);
    }

    private static void solveIKLeg(float sc, float footHeight, TravelersBoneState thigh, TravelersBoneState calf, float thighLen, float calfLen) {
        float targetY = footHeight * 16.0f / sc;
        float totalLen = thighLen + calfLen;
        float t = 2.4f / (float)Math.max(1, Minecraft.getInstance().getFps());
        t = Math.min(1.0f, t);
        thigh.offsetY = Mth.lerp((float)t, (float)thigh.offsetY, (float)Math.min(targetY, totalLen));
    }

    private static float avg(float a, float b) {
        return (a + b) / 2.0f;
    }

    private static float getScale(SmartAnimalBase entity) {
        return entity.getScale();
    }

    public static float getKneeAngle(float thigh, float calf, float targetDist) {
        float cosKnee = TravelersIKHelper.clamp((thigh * thigh + calf * calf - targetDist * targetDist) / (2.0f * thigh * calf), -1.0f, 1.0f);
        return (float)Math.acos(cosKnee);
    }

    public static float getHipAngle(float thigh, float calf, float targetDist) {
        float cosHip = TravelersIKHelper.clamp((thigh * thigh + targetDist * targetDist - calf * calf) / (2.0f * thigh * targetDist), -1.0f, 1.0f);
        return (float)Math.acos(cosHip);
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }
}

