/*
 * Decompiled with CFR 0.152.
 */
package travelers.client.render.animation.entity.obj;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersLegSolver {
    public final Leg[] legs;

    public TravelersLegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(SmartAnimalBase entity, float scale) {
        this.update(entity, entity.getYRot(), scale);
    }

    public final void update(SmartAnimalBase entity, float yaw, float scale) {
        double radians = Math.toRadians(yaw);
        double sideX = Math.cos(radians) * (double)scale;
        double sideZ = Math.sin(radians) * (double)scale;
        double forwardX = Math.cos(radians + 1.5707963267948966) * (double)scale;
        double forwardZ = Math.sin(radians + 1.5707963267948966) * (double)scale;
        double posX = entity.position().x;
        double posY = entity.position().y;
        double posZ = entity.position().z;
        for (Leg leg : this.legs) {
            leg.update(entity, posX, posY, posZ, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side, float range) {
            this.forward = forward;
            this.side = side;
            this.range = range;
        }

        public final float getHeight(float delta) {
            return Mth.lerp((float)delta, (float)this.prevHeight, (float)this.height);
        }

        public void update(SmartAnimalBase entity, double baseX, double baseY, double baseZ, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double targetX = baseX + sideX * (double)this.side + forwardX * (double)this.forward;
            double targetZ = baseZ + sideZ * (double)this.side + forwardZ * (double)this.forward;
            double targetY = baseY;
            float settledHeight = this.settle(entity, targetX, targetY, targetZ, this.height, scale);
            this.height = Math.clamp(settledHeight, -this.range * scale, this.range * scale);
        }

        private float settle(SmartAnimalBase entity, double x, double y, double z, float currentHeight, float scale) {
            Level level = entity.level();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.set(x, y, z);
            double localY = y - Math.floor(y);
            float surfaceOffset = this.getSurfaceOffset(entity, level, (BlockPos)pos);
            if ((double)surfaceOffset >= 0.999) {
                pos.setY(pos.getY() - 1);
                surfaceOffset = this.getSurfaceOffset(entity, level, (BlockPos)pos) + (float)localY;
            } else {
                surfaceOffset -= 1.0f - (float)localY;
            }
            if (entity.onGround()) {
                return surfaceOffset;
            }
            return 0.0f;
        }

        private float getSurfaceOffset(SmartAnimalBase entity, Level level, BlockPos pos) {
            BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
            int depth = (int)Math.floor(entity.getBbHeight() / 3.0f);
            if (depth < 1) {
                depth = 1;
            }
            float accumulatedDepth = 0.0f;
            for (int i = 0; i < depth; ++i) {
                BlockPos newPos = mutableBlockPos.below(i);
                BlockState state = level.getBlockState(newPos);
                VoxelShape shape = state.getCollisionShape((BlockGetter)level, newPos);
                if (shape.isEmpty()) {
                    accumulatedDepth += 1.0f;
                    continue;
                }
                accumulatedDepth += (float)(1.0 - shape.max(Direction.Axis.Y));
                break;
            }
            return accumulatedDepth;
        }
    }
}

