/*
 * Decompiled with CFR 0.152.
 */
package travelers.mixin.client.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer;
import net.minecraft.client.renderer.debug.LightSectionDebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingRenderer;
import net.minecraft.client.renderer.debug.StructureRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import travelers.TravelersDebug;
import travelers.TravelersMain;
import travelers.client.debug.TravelersPathfindingRenderer;
import travelers.util.TravelersDebugAdditions;

@Mixin(value={DebugRenderer.class})
public class DebugRendererMixin
implements TravelersDebugAdditions {
    @Unique
    public TravelersPathfindingRenderer travelersLib$pathFinder = new TravelersPathfindingRenderer();
    @Shadow
    @Final
    public PathfindingRenderer pathfindingRenderer;
    @Shadow
    @Final
    public GoalSelectorDebugRenderer goalSelectorRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer waterDebugRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer chunkBorderRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer heightMapRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer collisionBoxRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer neighborsUpdateRenderer;
    @Shadow
    @Final
    public StructureRenderer structureRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer lightDebugRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer worldGenAttemptRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer solidFaceRenderer;
    @Shadow
    @Final
    public DebugRenderer.SimpleDebugRenderer chunkRenderer;
    @Shadow
    @Final
    public LightSectionDebugRenderer skyLightSectionDebugRenderer;

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ, CallbackInfo ci) {
        if (!TravelersMain.isDebugging()) {
            return;
        }
        if (TravelersDebug.debugPath) {
            if (!TravelersDebug.debugVanillaAnimals) {
                this.pathfindingRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
            }
            this.travelersLib$pathFinder.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugGoal) {
            this.goalSelectorRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugWater) {
            this.waterDebugRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugChunkBorder) {
            this.chunkBorderRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugHeightMap) {
            this.heightMapRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugCollisionBox) {
            this.collisionBoxRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugNeighbors) {
            this.neighborsUpdateRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugStructures) {
            this.structureRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugLight) {
            this.lightDebugRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugWorldGenAttempt) {
            this.worldGenAttemptRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugSolidFace) {
            this.solidFaceRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugChunkRender) {
            this.chunkRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
        if (TravelersDebug.debugSkyLight) {
            this.skyLightSectionDebugRenderer.render(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
    }

    @Override
    public TravelersPathfindingRenderer travelers$DebugAdditions() {
        return this.travelersLib$pathFinder;
    }
}

