/*
 * Decompiled with CFR 0.152.
 */
package travelers.mixin.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import travelers.TravelersDebug;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TravelerTaskBase;

@Mixin(value={DebugPackets.class})
public abstract class DebugPacketMixin {
    @Shadow
    private static void sendPacketToAllPlayers(ServerLevel level, CustomPacketPayload payload) {
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"sendPathFindingPacket"})
    private static void sendPathFindingPacket(Level level, Mob mob, Path path, float maxDistanceToWaypoint, CallbackInfo ci) {
        if (TravelersDebug.debugPath && TravelersMain.isDebugging()) {
            ci.cancel();
            if (path == null || !(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel slevel = (ServerLevel)level;
            if (TravelersDebug.debugVanillaAnimals && !(mob instanceof SmartAnimalBase)) {
                return;
            }
            if (slevel.getGameRules().getBoolean(GameRules.RULE_REDUCEDDEBUGINFO)) {
                return;
            }
            DebugPacketMixin.jurassic_Saga_Mod$sendToAllWatching(slevel, (CustomPacketPayload)new PathfindingDebugPayload(mob.getId(), path, maxDistanceToWaypoint), (Entity)mob);
        }
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"sendGoalSelector"})
    private static void sendGoalSelector(Level level, Mob mob, GoalSelector goalSelector, CallbackInfo ci) {
        block10: {
            ServerLevel serverLevel;
            block12: {
                block11: {
                    if (!TravelersDebug.debugGoal || !TravelersMain.isDebugging()) break block10;
                    ci.cancel();
                    if (!(level instanceof ServerLevel)) break block11;
                    serverLevel = (ServerLevel)level;
                    if (mob != null && goalSelector != null) break block12;
                }
                return;
            }
            if (TravelersDebug.debugVanillaAnimals && !(mob instanceof SmartAnimalBase)) {
                return;
            }
            ArrayList<GoalDebugPayload.DebugGoal> debugGoals = new ArrayList<GoalDebugPayload.DebugGoal>();
            if (mob instanceof SmartAnimalBase) {
                SmartAnimalBase animal = (SmartAnimalBase)mob;
                ArrayList<TravelerTaskBase> goals = new ArrayList<TravelerTaskBase>();
                goals.addAll((Collection<TravelerTaskBase>)animal.getTaskController().getPossibleTasks());
                goals.addAll((Collection<TravelerTaskBase>)animal.getTaskController().getPossibleTasksNoOccupations());
                for (TravelerTaskBase goal : goals) {
                    StringBuilder name = new StringBuilder(goal.getClass().getSimpleName());
                    if (!goal.getGoals().isEmpty()) {
                        name.append(" [");
                        StringJoiner joiner = new StringJoiner(",");
                        for (TaskGoal tk : goal.getGoals()) {
                            String goalName = tk.name();
                            joiner.add(goalName.length() >= 3 ? goalName.substring(0, 3) : goalName);
                        }
                        name.append(joiner);
                        name.append("]");
                    }
                    debugGoals.add(new GoalDebugPayload.DebugGoal(goal.getPriority().ordinal(), goal.isRunning(), name.toString()));
                }
            } else {
                for (WrappedGoal availableGoal : goalSelector.getAvailableGoals()) {
                    debugGoals.add(new GoalDebugPayload.DebugGoal(availableGoal.getPriority(), availableGoal.isRunning(), availableGoal.getGoal().getClass().getSimpleName()));
                }
            }
            debugGoals.sort(Comparator.comparingInt(GoalDebugPayload.DebugGoal::priority));
            DebugPacketMixin.jurassic_Saga_Mod$sendToAllWatching(serverLevel, (CustomPacketPayload)new GoalDebugPayload(mob.getId(), mob.blockPosition(), (List)debugGoals.reversed()), (Entity)mob);
        }
    }

    @Unique
    private static void jurassic_Saga_Mod$sendToAllWatching(ServerLevel world, CustomPacketPayload payload, Entity watch) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(payload);
        world.getLevel().getChunkSource().broadcast(watch, (Packet)packet);
    }
}

