/*
 * Decompiled with CFR 0.152.
 */
package travelers.mixin.world;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.entity.PartEntity;
import travelers.util.ServerLevelExtension;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin
implements ServerLevelExtension {
    @Shadow
    @Final
    Set<Mob> navigatingMobs;

    @Override
    public void travelers$addToList(PartEntity<?> partEntity) {
    }

    @Override
    public void travelers$removeFromList(PartEntity<?> partEntity) {
    }

    @Inject(method={"sendBlockUpdated"}, at={@At(value="FIELD", target="Lnet/minecraft/server/level/ServerLevel;isUpdatingNavigations:Z", opcode=181)})
    private void injectCustomPathfinding(BlockPos pos, BlockState oldState, BlockState newState, int flags, CallbackInfo ci) {
        for (Mob navigatingMob : this.navigatingMobs) {
            SmartAnimalBase base;
            TravelersPathNavigation nav;
            if (!(navigatingMob instanceof SmartAnimalBase) || (nav = (base = (SmartAnimalBase)navigatingMob).getNavigationController()) == null) continue;
            nav.shouldRecomputePathAsync(pos).thenAccept(b -> {
                if (b.booleanValue()) {
                    nav.getNodeEvaluator().markDirty(pos);
                    TravelersMain.getCache(navigatingMob.level()).invalidate(pos);
                    nav.recomputePath(true);
                }
            });
        }
    }
}

