/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.other;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import travelers.server.animal.entity.SmartAnimalBase;

public class TravelersBodyRotationControl
extends BodyRotationControl {
    private final SmartAnimalBase mob;
    private int headStableTime;
    private float rotationSpeed = -1.0f;

    public TravelersBodyRotationControl(SmartAnimalBase mob) {
        super((Mob)mob);
        this.mob = mob;
    }

    public void clientTick() {
        if (this.mob.isSleeping()) {
            return;
        }
        if (this.isMoving()) {
            this.mob.yBodyRot = this.lerpRotation(this.mob.yBodyRot, this.mob.getYRot(), this.getTurnSpeed());
            this.rotateHeadIfNecessary();
            this.headStableTime = 0;
        } else {
            ++this.headStableTime;
            if (this.headStableTime > 10) {
                this.rotateHeadTowardsFrontSmooth();
            }
        }
    }

    protected float getTurnSpeed() {
        if (this.mob.getAnimal() == null) {
            return 1.0f;
        }
        float TURN = (float)this.mob.getAnimal().getAnimalAttributes().getEntityBaseProperties().getTurnSmoothRate();
        double progressPercentage = this.mob.getScale();
        if (progressPercentage < 1.0) {
            TURN *= (float)Mth.lerp((double)progressPercentage, (double)2.0, (double)1.0);
        }
        this.rotationSpeed = TURN / 10.0f;
        return this.rotationSpeed;
    }

    private void rotateHeadIfNecessary() {
        float targetAngle = this.mob.yBodyRot;
        float maxRotation = this.mob.getMaxHeadYRot();
        this.mob.yHeadRot = this.smoothRotate(this.mob.yHeadRot, targetAngle, maxRotation, this.getTurnSpeed());
    }

    private void rotateHeadTowardsFrontSmooth() {
        int i = this.headStableTime - 10;
        float progress = Mth.clamp((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
        float maxRotation = (float)this.mob.getMaxHeadYRot() * (1.0f - progress);
        this.mob.yBodyRot = this.smoothRotate(this.mob.yBodyRot, this.mob.yHeadRot, maxRotation, this.getTurnSpeed());
    }

    private boolean isMoving() {
        double dz;
        double dx = this.mob.getX() - this.mob.xo;
        return dx * dx + (dz = this.mob.getZ() - this.mob.zo) * dz > (double)2.5E-7f;
    }

    private float lerpRotation(float current, float target, float speed) {
        float diff = this.wrapDegrees(target - current);
        return current + diff * speed;
    }

    private float smoothRotate(float current, float target, float maxRotation, float speed) {
        float diff = this.wrapDegrees(target - current);
        diff = Mth.clamp((float)diff, (float)(-maxRotation), (float)maxRotation);
        return this.lerpRotation(current, current + diff, speed);
    }

    private float wrapDegrees(float degrees) {
        if ((degrees %= 360.0f) >= 180.0f) {
            degrees -= 360.0f;
        }
        if (degrees < -180.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }
}

