/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.navigation.TravelersPathNavigation;
import travelers.server.animal.entity.pathingsystem.navigation.obj.TravelersGenericNav;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;

public class TravelersGroundNavigation
extends TravelersPathNavigation {
    private final SmartAnimalBase base;
    private final int recomputeTick = 0;
    private int curNodeIndex = -1;
    private int nodeStuckTime = 0;

    public TravelersGroundNavigation(SmartAnimalBase mob, Level level) {
        super(mob, level);
        this.base = mob;
    }

    @Override
    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInLiquid() || this.mob.isPassenger();
    }

    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), (double)this.getSurfaceY(), this.mob.getZ());
    }

    @Override
    protected void trimPath() {
        super.trimPath();
    }

    @Override
    public CompletableFuture<TravelersPath> createPath(BlockPos pos, double accuracy) {
        LevelChunk levelchunk = this.level.getChunkSource().getChunkNow(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (levelchunk == null) {
            return null;
        }
        if (levelchunk.getBlockState(pos).isAir()) {
            BlockPos blockpos = pos.below();
            while (blockpos.getY() > this.level.getMinBuildHeight() && levelchunk.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.below();
            }
            if (blockpos.getY() > this.level.getMinBuildHeight()) {
                return super.createPath(blockpos.above(), accuracy);
            }
            while (blockpos.getY() < this.level.getMaxBuildHeight() && levelchunk.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.above();
            }
            pos = blockpos;
        }
        if (!levelchunk.getBlockState(pos).isSolid()) {
            return super.createPath(pos, accuracy);
        }
        BlockPos blockpos1 = pos.above();
        while (blockpos1.getY() < this.level.getMaxBuildHeight() && levelchunk.getBlockState(blockpos1).isSolid()) {
            blockpos1 = blockpos1.above();
        }
        return super.createPath(blockpos1, accuracy);
    }

    @Override
    public CompletableFuture<TravelersPath> createPath(Entity entity, int accuracy) {
        return this.createPath(entity.blockPosition(), (double)accuracy);
    }

    private int getSurfaceY() {
        if (this.mob.isInWater() && this.canFloat()) {
            int i = this.mob.getBlockY();
            BlockState blockstate = this.level.getBlockState(BlockPos.containing((double)this.mob.getX(), (double)i, (double)this.mob.getZ()));
            int j = 0;
            while (blockstate.is(Blocks.WATER)) {
                blockstate = this.level.getBlockState(BlockPos.containing((double)this.mob.getX(), (double)(++i), (double)this.mob.getZ()));
                if (++j <= 16) continue;
                return this.mob.getBlockY();
            }
            return i;
        }
        return Mth.floor((double)(this.mob.getY() + 0.5));
    }

    @Override
    public boolean isStableDestination(BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState state = this.level.getBlockState(blockpos);
        if (this.base.isInWater()) {
            if (state.getFluidState().isEmpty()) {
                return state.isSolidRender((BlockGetter)this.level, blockpos);
            }
            return !state.isSolidRender((BlockGetter)this.level, blockpos);
        }
        return state.isSolidRender((BlockGetter)this.level, blockpos);
    }

    @Override
    protected void followThePath() {
        if (this.path == null) {
            return;
        }
        Vec3 temptPos = this.getTempMobPos();
        if (TravelersGenericNav.shouldTargetNextNodeInDirection(this.path, this.base)) {
            this.path.advance();
        }
        this.checkStuckOnNode();
        if (this.path != null && this.getPath().isDone()) {
            this.stop();
        }
    }

    private void checkStuckOnNode() {
        if (this.path == null) {
            return;
        }
        int nodeIndex = this.path.getNextNodeIndex() - 1;
        if (nodeIndex >= 0) {
            if (nodeIndex > this.path.getNodeCount()) {
                return;
            }
            if (this.curNodeIndex == nodeIndex) {
                ++this.nodeStuckTime;
                if (this.nodeStuckTime > 200) {
                    this.stop();
                }
                return;
            }
            this.nodeStuckTime = 0;
            this.curNodeIndex = nodeIndex;
        }
    }

    @Override
    @NotNull
    protected TravelersPathFinder createPathFinder() {
        this.nodeEvaluator = new TravelersWalkNodeEvaluator();
        return new TravelersPathFinder(this.nodeEvaluator);
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.isCanPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.isCanOpenDoors();
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.nodeEvaluator.setCanWalkOverFences(canWalkOverFences);
    }

    public boolean avoidsLight() {
        return ((TravelersWalkNodeEvaluator)this.nodeEvaluator).isTriesToAvoidLight();
    }
}

