/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.navigation;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersDebug;
import travelers.TravelersMain;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.TravelersPath;
import travelers.server.animal.entity.pathingsystem.TravelersPathFinder;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.packet.obj.TravelersPathFindingDebug;
import travelers.util.helper.TravelersPacketDistributor;

public abstract class TravelersPathNavigation {
    protected final SmartAnimalBase mob;
    protected final Level level;
    private final TravelersPathFinder pathFinder;
    @Nullable
    protected TravelersPath path;
    protected boolean isLookingForPath;
    protected int tick;
    protected int lastStuckCheck;
    protected Vec3 lastStuckCheckPos = Vec3.ZERO;
    protected Vec3i timeoutCachedNode = Vec3i.ZERO;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 1.0f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected TravelersNodeEvaluator nodeEvaluator;
    private final double reachRange;
    private float maxVisitedNodesMultiplier = 1.0f;
    private boolean isStuck;
    private static final ExecutorService PATH_EXECUTOR = new ThreadPoolExecutor(2, Math.max(2, Runtime.getRuntime().availableProcessors() / 2), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new ThreadPoolExecutor.DiscardOldestPolicy());

    public TravelersPathNavigation(SmartAnimalBase mob, Level level) {
        this.mob = mob;
        this.level = level;
        this.reachRange = mob.getAnimal().getAnimalAttributes().getEntityAttributeProperties().getFollowRange();
        this.pathFinder = this.createPathFinder();
    }

    protected abstract TravelersPathFinder createPathFinder();

    public void recomputePath() {
        this.recomputePath(false);
    }

    public void recomputePath(boolean force) {
        long now = this.level.getGameTime();
        if (now - this.timeLastRecompute <= 20L && !force) {
            this.hasDelayedRecomputation = true;
            return;
        }
        TravelersPath current = this.path;
        if (current == null || current.getTarget() == null) {
            return;
        }
        Vec3 mobPos = this.getTempMobPos();
        Vec3 targetPos = Vec3.atCenterOf((Vec3i)current.getTarget());
        if (!force && mobPos.distanceToSqr(targetPos) < 9.0) {
            return;
        }
        CompletableFuture<TravelersPath> newPath = this.createPath(current.getTarget(), this.reachRange);
        if (newPath != null) {
            newPath.thenAcceptAsync(this::moveTo, this::runOnMainThread);
            this.timeLastRecompute = now;
            this.hasDelayedRecomputation = false;
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    private void runOnMainThread(Runnable r) {
        if (this.level.isClientSide) {
            r.run();
        } else if (this.level.getServer() != null) {
            this.level.getServer().execute(r);
        }
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(double x, double y, double z, int accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)BlockPos.containing((double)x, (double)y, (double)z)), 8, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Stream<BlockPos> targets, int accuracy) {
        return this.createPath(targets.collect(Collectors.toSet()), 8, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Set<BlockPos> positions, int distance) {
        return this.createPath(positions, 8, false, (double)distance);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(BlockPos pos, double accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(BlockPos pos, int regionOffset, int accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)pos), regionOffset, false, (double)accuracy);
    }

    @Nullable
    public CompletableFuture<TravelersPath> createPath(Entity entity, int accuracy) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)entity.blockPosition()), 16, true, (double)accuracy);
    }

    @Nullable
    protected CompletableFuture<TravelersPath> createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, double accuracy) {
        if (this.isLookingForPath || targets.isEmpty() || this.mob.getY() < (double)this.level.getMinBuildHeight() || !this.canUpdatePath()) {
            return null;
        }
        this.isLookingForPath = true;
        float followRange = (float)this.reachRange;
        BlockPos blockpos = offsetUpward ? this.mob.blockPosition().above() : this.mob.blockPosition();
        int i = (int)(followRange + (float)regionOffset);
        PathNavigationRegion pathRegion = new PathNavigationRegion(this.level, blockpos.offset(-i, -i, -i), blockpos.offset(i, i, i));
        return CompletableFuture.supplyAsync(() -> this.pathFinder.findPath(pathRegion, this.mob, targets, followRange, (int)accuracy, this.maxVisitedNodesMultiplier), PATH_EXECUTOR).thenApplyAsync(path1 -> {
            this.isLookingForPath = false;
            return path1;
        }, this::runOnMainThread);
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z) {
        CompletableFuture<TravelersPath> path = this.createPath(x, y, z, 1);
        if (path != null) {
            path.thenAcceptAsync(this::moveTo, this::runOnMainThread);
        }
        return path;
    }

    public CompletableFuture<TravelersPath> moveTo(double x, double y, double z, int accuracy) {
        CompletableFuture<TravelersPath> path = this.createPath(x, y, z, accuracy);
        if (path != null) {
            path.thenAcceptAsync(this::moveTo, this::runOnMainThread);
        }
        return path;
    }

    public CompletableFuture<TravelersPath> moveTo(Entity entity) {
        CompletableFuture<TravelersPath> path = this.createPath(entity, 1);
        if (path != null) {
            path.thenAcceptAsync(this::moveTo, this::runOnMainThread);
        }
        return path;
    }

    public void moveTo(@Nullable TravelersPath pathentity) {
        if (pathentity == null) {
            this.path = null;
        } else {
            if (!pathentity.sameAs(this.path)) {
                this.path = pathentity;
            }
            if (this.isInProgress()) {
                this.trimPath();
                if (this.path != null && this.path.getNodeCount() > 0) {
                    Vec3 vec3 = this.getTempMobPos();
                    this.lastStuckCheck = this.tick;
                    this.lastStuckCheckPos = vec3;
                }
            }
        }
    }

    protected void trimPath() {
        if (this.path == null) {
            return;
        }
        for (int i = 0; i < this.path.getNodeCount(); ++i) {
            TravelersNode node = this.path.getNode(i);
            TravelersNode node1 = i + 1 < this.path.getNodeCount() ? this.path.getNode(i + 1) : null;
            BlockState blockstate = this.level.getBlockState(new BlockPos(node.x, node.y, node.z));
            if (!blockstate.is(BlockTags.CAULDRONS)) continue;
            this.path.replaceNode(i, node.cloneAndMove(node.x, node.y + 1, node.z));
            if (node1 == null || node.y < node1.y) continue;
            this.path.replaceNode(i + 1, node.cloneAndMove(node1.x, node.y + 1, node1.z));
        }
    }

    @Nullable
    public TravelersPath getPath() {
        return this.path;
    }

    public void tick() {
        ++this.tick;
        if (this.isLookingForPath) {
            return;
        }
        if (this.hasDelayedRecomputation && this.tick % 20 == 0) {
            this.recomputePath();
        }
        if (!this.isInProgress()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            Vec3 mobPos = this.getTempMobPos();
            Vec3 next = this.path.getNextEntityPos((Entity)this.mob);
            if (next.distanceToSqr(mobPos) <= (double)this.maxDistanceToWaypoint) {
                this.path.advance();
            }
        }
        if (this.isInProgress() && this.path != null) {
            Vec3 nextPos = this.path.getNextEntityPos((Entity)this.mob);
            this.mob.getMoveController().setWantedPosition(nextPos.x, this.getGroundY(nextPos), nextPos.z, 1.0);
        }
        if (this.tick % 40 == 0) {
            this.doStuckDetection(this.getTempMobPos());
        }
        if (TravelersMain.isDebugging() && this.tick % 10 == 0) {
            this.sendPathFinding(this.level, this.mob, this.path, this.maxDistanceToWaypoint);
        }
    }

    void sendPathFinding(Level level, SmartAnimalBase mob, TravelersPath path, float maxDistanceToWaypoint) {
        if (!TravelersMain.isDebugging() || path == null || level.isClientSide) {
            return;
        }
        if (TravelersDebug.ENABLED_DEBUGS.contains(mob.getAnimal().getAnimalAttributes().getModId().toLowerCase(Locale.ROOT))) {
            TravelersPacketDistributor.sendToPlayersTrackingEntity(mob, new TravelersPathFindingDebug(mob.getId(), path, maxDistanceToWaypoint));
        }
    }

    protected double getGroundY(Vec3 vec) {
        BlockPos blockpos = BlockPos.containing((Position)vec);
        return this.level.getBlockState(blockpos.below()).isAir() ? vec.y : TravelersWalkNodeEvaluator.getFloorLevel((BlockGetter)this.level, blockpos);
    }

    protected void followThePath() {
        throw new UnsupportedOperationException("This method requires an override");
    }

    protected void doStuckDetection(Vec3 pos) {
        if (this.tick - this.lastStuckCheck > 100) {
            float s = this.mob.getSpeed();
            float f = s >= 1.0f ? s : s * s;
            float f1 = f * 25.0f;
            this.isStuck = pos.distanceToSqr(this.lastStuckCheckPos) < (double)(f1 * f1);
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = pos;
        }
        if (this.path == null || this.path.isDone()) {
            return;
        }
        BlockPos nodePos = this.path.getNextNodePos();
        long time = this.level.getGameTime();
        if (nodePos.equals((Object)this.timeoutCachedNode)) {
            this.timeoutTimer += time - this.lastTimeoutCheck;
        } else {
            this.timeoutCachedNode = nodePos;
            double d0 = pos.distanceTo(Vec3.atBottomCenterOf((Vec3i)nodePos));
            double d = this.timeoutLimit = this.mob.getSpeed() > 0.0f ? d0 / (double)this.mob.getSpeed() * 20.0 : 0.0;
        }
        if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
            this.timeoutPath();
        }
        this.lastTimeoutCheck = time;
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = Vec3i.ZERO;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return (this.path == null || this.path.isDone()) && !this.isLookingForPath;
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public void stop() {
        this.nodeEvaluator.done();
        this.path = null;
        this.isLookingForPath = false;
    }

    protected abstract Vec3 getTempMobPos();

    protected abstract boolean canUpdatePath();

    public boolean isStableDestination(BlockPos pos) {
        BlockPos blockpos = pos.below();
        return this.level.getBlockState(blockpos).isSolidRender((BlockGetter)this.level, blockpos);
    }

    public void setCanFloat(boolean canSwim) {
        this.nodeEvaluator.setCanFloat(canSwim);
    }

    public boolean canFloat() {
        return this.nodeEvaluator.isCanFloat();
    }

    public CompletableFuture<Boolean> shouldRecomputePathAsync(BlockPos pos) {
        return CompletableFuture.supplyAsync(() -> this.shouldRecomputePath(pos), PATH_EXECUTOR);
    }

    public boolean shouldRecomputePath(BlockPos pos) {
        if (this.hasDelayedRecomputation) {
            return false;
        }
        if (this.path != null && !this.path.isDone() && this.path.getNodeCount() > 0) {
            AABB blockBox = new AABB(pos);
            for (int i = this.path.getNextNodeIndex(); i < this.path.getNodeCount(); ++i) {
                AABB movedBox;
                TravelersNode node = this.path.getNode(i);
                if (node == null || !(movedBox = this.mob.getBoundingBox().move((double)(node.x - Mth.floor((double)this.mob.getX())), (double)(node.y - Mth.floor((double)this.mob.getY())), (double)(node.z - Mth.floor((double)this.mob.getZ())))).intersects(blockBox)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLookingForPath() {
        return this.isLookingForPath;
    }

    public void setLookingForPath(boolean isLookingForPath) {
        this.isLookingForPath = isLookingForPath;
    }

    public TravelersNodeEvaluator getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public void setMaxVisitedNodesMultiplier(float maxVisitedNodesMultiplier) {
        this.maxVisitedNodesMultiplier = maxVisitedNodesMultiplier;
    }

    public boolean isStuck() {
        return this.isStuck;
    }
}

