/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.TravelersWalkNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersFlyNodeEvaluator
extends TravelersWalkNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private final BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();

    @Override
    public void prepare(@NotNull PathNavigationRegion level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.pathTypeByPosCache.clear();
        mob.onPathfindingStart();
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersFlyNodeEvaluator nodeEvaluator = new TravelersFlyNodeEvaluator();
        this.applyDefaultProperties(nodeEvaluator);
        return nodeEvaluator;
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.onPathfindingDone();
        }
        this.pathTypeByPosCache.clear();
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        BlockPos pos;
        int y;
        if (this.isCanFloat() && this.mob.isInWater()) {
            y = this.mob.getBlockY();
            this.tempPos.set(this.mob.getX(), (double)y, this.mob.getZ());
            while (this.context.getBlockState((BlockPos)this.tempPos).is(Blocks.WATER)) {
                this.tempPos.set(this.mob.getX(), (double)(++y), this.mob.getZ());
            }
        } else {
            y = Mth.floor((double)(this.mob.getY() + 0.5));
        }
        if (!this.canStartAt(pos = BlockPos.containing((double)this.mob.getX(), (double)y, (double)this.mob.getZ()))) {
            for (BlockPos alt : this.iteratePathfindingStartNodeCandidatePositions((Mob)this.mob)) {
                if (!this.canStartAt(alt)) continue;
                return super.getStartNode(alt);
            }
        }
        return super.getStartNode(pos);
    }

    @Override
    protected TravelersPathType getPathType(int x, int y, int z) {
        long key = BlockPos.asLong((int)x, (int)y, (int)z);
        TravelersPathType cached = (TravelersPathType)((Object)this.pathTypeByPosCache.get(key));
        if (cached != null) {
            return cached;
        }
        TravelersPathType computed = this.getPathTypeOfMob(this.context, x, y, z, this.mob);
        this.pathTypeByPosCache.put(key, (Object)computed);
        return computed;
    }

    @Override
    protected boolean canStartAt(BlockPos pos) {
        TravelersPathType type = this.getPathType(pos.getX(), pos.getY(), pos.getZ());
        return this.mob.getPathfindingMalus(type) >= 0.0f;
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] out, TravelersNode node) {
        int i = 0;
        TravelersNode n = this.findAcceptedNode(node.x, node.y, node.z + 1);
        TravelersNode s = this.findAcceptedNode(node.x, node.y, node.z - 1);
        TravelersNode e = this.findAcceptedNode(node.x + 1, node.y, node.z);
        TravelersNode w = this.findAcceptedNode(node.x - 1, node.y, node.z);
        TravelersNode u = this.findAcceptedNode(node.x, node.y + 1, node.z);
        TravelersNode d = this.findAcceptedNode(node.x, node.y - 1, node.z);
        if (this.isOpen(n)) {
            out[i++] = n;
        }
        if (this.isOpen(s)) {
            out[i++] = s;
        }
        if (this.isOpen(e)) {
            out[i++] = e;
        }
        if (this.isOpen(w)) {
            out[i++] = w;
        }
        if (this.isOpen(u)) {
            out[i++] = u;
        }
        if (this.isOpen(d)) {
            out[i++] = d;
        }
        BiPredicate<TravelersNode, TravelersNode> canPair = (a, b) -> this.isOpen((TravelersNode)a) && this.isOpen((TravelersNode)b);
        i = this.tryAddDiagonal(out, i, node, n, u, node.x, node.y + 1, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, u, node.x, node.y + 1, node.z - 1, canPair);
        i = this.tryAddDiagonal(out, i, node, e, u, node.x + 1, node.y + 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, w, u, node.x - 1, node.y + 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, n, d, node.x, node.y - 1, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, d, node.x, node.y - 1, node.z - 1, canPair);
        i = this.tryAddDiagonal(out, i, node, e, d, node.x + 1, node.y - 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, w, d, node.x - 1, node.y - 1, node.z, canPair);
        i = this.tryAddDiagonal(out, i, node, n, e, node.x + 1, node.y, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, n, w, node.x - 1, node.y, node.z + 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, e, node.x + 1, node.y, node.z - 1, canPair);
        i = this.tryAddDiagonal(out, i, node, s, w, node.x - 1, node.y, node.z - 1, canPair);
        return i;
    }

    private int tryAddDiagonal(TravelersNode[] out, int i, TravelersNode base, TravelersNode a, TravelersNode b, int x, int y, int z, BiPredicate<TravelersNode, TravelersNode> canPair) {
        TravelersNode diag = this.findAcceptedNode(x, y, z);
        if (this.isOpen(diag) && canPair.test(a, b) && this.canReach(base, diag)) {
            out[i++] = diag;
        }
        return i;
    }

    private boolean canReach(TravelersNode from, TravelersNode to) {
        Vec3 f = new Vec3((double)from.x + 0.5, (double)from.y + 0.5, (double)from.z + 0.5);
        Vec3 t = new Vec3((double)to.x + 0.5, (double)to.y + 0.5, (double)to.z + 0.5);
        ClipContext clip = new ClipContext(f, t, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob);
        return this.context.level().clip(clip).getType() == HitResult.Type.MISS;
    }

    private boolean isOpen(@Nullable TravelersNode node) {
        return node != null && !node.closed;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(int x, int y, int z) {
        TravelersPathType type = this.getPathType(x, y, z);
        float malus = this.mob.getPathfindingMalus(type);
        if (malus < 0.0f) {
            return null;
        }
        TravelersNode node = this.getNode(x, y, z);
        node.type = type;
        node.costMalus = Math.max(node.costMalus, malus);
        if (type == TravelersPathType.WALKABLE) {
            node.costMalus += 1.0f;
        }
        return this.isSpaceValidForStanding(x, y, z) ? node : null;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        TravelersPathType t = context.getPathTypeFromState(x, y, z);
        if (t == TravelersPathType.OPEN && y >= context.level().getMinBuildHeight() + 1) {
            TravelersPathType below = context.getPathTypeFromState(x, y - 1, z);
            switch (below) {
                case DAMAGE_FIRE: 
                case LAVA: {
                    t = TravelersPathType.DAMAGE_FIRE;
                    break;
                }
                case DAMAGE_OTHER: {
                    t = TravelersPathType.DAMAGE_OTHER;
                    break;
                }
                case FENCE: {
                    t = TravelersPathType.FENCE;
                    break;
                }
                default: {
                    if (below == TravelersPathType.WALKABLE || below == TravelersPathType.OPEN || below == TravelersPathType.WATER) break;
                    t = TravelersPathType.WALKABLE;
                }
            }
        }
        if (t == TravelersPathType.WALKABLE || t == TravelersPathType.OPEN) {
            t = TravelersFlyNodeEvaluator.checkNeighbourBlocks(context, x, y, z, t);
        }
        return t;
    }

    private Iterable<BlockPos> iteratePathfindingStartNodeCandidatePositions(Mob mob) {
        AABB box = mob.getBoundingBox();
        if (box.getSize() >= 1.0) {
            return List.of(BlockPos.containing((double)box.minX, (double)mob.getBlockY(), (double)box.minZ), BlockPos.containing((double)box.minX, (double)mob.getBlockY(), (double)box.maxZ), BlockPos.containing((double)box.maxX, (double)mob.getBlockY(), (double)box.minZ), BlockPos.containing((double)box.maxX, (double)mob.getBlockY(), (double)box.maxZ));
        }
        double inflateX = Math.max(0.0, (double)1.1f - box.getXsize());
        double inflateY = Math.max(0.0, (double)1.1f - box.getYsize());
        double inflateZ = Math.max(0.0, (double)1.1f - box.getZsize());
        AABB expanded = box.inflate(inflateX, inflateY, inflateZ);
        return BlockPos.randomBetweenClosed((RandomSource)mob.getRandom(), (int)10, (int)Mth.floor((double)expanded.minX), (int)Mth.floor((double)expanded.minY), (int)Mth.floor((double)expanded.minZ), (int)Mth.floor((double)expanded.maxX), (int)Mth.floor((double)expanded.maxY), (int)Mth.floor((double)expanded.maxZ));
    }
}

