/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public abstract class TravelersNodeEvaluator {
    protected final Int2ObjectMap<TravelersNode> nodes = new Int2ObjectOpenHashMap();
    protected TravelersPathfindingContext context;
    protected SmartAnimalBase mob;
    protected int entityWidth;
    protected int entityHeight;
    protected int entityDepth;
    protected boolean canPassDoors;
    protected boolean canOpenDoors;
    protected boolean canFloat;
    protected boolean canWalkOverFences;

    public static boolean isBurningBlock(BlockState state) {
        return state.is(BlockTags.FIRE) || state.is(Blocks.LAVA) || state.is(Blocks.MAGMA_BLOCK) || CampfireBlock.isLitCampfire((BlockState)state) || state.is(Blocks.LAVA_CAULDRON);
    }

    public abstract TravelersNodeEvaluator copy();

    protected void applyDefaultProperties(TravelersNodeEvaluator eval) {
        eval.mob = this.mob;
        eval.canPassDoors = this.canPassDoors;
        eval.canOpenDoors = this.canOpenDoors;
        eval.canFloat = this.canFloat;
        eval.canWalkOverFences = this.canWalkOverFences;
    }

    public void prepare(PathNavigationRegion level, SmartAnimalBase mob) {
        this.context = new TravelersPathfindingContext((CollisionGetter)level, (Mob)mob);
        this.mob = mob;
        this.nodes.clear();
        float width = mob.getBbWidth();
        this.entityWidth = this.entityDepth = Mth.ceil((float)width);
        this.entityHeight = Mth.ceil((float)mob.getBbHeight());
    }

    public void done() {
        this.nodes.clear();
        this.context = null;
        this.mob = null;
    }

    protected TravelersNode getNode(BlockPos pos) {
        return this.getNode(pos.getX(), pos.getY(), pos.getZ());
    }

    protected TravelersNode getNode(int x, int y, int z) {
        return (TravelersNode)this.nodes.computeIfAbsent(TravelersNode.createHash(x, y, z), $ -> new TravelersNode(x, y, z));
    }

    protected TravelersTarget getTargetNodeAt(double x, double y, double z) {
        return new TravelersTarget(this.getNode(Mth.floor((double)x), Mth.floor((double)y), Mth.floor((double)z)));
    }

    public TravelersPathType getPathType(Mob mob, BlockPos pos) {
        return this.getPathType(new TravelersPathfindingContext((CollisionGetter)mob.level(), mob), pos.getX(), pos.getY(), pos.getZ());
    }

    public abstract TravelersNode getStart();

    public abstract TravelersTarget getTarget(double var1, double var3, double var5);

    public abstract int getNeighbors(TravelersNode[] var1, TravelersNode var2);

    public abstract TravelersPathType getPathTypeOfMob(TravelersPathfindingContext var1, int var2, int var3, int var4, SmartAnimalBase var5);

    public abstract TravelersPathType getPathType(TravelersPathfindingContext var1, int var2, int var3, int var4);

    public void markDirty(BlockPos pos) {
    }

    public Int2ObjectMap<TravelersNode> getNodes() {
        return this.nodes;
    }

    public TravelersPathfindingContext getContext() {
        return this.context;
    }

    public SmartAnimalBase getMob() {
        return this.mob;
    }

    public int getEntityWidth() {
        return this.entityWidth;
    }

    public int getEntityHeight() {
        return this.entityHeight;
    }

    public int getEntityDepth() {
        return this.entityDepth;
    }

    public boolean isCanPassDoors() {
        return this.canPassDoors;
    }

    public boolean isCanOpenDoors() {
        return this.canOpenDoors;
    }

    public boolean isCanFloat() {
        return this.canFloat;
    }

    public boolean isCanWalkOverFences() {
        return this.canWalkOverFences;
    }

    public void setContext(TravelersPathfindingContext context) {
        this.context = context;
    }

    public void setMob(SmartAnimalBase mob) {
        this.mob = mob;
    }

    public void setEntityWidth(int entityWidth) {
        this.entityWidth = entityWidth;
    }

    public void setEntityHeight(int entityHeight) {
        this.entityHeight = entityHeight;
    }

    public void setEntityDepth(int entityDepth) {
        this.entityDepth = entityDepth;
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.canPassDoors = canPassDoors;
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.canOpenDoors = canOpenDoors;
    }

    public void setCanFloat(boolean canFloat) {
        this.canFloat = canFloat;
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.canWalkOverFences = canWalkOverFences;
    }
}

