/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersNode;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathfindingContext;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersTarget;

public class TravelersWalkNodeEvaluator
extends TravelersNodeEvaluator {
    private final Long2ObjectMap<TravelersPathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private boolean canCrawl = false;
    private boolean triesToAvoidLight = false;
    private boolean canClimb;
    private boolean canClimbAnyBlock = false;
    private final BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos tempPos2 = new BlockPos.MutableBlockPos();

    private static boolean doesBlockHavePartialCollision(TravelersPathType pathType) {
        return pathType == TravelersPathType.FENCE || pathType == TravelersPathType.DOOR_WOOD_CLOSED || pathType == TravelersPathType.DOOR_IRON_CLOSED;
    }

    public static double getFloorLevel(BlockGetter level, BlockPos pos) {
        BlockPos below = pos.below();
        VoxelShape shape = level.getBlockState(below).getCollisionShape(level, below);
        return (double)below.getY() + (shape.isEmpty() ? 0.0 : shape.max(Direction.Axis.Y));
    }

    public static TravelersPathType getPathTypeStatic(SmartAnimalBase base, BlockPos pos) {
        return TravelersWalkNodeEvaluator.getPathTypeStatic(new TravelersPathfindingContext((CollisionGetter)base.level(), (Mob)base), pos.mutable());
    }

    public static TravelersPathType getPathTypeStatic(TravelersPathfindingContext context, BlockPos.MutableBlockPos pos) {
        int k;
        int j;
        int i = pos.getX();
        TravelersPathType pathtype = context.getPathTypeFromState(i, j = pos.getY(), k = pos.getZ());
        if (pathtype == TravelersPathType.OPEN && j >= context.level().getMinBuildHeight() + 1) {
            TravelersPathType below = context.getPathTypeFromState(i, j - 1, k);
            return switch (below) {
                case TravelersPathType.OPEN, TravelersPathType.WATER, TravelersPathType.WALKABLE, TravelersPathType.LIGHT -> TravelersPathType.OPEN;
                case TravelersPathType.LAVA -> TravelersPathType.LAVA;
                case TravelersPathType.DAMAGE_FIRE -> TravelersPathType.DAMAGE_FIRE;
                case TravelersPathType.DAMAGE_OTHER -> TravelersPathType.DAMAGE_OTHER;
                case TravelersPathType.STICKY_HONEY -> TravelersPathType.STICKY_HONEY;
                case TravelersPathType.POWDER_SNOW -> TravelersPathType.DANGER_POWDER_SNOW;
                case TravelersPathType.DAMAGE_CAUTIOUS -> TravelersPathType.DAMAGE_CAUTIOUS;
                case TravelersPathType.TRAPDOOR -> TravelersPathType.DANGER_TRAPDOOR;
                default -> TravelersWalkNodeEvaluator.checkNeighbourBlocks(context, i, j, k, TravelersPathType.WALKABLE);
            };
        }
        return pathtype;
    }

    public static TravelersPathType checkNeighbourBlocks(TravelersPathfindingContext context, int x, int y, int z, TravelersPathType pathType) {
        BlockPos.MutableBlockPos mp = context.mutablePos;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    TravelersPathType pt = context.getPathTypeFromState(x + i, y + j, z + k);
                    mp.set(x + i, y + j, z + k);
                    if (pt == TravelersPathType.DAMAGE_OTHER) {
                        return TravelersPathType.DANGER_OTHER;
                    }
                    if (pt == TravelersPathType.DAMAGE_FIRE || pt == TravelersPathType.LAVA) {
                        return TravelersPathType.DANGER_FIRE;
                    }
                    if (pt == TravelersPathType.WATER) {
                        return TravelersPathType.WATER_BORDER;
                    }
                    if (pt != TravelersPathType.DAMAGE_CAUTIOUS) continue;
                    return TravelersPathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pathType;
    }

    @Override
    public void markDirty(BlockPos pos) {
        this.pathTypesByPosCacheByMob.remove(pos.asLong());
    }

    @Override
    public TravelersNodeEvaluator copy() {
        TravelersWalkNodeEvaluator nodeEvaluator = new TravelersWalkNodeEvaluator();
        this.applyDefaultProperties(nodeEvaluator);
        nodeEvaluator.canCrawl = this.canCrawl;
        nodeEvaluator.triesToAvoidLight = this.triesToAvoidLight;
        nodeEvaluator.canClimb = this.canClimb;
        nodeEvaluator.canClimbAnyBlock = this.canClimbAnyBlock;
        return nodeEvaluator;
    }

    @Override
    public void prepare(@NotNull PathNavigationRegion level, @NotNull SmartAnimalBase mob) {
        super.prepare(level, mob);
        this.triesToAvoidLight = mob.avoidsLight();
        mob.onPathfindingStart();
    }

    @Override
    public void done() {
        if (this.mob != null) {
            this.mob.onPathfindingDone();
        }
        this.pathTypesByPosCacheByMob.clear();
        super.done();
    }

    @Override
    @NotNull
    public TravelersNode getStart() {
        Vec3 p = this.mob.position();
        BlockPos start = BlockPos.containing((double)p.x, (double)p.y, (double)p.z);
        BlockPos resolved = this.findStandableStartDownOnly(start);
        return this.getStartNode(resolved);
    }

    private BlockPos findStandableStartDownOnly(BlockPos start) {
        int minY = this.mob.level().getMinBuildHeight();
        int startY = start.getY();
        int widthBlocks = Mth.ceil((float)this.mob.getBbWidth());
        int radiusMax = Math.min(8, Math.max(1, widthBlocks));
        int maxDepth = Math.max(1, Mth.floor((float)(this.mob.getBbHeight() / 2.0f)));
        int deepestY = Math.max(startY - maxDepth, minY);
        for (int y = startY; y >= deepestY; --y) {
            this.tempPos.set(start.getX(), y, start.getZ());
            if (this.isSpaceValidForStanding(this.tempPos.getX(), this.tempPos.getY(), this.tempPos.getZ())) {
                return this.tempPos.immutable();
            }
            for (int r = 1; r <= radiusMax; ++r) {
                int x0 = start.getX();
                int z0 = start.getZ();
                for (int dx = -r; dx <= r; ++dx) {
                    this.tempPos.set(x0 + dx, y, z0 - r);
                    if (this.isSpaceValidForStanding(this.tempPos.getX(), this.tempPos.getY(), this.tempPos.getZ())) {
                        return this.tempPos.immutable();
                    }
                    this.tempPos.set(x0 + dx, y, z0 + r);
                    if (!this.isSpaceValidForStanding(this.tempPos.getX(), this.tempPos.getY(), this.tempPos.getZ())) continue;
                    return this.tempPos.immutable();
                }
                for (int dz = -r + 1; dz <= r - 1; ++dz) {
                    this.tempPos.set(x0 - r, y, z0 + dz);
                    if (this.isSpaceValidForStanding(this.tempPos.getX(), this.tempPos.getY(), this.tempPos.getZ())) {
                        return this.tempPos.immutable();
                    }
                    this.tempPos.set(x0 + r, y, z0 + dz);
                    if (!this.isSpaceValidForStanding(this.tempPos.getX(), this.tempPos.getY(), this.tempPos.getZ())) continue;
                    return this.tempPos.immutable();
                }
            }
        }
        return start;
    }

    protected TravelersNode getStartNode(BlockPos pos) {
        TravelersNode node = this.getNode(pos);
        node.type = this.getPathType(node.x, node.y, node.z);
        node.costMalus = this.mob.getPathfindingMalus(node.type);
        return node;
    }

    protected boolean canStartAt(BlockPos pos) {
        TravelersPathType pathtype = this.getPathType(pos.getX(), pos.getY(), pos.getZ());
        return pathtype != TravelersPathType.OPEN && this.mob.getPathfindingMalus(pathtype) >= 0.0f;
    }

    @Override
    @NotNull
    public TravelersTarget getTarget(double x, double y, double z) {
        return this.getTargetNodeAt(x, y, z);
    }

    @Override
    public int getNeighbors(TravelersNode @NotNull [] outputArray, TravelersNode p_node) {
        int i = 0;
        TravelersPathType above = this.getPathType(p_node.x, p_node.y + 1, p_node.z);
        TravelersPathType at = this.getPathType(p_node.x, p_node.y, p_node.z);
        int verticalAllowance = 0;
        if (this.mob.getPathfindingMalus(above) >= 0.0f && at != TravelersPathType.STICKY_HONEY) {
            verticalAllowance = Mth.floor((float)Math.max(1.0f, this.mob.maxUpStep() + 0.1f));
        }
        this.tempPos.set(p_node.x, p_node.y, p_node.z);
        double d0 = this.getFloorLevel((BlockPos)this.tempPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TravelersNode node = this.findAcceptedNode(p_node, p_node.x + direction.getStepX(), p_node.y, p_node.z + direction.getStepZ(), verticalAllowance, d0, direction, at);
            if (!this.isNeighborValid(node, p_node)) continue;
            outputArray[i++] = node;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable TravelersNode neighbor, TravelersNode node) {
        return neighbor != null && !neighbor.closed && (neighbor.costMalus >= 0.0f || node.costMalus < 0.0f);
    }

    private boolean cantMoveBetween(TravelersNode from, TravelersNode to) {
        int steps = Math.max(Math.abs(to.x - from.x), Math.max(Math.abs(to.y - from.y), Math.abs(to.z - from.z)));
        if (steps == 0) {
            return false;
        }
        float dx = (float)(to.x - from.x) / (float)steps;
        float dy = (float)(to.y - from.y) / (float)steps;
        float dz = (float)(to.z - from.z) / (float)steps;
        for (int i = 1; i <= steps; ++i) {
            int checkZ;
            int checkY;
            int checkX = from.x + (dx > 0.0f ? (int)Math.floor(dx * (float)i) : (int)Math.ceil(dx * (float)i));
            if (this.canStandAt(checkX, checkY = from.y + (dy > 0.0f ? (int)Math.floor(dy * (float)i) : (int)Math.ceil(dy * (float)i)), checkZ = from.z + (dz > 0.0f ? (int)Math.floor(dz * (float)i) : (int)Math.ceil(dz * (float)i)))) continue;
            return true;
        }
        return false;
    }

    private boolean canStandAt(int x, int y, int z) {
        for (int dx = 0; dx < this.entityWidth; ++dx) {
            for (int dy = 0; dy < this.entityHeight; ++dy) {
                for (int dz = 0; dz < this.entityDepth; ++dz) {
                    if (!this.isBlockSolid(x + dx, y + dy, z + dz)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isBlockSolid(int x, int y, int z) {
        this.tempPos.set(x, y, z);
        return this.context.level().getBlockState((BlockPos)this.tempPos).isSolidRender((BlockGetter)this.context.level(), (BlockPos)this.tempPos);
    }

    private boolean canReachWithoutCollision(TravelersNode node) {
        AABB aabb = this.mob.getBoundingBox();
        AABB targetBox = new AABB((double)node.x, (double)node.y, (double)node.z, (double)node.x + aabb.getXsize(), (double)node.y + aabb.getYsize(), (double)node.z + aabb.getZsize());
        return !this.hasCollisions(targetBox);
    }

    protected double getFloorLevel(BlockPos pos) {
        CollisionGetter blockgetter = this.context.level();
        return (this.isCanFloat() || this.isAmphibious() || this.mob.onGround()) && blockgetter.getFluidState(pos).is(FluidTags.WATER) ? (double)pos.getY() : TravelersWalkNodeEvaluator.getFloorLevel((BlockGetter)blockgetter, pos);
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected TravelersNode findAcceptedNode(TravelersNode p_node, int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, TravelersPathType pathTypeAtCurrent) {
        int blockLight;
        BlockPos pos;
        Level level;
        int skyLight;
        int totalLight;
        int darkness;
        Level i2;
        TravelersNode node = null;
        this.tempPos.set(x, y, z);
        TravelersPathType pathtype = this.getPathType(x, y, z);
        nodeFloorLevel = Math.floor(nodeFloorLevel);
        double diff = (double)y - nodeFloorLevel;
        if (Math.abs(diff) > Math.floor(this.getMobJumpHeight())) {
            return null;
        }
        float malus = this.mob.getPathfindingMalus(pathtype);
        if (malus >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, malus);
        }
        if (node != null) {
            int dy = node.y - y;
            if ((double)Math.abs(dy) > Math.floor(this.getMob().maxUpStep())) {
                return null;
            }
            if (p_node != null && this.cantMoveBetween(p_node, node)) {
                return null;
            }
        }
        if (node != null && node.costMalus >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (diff < -1.0 && node != null) {
            int steps;
            this.tempPos2.set(x, y, z);
            int i2 = steps = (int)(-diff);
            while ((double)i2 > diff) {
                this.tempPos2.set(x, y + 1, z);
                BlockState state = this.context.getBlockState((BlockPos)this.tempPos2);
                if (state.isSolidRender((BlockGetter)this.context.level(), (BlockPos)this.tempPos2)) {
                    return null;
                }
                --i2;
            }
        }
        if (pathtype != TravelersPathType.WALKABLE) {
            if ((node == null || node.costMalus < 0.0f) && (pathtype != TravelersPathType.FENCE || this.isCanWalkOverFences() || this.getMobJumpHeight() > (double)1.2f) && pathtype != TravelersPathType.UNPASSABLE_RAIL && pathtype != TravelersPathType.TRAPDOOR && pathtype != TravelersPathType.POWDER_SNOW) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathTypeAtCurrent, this.tempPos);
            } else if (!(this.isAmphibious() || pathtype != TravelersPathType.WATER || this.isCanFloat() && !this.mob.onGround())) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == TravelersPathType.OPEN) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (TravelersWalkNodeEvaluator.doesBlockHavePartialCollision(pathtype) && node == null) {
                node = this.getClosedNode(x, y, z, pathtype);
            }
        }
        if (this.triesToAvoidLight && node != null && pathtype == TravelersPathType.WALKABLE && (i2 = this.mob.level()) instanceof Level && (float)(darkness = 15 - (totalLight = Math.min(15, (skyLight = (level = i2).getBrightness(LightLayer.SKY, pos = node.asBlockPos())) + (blockLight = level.getBrightness(LightLayer.BLOCK, pos))))) < 2.0f) {
            node.type = TravelersPathType.LIGHT;
        }
        if (node != null) {
            if (!this.makeSureYFits(node.x, node.y, node.z)) {
                return null;
            }
            if (!this.canMobStandAt(node.x, node.y, node.z)) {
                return null;
            }
        }
        return node;
    }

    private boolean makeSureYFits(int x, int y, int z) {
        double height = this.mob.getBbHeight();
        int maxY = y + Mth.ceil((double)height) - 1;
        for (int yi = y; yi <= maxY; ++yi) {
            TravelersPathType type = this.getPathType(this.context, x, yi, z);
            if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(x, yi, z)) : !this.canClimb || !this.isClimbableAt(x, yi, z))) continue;
            return false;
        }
        return true;
    }

    private boolean isClimbableAt(int x, int y, int z) {
        this.tempPos.set(x, y, z);
        BlockState s = this.context.level().getBlockState((BlockPos)this.tempPos);
        if (this.canClimbAnyBlock) {
            return s.getCollisionShape((BlockGetter)this.context.level(), (BlockPos)this.tempPos).isEmpty();
        }
        if (!this.canClimb) {
            return false;
        }
        if (s.getBlock() instanceof LadderBlock || s.getBlock() instanceof VineBlock) {
            return true;
        }
        if (s.is(Blocks.SCAFFOLDING)) {
            return true;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            this.tempPos2.set(x, y, z).move(dir);
            BlockState sid = this.context.level().getBlockState((BlockPos)this.tempPos2);
            if (!(sid.getBlock() instanceof LadderBlock) && !(sid.getBlock() instanceof VineBlock) && !sid.is(Blocks.SCAFFOLDING)) continue;
            return true;
        }
        return false;
    }

    private double getMobJumpHeight() {
        SmartAnimalBase smartAnimalBase = this.mob;
        if (smartAnimalBase instanceof SmartAnimalBase) {
            SmartAnimalBase base = smartAnimalBase;
            return this.canClimb ? base.climbHeight() : base.jumpHeight();
        }
        return 1.0;
    }

    private TravelersNode getNodeAndUpdateCostToMax(int x, int y, int z, TravelersPathType pathType, float malus) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = pathType;
        node.costMalus = Math.max(node.costMalus, malus);
        return node;
    }

    private TravelersNode getBlockedNode(int x, int y, int z) {
        TravelersNode node = this.getNode(x, y, z);
        node.type = TravelersPathType.BLOCKED;
        node.costMalus = -1.0f;
        return node;
    }

    private TravelersNode getClosedNode(int x, int y, int z, TravelersPathType pathType) {
        TravelersNode node = this.getNode(x, y, z);
        node.closed = true;
        node.type = pathType;
        node.costMalus = pathType.getMalus();
        return node;
    }

    @Nullable
    private TravelersNode tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, TravelersPathType pathTypeAtCurrent, BlockPos.MutableBlockPos pos) {
        TravelersNode node = this.findAcceptedNode(null, x, y + 1, z, verticalDeltaLimit, nodeFloorLevel, direction, pathTypeAtCurrent);
        if (node == null) {
            return null;
        }
        if (node.type != TravelersPathType.OPEN && node.type != TravelersPathType.WALKABLE) {
            return node;
        }
        double d0 = (double)(x - direction.getStepX()) + 0.5;
        double d1 = (double)(z - direction.getStepZ()) + 0.5;
        pos.set(x, y + 1, z);
        double yMin = this.getFloorLevel((BlockPos)pos);
        pos.set((int)d0, y + (int)this.getMobJumpHeight(), (int)d1);
        double yMax = this.getFloorLevel((BlockPos)pos);
        AABB aabb = new AABB(d0 - 0.5, yMin, d1 - 0.5, d0 + 0.5, yMax, d1 + 0.5);
        if (this.hasCollisions(aabb)) {
            return null;
        }
        return node;
    }

    protected boolean canMobStandAt(int x, int y, int z) {
        int height = Mth.ceil((float)((float)this.entityHeight / 2.0f));
        for (int i = -1; i < height; ++i) {
            if (!this.isSpaceValidForStanding(x, y + i, z)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSpaceValidForStanding(int x, int y, int z) {
        double width = this.mob.getBbWidth();
        double height = this.mob.getBbHeight();
        double centerX = (double)x + 0.5;
        double centerZ = (double)z + 0.5;
        int minX = Mth.floor((double)(centerX - width / 2.0));
        int maxX = Mth.floor((double)(centerX + width / 2.0));
        int maxY = Mth.floor((double)((double)y + height));
        int minZ = Mth.floor((double)(centerZ - width / 2.0));
        int maxZ = Mth.floor((double)(centerZ + width / 2.0));
        for (int xi = minX; xi <= maxX; ++xi) {
            for (int yi = y; yi <= maxY; ++yi) {
                for (int zi = minZ; zi <= maxZ; ++zi) {
                    TravelersPathType type = this.getPathType(this.context, xi, yi, zi);
                    if (type == TravelersPathType.WALKABLE || type == TravelersPathType.OPEN || type == TravelersPathType.WATER || type == TravelersPathType.WATER_BORDER || !(this.canOpenDoors || this.canPassDoors ? type != TravelersPathType.DOOR_OPEN && type != TravelersPathType.DOOR_WOOD_CLOSED && (!this.canClimb || !this.isClimbableAt(xi, yi, zi)) : !this.canClimb || !this.isClimbableAt(xi, yi, zi))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private TravelersNode tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable TravelersNode node) {
        --y;
        while (y > this.mob.level().getMinBuildHeight()) {
            TravelersPathType pathtype = this.getPathType(x, y, z);
            if (pathtype != TravelersPathType.WATER) {
                return node;
            }
            float malus = this.mob.getPathfindingMalus(pathtype);
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathtype, malus);
            --y;
        }
        return node;
    }

    private TravelersNode tryFindFirstGroundNodeBelow(int x, int y, int z) {
        int minY = this.mob.level().getMinBuildHeight();
        for (int i = y - 1; i >= minY; --i) {
            if (y - i > this.mob.getMaxFallDistance()) {
                return this.getBlockedNode(x, i, z);
            }
            TravelersPathType pathtype = this.getPathType(x, i, z);
            float f = this.mob.getPathfindingMalus(pathtype);
            if (pathtype == TravelersPathType.OPEN) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathtype, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    private boolean hasCollisions(AABB boundingBox) {
        return !this.context.level().noCollision((Entity)this.mob, boundingBox);
    }

    protected TravelersPathType getPathType(int x, int y, int z) {
        long key = BlockPos.asLong((int)x, (int)y, (int)z);
        TravelersPathType cached = (TravelersPathType)((Object)this.pathTypesByPosCacheByMob.get(key));
        if (cached != null) {
            return cached;
        }
        TravelersPathType computed = this.getPathTypeOfMob(this.context, x, y, z, this.mob);
        this.pathTypesByPosCacheByMob.put(key, (Object)computed);
        return computed;
    }

    @Override
    public TravelersPathType getPathTypeOfMob(TravelersPathfindingContext context, int x, int y, int z, SmartAnimalBase mob) {
        Set<TravelersPathType> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains((Object)TravelersPathType.FENCE)) {
            return TravelersPathType.FENCE;
        }
        if (set.contains((Object)TravelersPathType.UNPASSABLE_RAIL)) {
            return TravelersPathType.UNPASSABLE_RAIL;
        }
        TravelersPathType best = TravelersPathType.BLOCKED;
        for (TravelersPathType t : set) {
            if (mob.getPathfindingMalus(t) < 0.0f) {
                return t;
            }
            if (!(mob.getPathfindingMalus(t) >= mob.getPathfindingMalus(best))) continue;
            best = t;
        }
        return best;
    }

    public Set<TravelersPathType> getPathTypeWithinMobBB(TravelersPathfindingContext context, int x, int y, int z) {
        EnumSet<TravelersPathType> enumset = EnumSet.noneOf(TravelersPathType.class);
        TravelersPathType type = this.getPathType(context, x, y, z);
        boolean flag = this.isCanPassDoors();
        if (type == TravelersPathType.DOOR_WOOD_CLOSED && this.isCanOpenDoors() && flag) {
            type = TravelersPathType.WALKABLE_DOOR;
        }
        if (type == TravelersPathType.DOOR_OPEN && !flag) {
            type = TravelersPathType.BLOCKED;
        }
        enumset.add(type);
        return enumset;
    }

    @Override
    @NotNull
    public TravelersPathType getPathType(@NotNull TravelersPathfindingContext context, int x, int y, int z) {
        return TravelersWalkNodeEvaluator.getPathTypeStatic(context, new BlockPos.MutableBlockPos(x, y, z));
    }

    public void setCanCrawl(boolean canCrawl) {
        this.canCrawl = canCrawl;
    }

    public boolean isTriesToAvoidLight() {
        return this.triesToAvoidLight;
    }

    public void setCanClimb(boolean canClimb) {
        this.canClimb = canClimb;
    }

    public void setCanClimbAnyBlock(boolean canClimbAnyBlock) {
        this.canClimbAnyBlock = canClimbAnyBlock;
    }

    public boolean isCanClimb() {
        return this.canClimb;
    }

    public boolean isCanClimbAnyBlock() {
        return this.canClimbAnyBlock;
    }
}

