/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import net.minecraft.world.level.pathfinder.PathType;

public enum TravelersPathType {
    BLOCKED(-1.0f),
    OPEN(0.0f),
    WALKABLE(0.0f),
    WALKABLE_DOOR(0.0f),
    TRAPDOOR(0.0f),
    POWDER_SNOW(-1.0f),
    DANGER_POWDER_SNOW(0.0f),
    FENCE(-1.0f),
    LAVA(-1.0f),
    WATER(8.0f),
    WATER_BORDER(8.0f),
    RAIL(0.0f),
    UNPASSABLE_RAIL(-1.0f),
    DANGER_FIRE(8.0f),
    DAMAGE_FIRE(16.0f),
    DANGER_OTHER(8.0f),
    DAMAGE_OTHER(-1.0f),
    DOOR_OPEN(0.0f),
    DOOR_WOOD_CLOSED(-1.0f),
    DOOR_IRON_CLOSED(-1.0f),
    BREACH(4.0f),
    LEAVES(-1.0f),
    STICKY_HONEY(8.0f),
    COCOA(0.0f),
    DAMAGE_CAUTIOUS(0.0f),
    DANGER_TRAPDOOR(0.0f),
    CRAWL(0.0f),
    DUCK(0.0f),
    JUMP(0.0f),
    LIGHT(1.0f);

    private final float malus;

    private TravelersPathType(float malus) {
        this.malus = malus;
    }

    public static TravelersPathType translate(PathType original) {
        return switch (original) {
            case PathType.OPEN -> OPEN;
            case PathType.WALKABLE -> WALKABLE;
            case PathType.WALKABLE_DOOR -> WALKABLE_DOOR;
            case PathType.TRAPDOOR -> TRAPDOOR;
            case PathType.POWDER_SNOW -> POWDER_SNOW;
            case PathType.DANGER_POWDER_SNOW -> DANGER_POWDER_SNOW;
            case PathType.FENCE -> FENCE;
            case PathType.LAVA -> LAVA;
            case PathType.WATER -> WATER;
            case PathType.WATER_BORDER -> WATER_BORDER;
            case PathType.RAIL -> RAIL;
            case PathType.UNPASSABLE_RAIL -> UNPASSABLE_RAIL;
            case PathType.DANGER_FIRE -> DANGER_FIRE;
            case PathType.DAMAGE_FIRE -> DAMAGE_FIRE;
            case PathType.DANGER_OTHER -> DANGER_OTHER;
            case PathType.DAMAGE_OTHER -> DAMAGE_OTHER;
            case PathType.DOOR_OPEN -> DOOR_OPEN;
            case PathType.DOOR_WOOD_CLOSED -> DOOR_WOOD_CLOSED;
            case PathType.DOOR_IRON_CLOSED -> DOOR_IRON_CLOSED;
            case PathType.BREACH -> BREACH;
            case PathType.LEAVES -> LEAVES;
            case PathType.STICKY_HONEY -> STICKY_HONEY;
            case PathType.COCOA -> COCOA;
            case PathType.DAMAGE_CAUTIOUS -> DAMAGE_CAUTIOUS;
            case PathType.DANGER_TRAPDOOR -> DANGER_TRAPDOOR;
            default -> BLOCKED;
        };
    }

    public float getMalus() {
        return this.malus;
    }
}

