/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.node.obj;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;
import travelers.TravelersMain;
import travelers.server.animal.entity.pathingsystem.node.TravelersNodeEvaluator;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathType;
import travelers.server.animal.entity.pathingsystem.node.obj.TravelersPathTypeCache;

public class TravelersPathfindingContext {
    public final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final CollisionGetter level;
    @Nullable
    private final TravelersPathTypeCache cache;
    private final BlockPos mobPosition;

    public TravelersPathfindingContext(CollisionGetter level, Mob mob) {
        TravelersPathTypeCache travelersPathTypeCache;
        this.level = level;
        Level level2 = mob.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            travelersPathTypeCache = TravelersMain.getCache((Level)serverLevel);
        } else {
            travelersPathTypeCache = null;
        }
        this.cache = travelersPathTypeCache;
        this.mobPosition = mob.blockPosition();
    }

    protected static TravelersPathType getPathTypeFromState(BlockGetter level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (state.isAir()) {
            return TravelersPathType.OPEN;
        }
        if (state.is(BlockTags.TRAPDOORS) || state.is(Blocks.LILY_PAD) || state.is(Blocks.BIG_DRIPLEAF)) {
            return TravelersPathType.TRAPDOOR;
        }
        if (state.is(Blocks.POWDER_SNOW)) {
            return TravelersPathType.POWDER_SNOW;
        }
        if (state.is(Blocks.CACTUS) || state.is(Blocks.SWEET_BERRY_BUSH)) {
            return TravelersPathType.DAMAGE_OTHER;
        }
        if (state.is(Blocks.HONEY_BLOCK)) {
            return TravelersPathType.STICKY_HONEY;
        }
        if (state.is(Blocks.COCOA)) {
            return TravelersPathType.COCOA;
        }
        if (state.is(Blocks.WITHER_ROSE) || state.is(Blocks.POINTED_DRIPSTONE)) {
            return TravelersPathType.DAMAGE_CAUTIOUS;
        }
        FluidState fluid = state.getFluidState();
        if (fluid.is(FluidTags.LAVA)) {
            return TravelersPathType.LAVA;
        }
        if (TravelersNodeEvaluator.isBurningBlock(state)) {
            return TravelersPathType.DAMAGE_FIRE;
        }
        Block block2 = block;
        Objects.requireNonNull(block2);
        Block block3 = block2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DoorBlock.class, BaseRailBlock.class, LeavesBlock.class}, (Object)block3, n)) {
            case 0: {
                DoorBlock door = (DoorBlock)block3;
                return (Boolean)state.getValue((Property)DoorBlock.OPEN) != false ? TravelersPathType.DOOR_OPEN : (door.type().canOpenByHand() ? TravelersPathType.DOOR_WOOD_CLOSED : TravelersPathType.DOOR_IRON_CLOSED);
            }
            case 1: {
                BaseRailBlock ignored = (BaseRailBlock)block3;
                return TravelersPathType.RAIL;
            }
            case 2: {
                LeavesBlock ignored = (LeavesBlock)block3;
                return TravelersPathType.LEAVES;
            }
        }
        if (state.is(BlockTags.FENCES) || state.is(BlockTags.WALLS) || block instanceof FenceGateBlock && !((Boolean)state.getValue((Property)FenceGateBlock.OPEN)).booleanValue()) {
            return TravelersPathType.FENCE;
        }
        if (!state.isPathfindable(PathComputationType.LAND)) {
            return TravelersPathType.BLOCKED;
        }
        return fluid.is(FluidTags.WATER) ? TravelersPathType.WATER : TravelersPathType.OPEN;
    }

    public TravelersPathType getPathTypeFromState(int x, int y, int z) {
        BlockPos.MutableBlockPos pos = this.mutablePos.set(x, y, z);
        return TravelersPathfindingContext.getPathTypeFromState((BlockGetter)this.level, (BlockPos)pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.level.getBlockState(pos);
    }

    public CollisionGetter level() {
        return this.level;
    }

    public BlockPos mobPosition() {
        return this.mobPosition;
    }

    BlockPos currentEvalPos() {
        return this.mutablePos;
    }
}

