/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.vanilla;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.vanilla.TLGoalUtils;
import travelers.server.animal.entity.pathingsystem.vanilla.TLRandomPos;

public class TLHoverRandomPos {
    private static final Random rng = new Random();

    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int yRange, double x, double z, float angleVarianceRadians, int maxSwimUp, int minSwimUp) {
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLRandomPos.generateBestRandomPos(() -> {
            BlockPos direction = TLRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, x, z, angleVarianceRadians);
            if (direction == null) {
                return null;
            }
            BlockPos toward = TLHoverRandomPos.generateValidTarget(mob, radius, restricted, direction);
            if (toward == null) {
                return null;
            }
            int swimUpAmount = rng.nextInt(maxSwimUp - minSwimUp + 1) + minSwimUp;
            BlockPos elevated = TLRandomPos.moveUpToAboveSolid(toward, swimUpAmount, mob.level().getMaxBuildHeight(), pos -> TLGoalUtils.isSolid(mob, pos));
            return TLHoverRandomPos.isValidFinalHoverTarget(mob, elevated) ? elevated : null;
        }, arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    private static BlockPos generateValidTarget(SmartAnimalBase mob, int radius, boolean restricted, BlockPos offset) {
        BlockPos candidate = TLRandomPos.generateRandomPosTowardDirection(mob, radius, offset);
        return candidate != null && !TLGoalUtils.isOutsideLimits(candidate, mob) && !TLGoalUtils.isRestricted(restricted, mob, candidate) && !TLGoalUtils.isNotStable(mob.getNavigationController(), candidate) ? candidate : null;
    }

    private static boolean isValidFinalHoverTarget(SmartAnimalBase mob, BlockPos pos) {
        return !TLGoalUtils.isWater(mob, pos) && !TLGoalUtils.hasMalus(mob, pos);
    }
}

