/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.pathingsystem.vanilla;

import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import travelers.server.animal.entity.SmartAnimalBase;
import travelers.server.animal.entity.pathingsystem.vanilla.TLGoalUtils;
import travelers.server.animal.entity.pathingsystem.vanilla.TLRandomPos;

public class TLLandRandomPos {
    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int verticalRange) {
        return TLLandRandomPos.getPos(mob, radius, verticalRange, arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    public static Vec3 getPos(SmartAnimalBase mob, int radius, int yRange, ToDoubleFunction<BlockPos> scorer) {
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = TLRandomPos.generateRandomDirection(radius, yRange);
            BlockPos candidate = TLLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? TLLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, scorer);
    }

    @Nullable
    public static Vec3 getPosTowards(SmartAnimalBase mob, int radius, int yRange, Vec3 target) {
        Vec3 direction = target.subtract(mob.position());
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    public static Vec3 getPosAway(SmartAnimalBase mob, int radius, int yRange, Vec3 dangerSource) {
        Vec3 direction = mob.position().subtract(dangerSource);
        boolean restricted = TLGoalUtils.mobRestricted(mob, radius);
        return TLLandRandomPos.getPosInDirection(mob, radius, yRange, direction, restricted);
    }

    @Nullable
    private static Vec3 getPosInDirection(SmartAnimalBase mob, int radius, int yRange, Vec3 direction, boolean restricted) {
        return TLRandomPos.generateBestRandomPos(() -> {
            BlockPos offset = TLRandomPos.generateRandomDirectionWithinRadians(radius, yRange, 0, direction.x, direction.z, 1.5707963267948966);
            if (offset == null) {
                return null;
            }
            BlockPos candidate = TLLandRandomPos.generateValidRandomTarget(mob, radius, restricted, offset);
            return candidate != null ? TLLandRandomPos.movePosUpOutOfSolid(mob, candidate) : null;
        }, arg_0 -> ((SmartAnimalBase)mob).getWalkTargetValue(arg_0));
    }

    @Nullable
    private static BlockPos movePosUpOutOfSolid(SmartAnimalBase mob, BlockPos pos) {
        return !TLGoalUtils.isWater(mob, pos = TLRandomPos.moveUpOutOfSolid(pos, mob.level().getMaxBuildHeight(), p -> TLGoalUtils.isSolid(mob, p))) && !TLGoalUtils.hasMalus(mob, pos) ? pos : null;
    }

    @Nullable
    private static BlockPos generateValidRandomTarget(SmartAnimalBase mob, int radius, boolean restricted, BlockPos offset) {
        BlockPos candidate = TLRandomPos.generateRandomPosTowardDirection(mob, radius, offset);
        return candidate != null && !TLGoalUtils.isOutsideLimits(candidate, mob) && !TLGoalUtils.isRestricted(restricted, mob, candidate) && !TLGoalUtils.isNotStable(mob.getNavigationController(), candidate) ? candidate : null;
    }
}

