/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.animal.entity.task;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import travelers.server.animal.entity.task.TaskGoal;
import travelers.server.animal.entity.task.TaskPriority;
import travelers.server.animal.entity.task.TravelerTaskBase;

public class TravelerTaskController {
    private static final Random random = new Random();
    private final HashMap<TaskGoal, TravelerTaskBase> taskOccupations = new HashMap();
    private final ArrayList<TravelerTaskBase> possibleTasks = new ArrayList();
    private final ArrayList<TravelerTaskBase> possibleTasksNoOccupations = new ArrayList();
    private int taskCooldown = 20;

    public void tickController() {
        if (this.taskCooldown > 40) {
            this.taskCooldown = 40;
        }
        HashSet<TravelerTaskBase> goals = new HashSet<TravelerTaskBase>();
        for (TaskGoal value : TaskGoal.values()) {
            TravelerTaskBase travelerTaskBase = this.taskOccupations.get((Object)value);
            if (travelerTaskBase == null) continue;
            goals.add(travelerTaskBase);
        }
        for (TravelerTaskBase goal : goals) {
            if (goal == null || !goal.requiresUpdateEveryTick() && this.taskCooldown != 0) continue;
            if (!goal.isRunning() && goal.shouldRun()) {
                goal.onStart();
                goal.run();
                continue;
            }
            if (!goal.isRunning()) continue;
            if (goal.canContinueRunning() && goal.getPriority() != TaskPriority.RUN_ONCE && !goal.isShouldStop()) {
                goal.tick();
                continue;
            }
            goal.actuallyStop();
            this.clearOccupation(goal);
        }
        for (TravelerTaskBase actualGoal : this.possibleTasksNoOccupations) {
            if (!actualGoal.requiresUpdateEveryTick() && this.taskCooldown != 0) continue;
            if (actualGoal.shouldRun() && !actualGoal.isRunning()) {
                actualGoal.onStart();
                actualGoal.run();
                continue;
            }
            if (!actualGoal.isRunning()) continue;
            if (actualGoal.canContinueRunning() && actualGoal.getPriority() != TaskPriority.RUN_ONCE && !actualGoal.isShouldStop()) {
                actualGoal.tick();
                continue;
            }
            actualGoal.actuallyStop();
        }
        if (this.taskCooldown > 0) {
            --this.taskCooldown;
            return;
        }
        if (this.possibleTasks.isEmpty() && this.possibleTasksNoOccupations.isEmpty()) {
            return;
        }
        for (TravelerTaskBase jsTaskBase : this.possibleTasks) {
            TaskPriority priority = jsTaskBase.getPriority();
            if (!jsTaskBase.shouldRun()) continue;
            for (TaskGoal taskGoal : jsTaskBase.getGoals()) {
                this.setGoalOccupied(priority, taskGoal, jsTaskBase);
            }
        }
        this.taskCooldown += 20;
    }

    private void clearOccupation(TravelerTaskBase taskBase) {
        for (TaskGoal goal : taskBase.getGoals()) {
            TravelerTaskBase task = this.taskOccupations.get((Object)goal);
            if (task == null) continue;
            this.taskOccupations.remove((Object)goal);
        }
    }

    public boolean isGoalOccupied(TaskPriority priority, TaskGoal goal) {
        if (priority == TaskPriority.DIRECT) {
            return false;
        }
        TravelerTaskBase taskOccupation = this.taskOccupations.get((Object)goal);
        if (taskOccupation != null) {
            return !TaskPriority.compare(taskOccupation.getPriority(), priority);
        }
        return true;
    }

    public boolean setGoalOccupied(TaskPriority priority, TaskGoal goal, TravelerTaskBase base) {
        if (priority == TaskPriority.NONE) {
            return false;
        }
        if (priority == TaskPriority.DIRECT) {
            this.taskOccupations.put(goal, base);
            return true;
        }
        TravelerTaskBase taskOccupation = this.taskOccupations.get((Object)goal);
        if (taskOccupation != null) {
            int currentPriorityValue = taskOccupation.getPriority().ordinal();
            int newPriorityValue = priority.ordinal();
            if (taskOccupation.getPriority().ordinal() >= TaskPriority.MEDIUM.ordinal()) {
                return false;
            }
            if (taskOccupation.canContinueRunning() && !taskOccupation.canInterrupt()) {
                return false;
            }
            boolean shouldReplace = false;
            if (newPriorityValue > currentPriorityValue) {
                shouldReplace = true;
            } else if (newPriorityValue < currentPriorityValue) {
                shouldReplace = random.nextDouble() < 0.4;
            } else {
                boolean bl = shouldReplace = random.nextDouble() < 0.6;
            }
            if (shouldReplace) {
                taskOccupation.stop();
                this.taskOccupations.put(goal, base);
                return true;
            }
            return false;
        }
        this.taskOccupations.put(goal, base);
        return true;
    }

    public void registerTask(TravelerTaskBase taskBase) {
        if (taskBase.getGoals().isEmpty()) {
            this.possibleTasksNoOccupations.add(taskBase);
        } else {
            this.possibleTasks.add(taskBase);
        }
    }

    public void stopTask(TaskGoal taskGoal) {
        TravelerTaskBase goal = this.taskOccupations.get((Object)taskGoal);
        if (goal != null) {
            goal.stop();
            this.clearOccupation(goal);
        }
    }

    public ImmutableList<TravelerTaskBase> getPossibleTasksNoOccupations() {
        return ImmutableList.copyOf(this.possibleTasksNoOccupations);
    }

    public ImmutableList<TravelerTaskBase> getPossibleTasks() {
        return ImmutableList.copyOf(this.possibleTasks);
    }
}

