/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.entity;

import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import travelers.server.animal.entity.SmartAnimalBase;

public abstract class PartEntity<T extends Entity>
extends Entity {
    private static final EntityDataAccessor<Vector3f> POS = SynchedEntityData.defineId(PartEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    protected final T entity;
    private final EntityDimensions size;
    public int parentMobId;
    public SmartAnimalBase parentMob;
    protected Color color = Color.GREEN;
    private float[] position = new float[3];

    public PartEntity(T parentMob, float width, float height) {
        super(parentMob.getType(), parentMob.level());
        this.size = EntityDimensions.scalable((float)width, (float)height);
        this.refreshDimensions();
        this.entity = parentMob;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(POS, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(POS)) {
            Vector3f pos = (Vector3f)this.entityData.get(POS);
            this.position[0] = pos.x();
            this.position[1] = pos.y();
            this.position[2] = pos.z();
            super.setPos((double)pos.x(), (double)pos.y(), (double)pos.z());
        }
    }

    public void tick(SmartAnimalBase jsAnimalBase) {
        this.setOldPosAndRot();
        this.tickPart(jsAnimalBase);
    }

    private void tickPart(SmartAnimalBase e) {
        if (e != null) {
            this.parentMobId = e.getId();
            this.parentMob = e;
        }
        this.setPos(this.position[0], this.position[1], this.position[2]);
    }

    public boolean isPickable() {
        return true;
    }

    public ItemStack getPickResult() {
        return this.entity.getPickResult();
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return this.entity.hurt(source, amount);
    }

    public boolean is(@NotNull Entity entity) {
        return this == entity;
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        return this.size;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    public void push(@NotNull Vec3 vector) {
        this.entity.push(vector);
    }

    public void push(@NotNull Entity entity) {
        this.entity.push(entity);
    }

    public void push(double x, double y, double z) {
        this.entity.push(x, y, z);
    }

    public PartEntity<T> setPosition(float[] position) {
        this.entityData.set(POS, (Object)new Vector3f(position[0], position[1], position[2]));
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float[] getPosition() {
        return this.position;
    }
}

