/*
 * Decompiled with CFR 0.152.
 */
package travelers.server.packet.obj;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import travelers.TravelersMain;
import travelers.client.misc.CameraShakeHandler;
import travelers.server.packet.TravelersPacketsHandler;

public record TravelersShakeCamera(boolean groundCheck, float strength, int length, float shakeDistance, Vector3f vector3f) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TravelersShakeCamera> TYPE = new CustomPacketPayload.Type(TravelersMain.createId("shakecamera"));
    public static final StreamCodec<ByteBuf, TravelersShakeCamera> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, TravelersShakeCamera::groundCheck, (StreamCodec)ByteBufCodecs.FLOAT, TravelersShakeCamera::strength, (StreamCodec)ByteBufCodecs.INT, TravelersShakeCamera::length, (StreamCodec)ByteBufCodecs.FLOAT, TravelersShakeCamera::shakeDistance, (StreamCodec)ByteBufCodecs.VECTOR3F, TravelersShakeCamera::vector3f, TravelersShakeCamera::new);

    public static TravelersPacketsHandler<TravelersShakeCamera> createHandler() {
        return new TravelersPacketsHandler<TravelersShakeCamera>(){

            @Override
            public void clientPacket(CustomPacketPayload packet) {
                TravelersShakeCamera packet1 = (TravelersShakeCamera)packet;
                CameraShakeHandler.startShake(packet1.groundCheck, packet1.strength, packet1.shakeDistance, packet1.length, packet1.vector3f);
            }
        };
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

